/*
 * Decompiled with CFR 0.152.
 */
package com.distribution.liquidation.upl.service.mapper;

import com.distribution.liquidation.upl.domain.AppUser;
import com.distribution.liquidation.upl.domain.Distributor;
import com.distribution.liquidation.upl.domain.Product;
import com.distribution.liquidation.upl.domain.RfidScan;
import com.distribution.liquidation.upl.service.dto.ProductDTO;
import com.distribution.liquidation.upl.service.dto.RfidScanDTO;
import com.distribution.liquidation.upl.service.mapper.AppUserMapper;
import com.distribution.liquidation.upl.service.mapper.DistributorMapper;
import com.distribution.liquidation.upl.service.mapper.ProductMapper;
import com.distribution.liquidation.upl.service.mapper.RfidScanMapper;
import java.util.ArrayList;
import java.util.List;
import org.springframework.beans.factory.annotation.Autowired;
import org.springframework.stereotype.Component;

@Component
public class RfidScanMapperImpl
implements RfidScanMapper {
    @Autowired
    private AppUserMapper appUserMapper;
    @Autowired
    private DistributorMapper distributorMapper;
    @Autowired
    private ProductMapper productMapper;

    public RfidScan toEntity(RfidScanDTO dto) {
        if (dto == null) {
            return null;
        }
        RfidScan rfidScan = new RfidScan();
        rfidScan.setId(dto.getId());
        rfidScan.setCreatedDate(dto.getCreatedDate());
        rfidScan.setScanStatus(dto.getScanStatus());
        rfidScan.appUser((AppUser)this.appUserMapper.toEntity((Object)dto.getAppUser()));
        rfidScan.distributor((Distributor)this.distributorMapper.toEntity((Object)dto.getDistributor()));
        if (dto.getProducts() != null) {
            for (ProductDTO product : dto.getProducts()) {
                rfidScan.addProduct((Product)this.productMapper.toEntity((Object)product));
            }
        }
        rfidScan.setLocationLat(dto.getLocationLat());
        rfidScan.setLocationLong(dto.getLocationLong());
        rfidScan.setLocationCity(dto.getLocationCity());
        return rfidScan;
    }

    public List<RfidScan> toEntity(List<RfidScanDTO> dtoList) {
        if (dtoList == null) {
            return null;
        }
        ArrayList<RfidScan> list = new ArrayList<RfidScan>(dtoList.size());
        for (RfidScanDTO rfidScanDTO : dtoList) {
            list.add(this.toEntity(rfidScanDTO));
        }
        return list;
    }

    public List<RfidScanDTO> toDto(List<RfidScan> entityList) {
        if (entityList == null) {
            return null;
        }
        ArrayList<RfidScanDTO> list = new ArrayList<RfidScanDTO>(entityList.size());
        for (RfidScan rfidScan : entityList) {
            list.add(this.toDto(rfidScan));
        }
        return list;
    }

    public void partialUpdate(RfidScan entity, RfidScanDTO dto) {
        if (dto == null) {
            return;
        }
        if (dto.getId() != null) {
            entity.setId(dto.getId());
        }
        if (dto.getCreatedDate() != null) {
            entity.setCreatedDate(dto.getCreatedDate());
        }
        if (dto.getScanStatus() != null) {
            entity.setScanStatus(dto.getScanStatus());
        }
        if (dto.getAppUser() != null) {
            entity.appUser((AppUser)this.appUserMapper.toEntity((Object)dto.getAppUser()));
        }
        if (dto.getDistributor() != null) {
            entity.distributor((Distributor)this.distributorMapper.toEntity((Object)dto.getDistributor()));
        }
        if (dto.getProducts() != null) {
            for (ProductDTO product : dto.getProducts()) {
                entity.addProduct((Product)this.productMapper.toEntity((Object)product));
            }
        }
        if (dto.getLocationLat() != null) {
            entity.setLocationLat(dto.getLocationLat());
        }
        if (dto.getLocationLong() != null) {
            entity.setLocationLong(dto.getLocationLong());
        }
        if (dto.getLocationCity() != null) {
            entity.setLocationCity(dto.getLocationCity());
        }
    }

    public RfidScanDTO toDto(RfidScan s) {
        if (s == null) {
            return null;
        }
        RfidScanDTO rfidScanDTO = new RfidScanDTO();
        rfidScanDTO.setAppUser(this.appUserMapper.toDtoId(s.getAppUser()));
        rfidScanDTO.setDistributor(this.distributorMapper.toDto(s.getDistributor()));
        rfidScanDTO.setId(s.getId());
        rfidScanDTO.setCreatedDate(s.getCreatedDate());
        rfidScanDTO.setScanStatus(s.getScanStatus());
        rfidScanDTO.setProducts(this.productMapper.toDto(s.getProducts()));
        rfidScanDTO.setLocationLat(s.getLocationLat());
        rfidScanDTO.setLocationLong(s.getLocationLong());
        rfidScanDTO.setLocationCity(s.getLocationCity());
        return rfidScanDTO;
    }
}

