/*
 * Decompiled with CFR 0.152.
 */
package com.distribution.liquidation.upl.service.mapper;

import com.distribution.liquidation.upl.domain.Address;
import com.distribution.liquidation.upl.domain.Distributor;
import com.distribution.liquidation.upl.domain.Product;
import com.distribution.liquidation.upl.domain.RfidScan;
import com.distribution.liquidation.upl.service.ProductQuantityService;
import com.distribution.liquidation.upl.service.dto.AddressDTO;
import com.distribution.liquidation.upl.service.dto.AppUserDTO;
import com.distribution.liquidation.upl.service.dto.DistributorDTO;
import com.distribution.liquidation.upl.service.dto.DistributorWithAllProductsDTO;
import com.distribution.liquidation.upl.service.dto.DistributorWithProductsDTO;
import com.distribution.liquidation.upl.service.dto.ProductWithSkuAndQtyDTO;
import com.distribution.liquidation.upl.service.dto.RfidScanDTO;
import com.distribution.liquidation.upl.service.mapper.AddressMapper;
import com.distribution.liquidation.upl.service.mapper.AppUserMapper;
import com.distribution.liquidation.upl.service.mapper.DistributorMapper;
import java.util.ArrayList;
import java.util.List;
import org.springframework.beans.factory.annotation.Autowired;
import org.springframework.stereotype.Component;

@Component
public class DistributorMapperImpl
implements DistributorMapper {
    @Autowired
    private AddressMapper addressMapper;
    @Autowired
    private AppUserMapper appUserMapper;

    public Distributor toEntity(DistributorDTO dto) {
        if (dto == null) {
            return null;
        }
        Distributor distributor = new Distributor();
        distributor.setId(dto.getId());
        distributor.setCode(dto.getCode());
        distributor.setName(dto.getName());
        distributor.setDeliveringPlantName(dto.getDeliveringPlantName());
        distributor.setDeliveringPlantCode(dto.getDeliveringPlantCode());
        distributor.setTerritoryCode(dto.getTerritoryCode());
        distributor.setTerritoryName(dto.getTerritoryName());
        distributor.setMobileNumber(dto.getMobileNumber());
        distributor.setEmail(dto.getEmail());
        distributor.setPriceGroup(dto.getPriceGroup());
        distributor.setStatus(dto.getStatus());
        distributor.address((Address)this.addressMapper.toEntity((Object)dto.getAddress()));
        return distributor;
    }

    public List<Distributor> toEntity(List<DistributorDTO> dtoList) {
        if (dtoList == null) {
            return null;
        }
        ArrayList<Distributor> list = new ArrayList<Distributor>(dtoList.size());
        for (DistributorDTO distributorDTO : dtoList) {
            list.add(this.toEntity(distributorDTO));
        }
        return list;
    }

    public List<DistributorDTO> toDto(List<Distributor> entityList) {
        if (entityList == null) {
            return null;
        }
        ArrayList<DistributorDTO> list = new ArrayList<DistributorDTO>(entityList.size());
        for (Distributor distributor : entityList) {
            list.add(this.toDto(distributor));
        }
        return list;
    }

    public void partialUpdate(Distributor entity, DistributorDTO dto) {
        if (dto == null) {
            return;
        }
        if (dto.getId() != null) {
            entity.setId(dto.getId());
        }
        if (dto.getCode() != null) {
            entity.setCode(dto.getCode());
        }
        if (dto.getName() != null) {
            entity.setName(dto.getName());
        }
        if (dto.getDeliveringPlantName() != null) {
            entity.setDeliveringPlantName(dto.getDeliveringPlantName());
        }
        if (dto.getDeliveringPlantCode() != null) {
            entity.setDeliveringPlantCode(dto.getDeliveringPlantCode());
        }
        if (dto.getTerritoryCode() != null) {
            entity.setTerritoryCode(dto.getTerritoryCode());
        }
        if (dto.getTerritoryName() != null) {
            entity.setTerritoryName(dto.getTerritoryName());
        }
        if (dto.getMobileNumber() != null) {
            entity.setMobileNumber(dto.getMobileNumber());
        }
        if (dto.getEmail() != null) {
            entity.setEmail(dto.getEmail());
        }
        if (dto.getPriceGroup() != null) {
            entity.setPriceGroup(dto.getPriceGroup());
        }
        if (dto.getStatus() != null) {
            entity.setStatus(dto.getStatus());
        }
        if (dto.getAddress() != null) {
            entity.address((Address)this.addressMapper.toEntity((Object)dto.getAddress()));
        }
    }

    public DistributorDTO toDto(Distributor s) {
        if (s == null) {
            return null;
        }
        DistributorDTO distributorDTO = new DistributorDTO();
        distributorDTO.setAddress((AddressDTO)this.addressMapper.toDto((Object)s.getAddress()));
        distributorDTO.setId(s.getId());
        distributorDTO.setCode(s.getCode());
        distributorDTO.setName(s.getName());
        distributorDTO.setDeliveringPlantName(s.getDeliveringPlantName());
        distributorDTO.setDeliveringPlantCode(s.getDeliveringPlantCode());
        distributorDTO.setTerritoryCode(s.getTerritoryCode());
        distributorDTO.setTerritoryName(s.getTerritoryName());
        distributorDTO.setMobileNumber(s.getMobileNumber());
        distributorDTO.setEmail(s.getEmail());
        distributorDTO.setPriceGroup(s.getPriceGroup());
        distributorDTO.setStatus(s.isStatus());
        this.setFavorite(distributorDTO, s);
        return distributorDTO;
    }

    public DistributorWithProductsDTO toDtoWithProducts(Distributor s, List<Product> topProducts, List<Product> bottomProducts, ProductQuantityService productQuantityService) {
        if (s == null && topProducts == null && bottomProducts == null) {
            return null;
        }
        DistributorWithProductsDTO distributorWithProductsDTO = new DistributorWithProductsDTO();
        if (s != null) {
            distributorWithProductsDTO.setId(s.getId());
            distributorWithProductsDTO.setCode(s.getCode());
            distributorWithProductsDTO.setName(s.getName());
            distributorWithProductsDTO.setDeliveringPlantName(s.getDeliveringPlantName());
            distributorWithProductsDTO.setDeliveringPlantCode(s.getDeliveringPlantCode());
            distributorWithProductsDTO.setTerritoryCode(s.getTerritoryCode());
            distributorWithProductsDTO.setTerritoryName(s.getTerritoryName());
            distributorWithProductsDTO.setMobileNumber(s.getMobileNumber());
            distributorWithProductsDTO.setEmail(s.getEmail());
            distributorWithProductsDTO.setPriceGroup(s.getPriceGroup());
            distributorWithProductsDTO.setStatus(s.isStatus());
            distributorWithProductsDTO.setAddress((AddressDTO)this.addressMapper.toDto((Object)s.getAddress()));
        }
        if (topProducts != null) {
            distributorWithProductsDTO.setTopProducts(this.productListToProductWithSkuAndQtyDTOList(topProducts, productQuantityService));
        }
        if (bottomProducts != null) {
            distributorWithProductsDTO.setBottomProducts(this.productListToProductWithSkuAndQtyDTOList(bottomProducts, productQuantityService));
        }
        this.setShortName(distributorWithProductsDTO, productQuantityService);
        return distributorWithProductsDTO;
    }

    public DistributorWithAllProductsDTO toDtoWithAllProducts(RfidScan rfidScan, Distributor distributor, List<Product> products, ProductQuantityService productQuantityService) {
        if (rfidScan == null && distributor == null && products == null) {
            return null;
        }
        DistributorWithAllProductsDTO distributorWithAllProductsDTO = new DistributorWithAllProductsDTO();
        if (rfidScan != null) {
            distributorWithAllProductsDTO.setRfidScan(this.rfidScanToRfidScanDTO(rfidScan, productQuantityService));
        }
        if (distributor != null) {
            distributorWithAllProductsDTO.setId(distributor.getId());
            distributorWithAllProductsDTO.setCode(distributor.getCode());
            distributorWithAllProductsDTO.setName(distributor.getName());
            distributorWithAllProductsDTO.setDeliveringPlantName(distributor.getDeliveringPlantName());
            distributorWithAllProductsDTO.setDeliveringPlantCode(distributor.getDeliveringPlantCode());
            distributorWithAllProductsDTO.setTerritoryCode(distributor.getTerritoryCode());
            distributorWithAllProductsDTO.setTerritoryName(distributor.getTerritoryName());
            distributorWithAllProductsDTO.setMobileNumber(distributor.getMobileNumber());
            distributorWithAllProductsDTO.setEmail(distributor.getEmail());
            distributorWithAllProductsDTO.setPriceGroup(distributor.getPriceGroup());
            distributorWithAllProductsDTO.setStatus(distributor.isStatus());
            distributorWithAllProductsDTO.setAddress((AddressDTO)this.addressMapper.toDto((Object)distributor.getAddress()));
        }
        if (products != null) {
            distributorWithAllProductsDTO.setProducts(this.productListToProductWithSkuAndQtyDTOList(products, productQuantityService));
        }
        this.setShortName(distributorWithAllProductsDTO, productQuantityService);
        return distributorWithAllProductsDTO;
    }

    public DistributorDTO toDtoId(Distributor distributor) {
        if (distributor == null) {
            return null;
        }
        DistributorDTO distributorDTO = new DistributorDTO();
        distributorDTO.setId(distributor.getId());
        this.setFavorite(distributorDTO, distributor);
        return distributorDTO;
    }

    protected ProductWithSkuAndQtyDTO productToProductWithSkuAndQtyDTO(Product product, ProductQuantityService productQuantityService) {
        if (product == null) {
            return null;
        }
        ProductWithSkuAndQtyDTO productWithSkuAndQtyDTO = new ProductWithSkuAndQtyDTO();
        productWithSkuAndQtyDTO.setId(product.getId());
        productWithSkuAndQtyDTO.setQuantity(product.getQuantity());
        productWithSkuAndQtyDTO.setSkuCode(product.getSkuCode());
        productWithSkuAndQtyDTO.setProductCode(product.getProductCode());
        return productWithSkuAndQtyDTO;
    }

    protected List<ProductWithSkuAndQtyDTO> productListToProductWithSkuAndQtyDTOList(List<Product> list, ProductQuantityService productQuantityService) {
        if (list == null) {
            return null;
        }
        ArrayList<ProductWithSkuAndQtyDTO> list1 = new ArrayList<ProductWithSkuAndQtyDTO>(list.size());
        for (Product product : list) {
            list1.add(this.productToProductWithSkuAndQtyDTO(product, productQuantityService));
        }
        return list1;
    }

    protected RfidScanDTO rfidScanToRfidScanDTO(RfidScan rfidScan, ProductQuantityService productQuantityService) {
        if (rfidScan == null) {
            return null;
        }
        RfidScanDTO rfidScanDTO = new RfidScanDTO();
        rfidScanDTO.setAppUser((AppUserDTO)this.appUserMapper.toDto((Object)rfidScan.getAppUser()));
        rfidScanDTO.setId(rfidScan.getId());
        rfidScanDTO.setCreatedDate(rfidScan.getCreatedDate());
        rfidScanDTO.setScanStatus(rfidScan.getScanStatus());
        rfidScanDTO.setLocationLat(rfidScan.getLocationLat());
        rfidScanDTO.setLocationLong(rfidScan.getLocationLong());
        rfidScanDTO.setLocationCity(rfidScan.getLocationCity());
        return rfidScanDTO;
    }
}

