/*
 * Decompiled with CFR 0.152.
 */
package com.distribution.liquidation.upl.service.impl;

import com.distribution.liquidation.upl.domain.Distributor;
import com.distribution.liquidation.upl.repository.DistributorRepository;
import com.distribution.liquidation.upl.service.DistributorService;
import com.distribution.liquidation.upl.service.dto.DistributorDTO;
import com.distribution.liquidation.upl.service.mapper.DistributorMapper;
import java.util.Optional;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;
import org.springframework.data.domain.Page;
import org.springframework.data.domain.Pageable;
import org.springframework.stereotype.Service;
import org.springframework.transaction.annotation.Transactional;

@Service
@Transactional
public class DistributorServiceImpl
implements DistributorService {
    private final Logger log = LoggerFactory.getLogger(DistributorServiceImpl.class);
    private final DistributorRepository distributorRepository;
    private final DistributorMapper distributorMapper;

    public DistributorServiceImpl(DistributorRepository distributorRepository, DistributorMapper distributorMapper) {
        this.distributorRepository = distributorRepository;
        this.distributorMapper = distributorMapper;
    }

    public DistributorDTO save(DistributorDTO distributorDTO) {
        this.log.debug("Request to save Distributor : {}", (Object)distributorDTO);
        Distributor distributor = (Distributor)this.distributorMapper.toEntity((Object)distributorDTO);
        distributor = (Distributor)this.distributorRepository.save((Object)distributor);
        return this.distributorMapper.toDto(distributor);
    }

    public Optional<DistributorDTO> partialUpdate(DistributorDTO distributorDTO) {
        this.log.debug("Request to partially update Distributor : {}", (Object)distributorDTO);
        return this.distributorRepository.findById((Object)distributorDTO.getId()).map(existingDistributor -> {
            this.distributorMapper.partialUpdate(existingDistributor, (Object)distributorDTO);
            return existingDistributor;
        }).map(arg_0 -> ((DistributorRepository)this.distributorRepository).save(arg_0)).map(arg_0 -> ((DistributorMapper)this.distributorMapper).toDto(arg_0));
    }

    @Transactional(readOnly=true)
    public Page<DistributorDTO> findAll(Pageable pageable) {
        this.log.debug("Request to get all Distributors");
        return this.distributorRepository.findAll(pageable).map(arg_0 -> ((DistributorMapper)this.distributorMapper).toDto(arg_0));
    }

    @Transactional(readOnly=true)
    public Optional<DistributorDTO> findOne(Long id) {
        this.log.debug("Request to get Distributor : {}", (Object)id);
        Optional<DistributorDTO> distributorDTO = this.distributorRepository.findById((Object)id).map(arg_0 -> ((DistributorMapper)this.distributorMapper).toDto(arg_0));
        return distributorDTO;
    }

    @Transactional(readOnly=true)
    public Optional<DistributorDTO> findOneByCode(String code) {
        this.log.debug("Request to get Distributor by code : {}", (Object)code);
        Optional<DistributorDTO> distributorDTO = this.distributorRepository.findByCodeAndStatusIsTrue(code).map(arg_0 -> ((DistributorMapper)this.distributorMapper).toDto(arg_0));
        return distributorDTO;
    }

    public void delete(Long id) {
        this.log.debug("Request to delete Distributor : {}", (Object)id);
        this.distributorRepository.deleteById((Object)id);
    }
}

