/*
 * Decompiled with CFR 0.152.
 */
package com.distribution.liquidation.upl.service;

import com.distribution.liquidation.upl.domain.Address;
import com.distribution.liquidation.upl.domain.Address_;
import com.distribution.liquidation.upl.domain.Distributor;
import com.distribution.liquidation.upl.domain.Distributor_;
import com.distribution.liquidation.upl.domain.FavoriteDistributor_;
import com.distribution.liquidation.upl.repository.DistributorRepository;
import com.distribution.liquidation.upl.service.criteria.DistributorCriteria;
import com.distribution.liquidation.upl.service.dto.DistributorDTO;
import com.distribution.liquidation.upl.service.dto.FileDTO;
import com.distribution.liquidation.upl.service.mapper.DistributorMapper;
import java.io.ByteArrayOutputStream;
import java.io.IOException;
import java.util.Arrays;
import java.util.List;
import java.util.Objects;
import java.util.stream.Collectors;
import javax.persistence.criteria.JoinType;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;
import org.springframework.data.domain.Page;
import org.springframework.data.domain.Pageable;
import org.springframework.data.jpa.domain.Specification;
import org.springframework.stereotype.Service;
import org.springframework.transaction.annotation.Transactional;
import tech.jhipster.service.QueryService;
import tech.jhipster.service.filter.Filter;
import tech.jhipster.service.filter.RangeFilter;

@Service
@Transactional(readOnly=true)
public class DistributorQueryService
extends QueryService<Distributor> {
    private final Logger log = LoggerFactory.getLogger(DistributorQueryService.class);
    private final DistributorRepository distributorRepository;
    private final DistributorMapper distributorMapper;

    public DistributorQueryService(DistributorRepository distributorRepository, DistributorMapper distributorMapper) {
        this.distributorRepository = distributorRepository;
        this.distributorMapper = distributorMapper;
    }

    @Transactional(readOnly=true)
    public List<DistributorDTO> findByCriteria(DistributorCriteria criteria, Long appUserId) {
        this.log.debug("find by criteria : {}", (Object)criteria);
        Specification specification = this.createSpecification(criteria);
        return this.distributorRepository.findAll(specification).stream().map(arg_0 -> ((DistributorMapper)this.distributorMapper).toDto(arg_0)).collect(Collectors.toList());
    }

    @Transactional(readOnly=true)
    public Page<DistributorDTO> findByCriteria(DistributorCriteria criteria, Pageable page, Long appUserId) {
        this.log.debug("find by criteria : {}, page: {}", (Object)criteria, (Object)page);
        Specification specification = this.createSpecification(criteria);
        return this.distributorRepository.findAll(specification, page).map(arg_0 -> ((DistributorMapper)this.distributorMapper).toDto(arg_0));
    }

    @Transactional(readOnly=true)
    public long countByCriteria(DistributorCriteria criteria) {
        this.log.debug("count by criteria : {}", (Object)criteria);
        Specification specification = this.createSpecification(criteria);
        return this.distributorRepository.count(specification);
    }

    protected Specification<Distributor> createSpecification(DistributorCriteria criteria) {
        Specification specification = Specification.where(null);
        Specification orSpecification = Specification.where(null);
        if (criteria != null) {
            if (criteria.getDistinct() != null) {
                specification = specification.and(this.distinct(criteria.getDistinct().booleanValue()));
            }
            if (criteria.getId() != null) {
                specification = specification.and(this.buildRangeSpecification((RangeFilter)criteria.getId(), Distributor_.id));
            }
            if (criteria.getCode() != null) {
                specification = specification.and(this.buildStringSpecification(criteria.getCode(), Distributor_.code));
            }
            if (criteria.getName() != null) {
                specification = specification.and(this.buildStringSpecification(criteria.getName(), Distributor_.name));
            }
            if (criteria.getOrCode() != null) {
                orSpecification = orSpecification.or(this.buildStringSpecification(criteria.getOrCode(), Distributor_.code));
            }
            if (criteria.getOrName() != null) {
                orSpecification = orSpecification.or(this.buildStringSpecification(criteria.getOrName(), Distributor_.name));
            }
            if (criteria.getDeliveringPlantName() != null) {
                specification = specification.and(this.buildStringSpecification(criteria.getDeliveringPlantName(), Distributor_.deliveringPlantName));
            }
            if (criteria.getDeliveringPlantCode() != null) {
                specification = specification.and(this.buildStringSpecification(criteria.getDeliveringPlantCode(), Distributor_.deliveringPlantCode));
            }
            if (criteria.getTerritoryCode() != null) {
                specification = specification.and(this.buildRangeSpecification((RangeFilter)criteria.getTerritoryCode(), Distributor_.territoryCode));
            }
            if (criteria.getTerritoryName() != null) {
                specification = specification.and(this.buildStringSpecification(criteria.getTerritoryName(), Distributor_.territoryName));
            }
            if (criteria.getMobileNumber() != null) {
                specification = specification.and(this.buildStringSpecification(criteria.getMobileNumber(), Distributor_.mobileNumber));
            }
            if (criteria.getEmail() != null) {
                specification = specification.and(this.buildStringSpecification(criteria.getEmail(), Distributor_.email));
            }
            if (criteria.getPriceGroup() != null) {
                specification = specification.and(this.buildSpecification((Filter)criteria.getPriceGroup(), Distributor_.priceGroup));
            }
            if (criteria.getStatus() != null) {
                specification = specification.and(this.buildSpecification((Filter)criteria.getStatus(), Distributor_.status));
            }
            if (criteria.getFavorite() != null) {
                if (Objects.nonNull(criteria.getFavorite().getEquals()) && ((Boolean)criteria.getFavorite().getEquals()).equals(true)) {
                    specification = specification.and(this.buildSpecification((Filter)criteria.getFavorite(), root -> root.join(Distributor_.favoriteDistributors, JoinType.LEFT).get(FavoriteDistributor_.isFavorite)));
                } else if (Objects.nonNull(criteria.getFavorite().getSpecified()) && criteria.getFavorite().getSpecified().equals(false)) {
                    orSpecification = orSpecification.and(this.buildSpecification((Filter)criteria.getFavorite(), root -> root.join(Distributor_.favoriteDistributors, JoinType.LEFT).get(FavoriteDistributor_.isFavorite)));
                    criteria.getFavorite().setEquals((Object)false);
                    orSpecification = orSpecification.or(this.buildSpecification((Filter)criteria.getFavorite(), root -> root.join(Distributor_.favoriteDistributors, JoinType.LEFT).get(FavoriteDistributor_.isFavorite)));
                }
            }
            if (criteria.getAddressId() != null) {
                specification = specification.and(this.buildSpecification((RangeFilter)criteria.getAddressId(), root -> root.join(Distributor_.address, JoinType.LEFT).get(Address_.id)));
            }
        }
        return specification.and(orSpecification);
    }

    public FileDTO exportByCriteria(DistributorCriteria criteria) throws IOException {
        this.log.debug("export by criteria : {}", (Object)criteria);
        Specification specification = this.createSpecification(criteria);
        List<String> csvHeader = Arrays.asList("Distributor Code", "Distributor Name", "State", "City", "ZIP Code", "Territory Associated", "Territory Name");
        ByteArrayOutputStream bos = new ByteArrayOutputStream();
        csvHeader.forEach(s -> {
            try {
                bos.write(s.getBytes());
                bos.write(",".getBytes());
            }
            catch (IOException e) {
                e.printStackTrace();
            }
        });
        bos.write("\n".getBytes());
        this.distributorRepository.findAll(specification).forEach(distributor -> {
            Address address = distributor.getAddress();
            try {
                bos.write(String.valueOf(distributor.getCode()).getBytes());
                bos.write(",".getBytes());
                bos.write(distributor.getName().getBytes());
                bos.write(",".getBytes());
                bos.write(address.getState().getBytes());
                bos.write(",".getBytes());
                bos.write(address.getCity().getBytes());
                bos.write(",".getBytes());
                bos.write(address.getPincode().getBytes());
                bos.write(",".getBytes());
                bos.write(String.valueOf(distributor.getTerritoryCode()).getBytes());
                bos.write(",".getBytes());
                bos.write(distributor.getTerritoryName().getBytes());
            }
            catch (IOException e) {
                e.printStackTrace();
            }
            try {
                bos.write("\n".getBytes());
            }
            catch (IOException e) {
                e.printStackTrace();
            }
        });
        bos.close();
        return new FileDTO("distributor.csv", bos.toByteArray());
    }
}

