/*
 * Decompiled with CFR 0.152.
 */
package com.distribution.liquidation.upl.domain;

import com.distribution.liquidation.upl.domain.AppUser;
import com.distribution.liquidation.upl.domain.Distributor;
import com.distribution.liquidation.upl.domain.Product;
import com.distribution.liquidation.upl.domain.enumeration.ScanStatus;
import com.fasterxml.jackson.annotation.JsonIgnoreProperties;
import java.io.Serializable;
import java.time.Instant;
import java.util.List;
import javax.persistence.CascadeType;
import javax.persistence.Column;
import javax.persistence.Entity;
import javax.persistence.EnumType;
import javax.persistence.Enumerated;
import javax.persistence.FetchType;
import javax.persistence.GeneratedValue;
import javax.persistence.GenerationType;
import javax.persistence.Id;
import javax.persistence.ManyToOne;
import javax.persistence.OneToMany;
import javax.persistence.Table;
import javax.validation.constraints.NotNull;
import org.hibernate.annotations.Cache;
import org.hibernate.annotations.CacheConcurrencyStrategy;
import org.springframework.data.annotation.CreatedDate;

@Entity
@Table(name="rfid_scan")
@Cache(usage=CacheConcurrencyStrategy.READ_WRITE)
public class RfidScan
implements Serializable {
    private static final long serialVersionUID = 1L;
    @Id
    @GeneratedValue(strategy=GenerationType.IDENTITY)
    @Column(name="id")
    private Long id;
    @NotNull
    @CreatedDate
    @Column(name="created_date", nullable=false)
    private Instant createdDate = Instant.now();
    @NotNull
    @Enumerated(value=EnumType.STRING)
    @Column(name="scan_status", nullable=false)
    private ScanStatus scanStatus;
    @NotNull
    @Column(name="location_lat", nullable=false)
    private Double locationLat;
    @NotNull
    @Column(name="location_long", nullable=false)
    private Double locationLong;
    @NotNull
    @Column(name="location_city", nullable=false)
    private String locationCity;
    @ManyToOne(fetch=FetchType.LAZY)
    private AppUser appUser;
    @ManyToOne(fetch=FetchType.LAZY)
    @JsonIgnoreProperties(value={"address", "appUser"}, allowSetters=true)
    private Distributor distributor;
    @OneToMany(mappedBy="rfidScan", cascade={CascadeType.ALL}, orphanRemoval=true)
    @JsonIgnoreProperties(value={"rfidScan"}, allowSetters=true)
    private List<Product> products;

    public Long getId() {
        return this.id;
    }

    public RfidScan id(Long id) {
        this.setId(id);
        return this;
    }

    public void setId(Long id) {
        this.id = id;
    }

    public Instant getCreatedDate() {
        return this.createdDate;
    }

    public RfidScan createdDate(Instant createdDate) {
        this.setCreatedDate(createdDate);
        return this;
    }

    public void setCreatedDate(Instant createdDate) {
        this.createdDate = createdDate;
    }

    public ScanStatus getScanStatus() {
        return this.scanStatus;
    }

    public RfidScan scanStatus(ScanStatus scanStatus) {
        this.setScanStatus(scanStatus);
        return this;
    }

    public void setScanStatus(ScanStatus scanStatus) {
        this.scanStatus = scanStatus;
    }

    public AppUser getAppUser() {
        return this.appUser;
    }

    public void setAppUser(AppUser appUser) {
        this.appUser = appUser;
    }

    public RfidScan appUser(AppUser appUser) {
        this.setAppUser(appUser);
        return this;
    }

    public Distributor getDistributor() {
        return this.distributor;
    }

    public void setDistributor(Distributor distributor) {
        this.distributor = distributor;
    }

    public RfidScan distributor(Distributor distributor) {
        this.setDistributor(distributor);
        return this;
    }

    public List<Product> getProducts() {
        return this.products;
    }

    public void addProduct(Product product) {
        this.products.add(product);
        product.setRfidScan(this);
    }

    public void removeProduct(Product product) {
        this.products.remove(product);
        product.setRfidScan(null);
    }

    public void setProducts(List<Product> products) {
        this.products = products;
    }

    public RfidScan products(List<Product> products) {
        this.setProducts(products);
        return this;
    }

    public Double getLocationLat() {
        return this.locationLat;
    }

    public void setLocationLat(Double locationLat) {
        this.locationLat = locationLat;
    }

    public Double getLocationLong() {
        return this.locationLong;
    }

    public void setLocationLong(Double locationLong) {
        this.locationLong = locationLong;
    }

    public String getLocationCity() {
        return this.locationCity;
    }

    public void setLocationCity(String locationCity) {
        this.locationCity = locationCity;
    }

    public boolean equals(Object o) {
        if (this == o) {
            return true;
        }
        if (!(o instanceof RfidScan)) {
            return false;
        }
        return this.id != null && this.id.equals(((RfidScan)o).id);
    }

    public int hashCode() {
        return this.getClass().hashCode();
    }

    public String toString() {
        return "RfidScan{id=" + this.getId() + ", createdDate='" + this.getCreatedDate() + "', scanStatus='" + this.getScanStatus() + "'}";
    }
}

