/*
 * Decompiled with CFR 0.152.
 */
package com.distribution.liquidation.upl.aop.logging;

import com.distribution.liquidation.upl.security.SecurityUtils;
import java.util.Arrays;
import javax.persistence.EntityManager;
import org.aspectj.lang.JoinPoint;
import org.aspectj.lang.ProceedingJoinPoint;
import org.aspectj.lang.annotation.AfterThrowing;
import org.aspectj.lang.annotation.Around;
import org.aspectj.lang.annotation.Aspect;
import org.aspectj.lang.annotation.Pointcut;
import org.hibernate.Filter;
import org.hibernate.Session;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;
import org.springframework.beans.factory.annotation.Autowired;
import org.springframework.core.env.Environment;
import org.springframework.core.env.Profiles;

@Aspect
public class LoggingAspect {
    private final Environment env;
    @Autowired
    private EntityManager entityManager;

    public LoggingAspect(Environment env) {
        this.env = env;
    }

    @Pointcut(value="within(@org.springframework.stereotype.Repository *) || within(@org.springframework.stereotype.Service *) || within(@org.springframework.web.bind.annotation.RestController *)")
    public void springBeanPointcut() {
    }

    @Pointcut(value="within(com.distribution.liquidation.upl.repository..*) || within(com.distribution.liquidation.upl.service..*) || within(com.distribution.liquidation.upl.web.rest..*)")
    public void applicationPackagePointcut() {
    }

    private Logger logger(JoinPoint joinPoint) {
        return LoggerFactory.getLogger((String)joinPoint.getSignature().getDeclaringTypeName());
    }

    @AfterThrowing(pointcut="applicationPackagePointcut() && springBeanPointcut()", throwing="e")
    public void logAfterThrowing(JoinPoint joinPoint, Throwable e) {
        if (this.env.acceptsProfiles(Profiles.of((String[])new String[]{"dev"}))) {
            this.logger(joinPoint).error("Exception in {}() with cause = '{}' and exception = '{}'", new Object[]{joinPoint.getSignature().getName(), e.getCause() != null ? e.getCause() : "NULL", e.getMessage(), e});
        } else {
            this.logger(joinPoint).error("Exception in {}() with cause = {}", (Object)joinPoint.getSignature().getName(), e.getCause() != null ? e.getCause() : "NULL");
        }
    }

    @Around(value="applicationPackagePointcut() && springBeanPointcut()")
    public Object logAround(ProceedingJoinPoint joinPoint) throws Throwable {
        Logger log;
        boolean appUserAvailable = SecurityUtils.getCurrentUserLogin().isPresent() && !((String)SecurityUtils.getCurrentUserLogin().get()).equalsIgnoreCase("anonymousUser");
        Session session = (Session)this.entityManager.unwrap(Session.class);
        if (appUserAvailable) {
            Filter filter = session.enableFilter("forAppUserOnly");
            filter.setParameter("appUserId", (Object)Long.valueOf((String)SecurityUtils.getCurrentUserLogin().get()));
        }
        if ((log = this.logger((JoinPoint)joinPoint)).isDebugEnabled()) {
            log.debug("Enter: {}() with argument[s] = {}", (Object)joinPoint.getSignature().getName(), (Object)Arrays.toString(joinPoint.getArgs()));
        }
        try {
            Object result = joinPoint.proceed();
            if (log.isDebugEnabled()) {
                log.debug("Exit: {}() with result = {}", (Object)joinPoint.getSignature().getName(), result);
            }
            if (appUserAvailable) {
                session.disableFilter("forAppUserOnly");
            }
            return result;
        }
        catch (IllegalArgumentException e) {
            log.error("Illegal argument: {} in {}()", (Object)Arrays.toString(joinPoint.getArgs()), (Object)joinPoint.getSignature().getName());
            throw e;
        }
    }
}

