/*
 * Decompiled with CFR 0.152.
 */
package com.distribution.liquidation.upl.web.rest;

import com.distribution.liquidation.upl.repository.AddressRepository;
import com.distribution.liquidation.upl.service.AddressService;
import com.distribution.liquidation.upl.service.dto.AddressDTO;
import com.distribution.liquidation.upl.web.rest.errors.BadRequestAlertException;
import java.net.URI;
import java.net.URISyntaxException;
import java.util.List;
import java.util.Objects;
import java.util.Optional;
import javax.validation.Valid;
import javax.validation.constraints.NotNull;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;
import org.springframework.beans.factory.annotation.Value;
import org.springframework.http.HttpHeaders;
import org.springframework.http.ResponseEntity;
import org.springframework.web.bind.annotation.DeleteMapping;
import org.springframework.web.bind.annotation.GetMapping;
import org.springframework.web.bind.annotation.PatchMapping;
import org.springframework.web.bind.annotation.PathVariable;
import org.springframework.web.bind.annotation.PostMapping;
import org.springframework.web.bind.annotation.PutMapping;
import org.springframework.web.bind.annotation.RequestBody;
import org.springframework.web.bind.annotation.RequestMapping;
import org.springframework.web.bind.annotation.RequestParam;
import org.springframework.web.bind.annotation.RestController;
import tech.jhipster.web.util.HeaderUtil;
import tech.jhipster.web.util.ResponseUtil;

@RestController
@RequestMapping(value={"/api"})
public class AddressResource {
    private final Logger log = LoggerFactory.getLogger(AddressResource.class);
    private static final String ENTITY_NAME = "address";
    @Value(value="${jhipster.clientApp.name}")
    private String applicationName;
    private final AddressService addressService;
    private final AddressRepository addressRepository;

    public AddressResource(AddressService addressService, AddressRepository addressRepository) {
        this.addressService = addressService;
        this.addressRepository = addressRepository;
    }

    @PostMapping(value={"/addresses"})
    public ResponseEntity<AddressDTO> createAddress(@Valid @RequestBody AddressDTO addressDTO) throws URISyntaxException {
        this.log.debug("REST request to save Address : {}", (Object)addressDTO);
        if (addressDTO.getId() != null) {
            throw new BadRequestAlertException("A new address cannot already have an ID", ENTITY_NAME, "idexists");
        }
        AddressDTO result = this.addressService.save(addressDTO);
        return ((ResponseEntity.BodyBuilder)ResponseEntity.created((URI)new URI("/api/addresses/" + result.getId())).headers(HeaderUtil.createEntityCreationAlert((String)this.applicationName, (boolean)false, (String)ENTITY_NAME, (String)result.getId().toString()))).body((Object)result);
    }

    @PutMapping(value={"/addresses/{id}"})
    public ResponseEntity<AddressDTO> updateAddress(@PathVariable(value="id", required=false) Long id, @Valid @RequestBody AddressDTO addressDTO) throws URISyntaxException {
        this.log.debug("REST request to update Address : {}, {}", (Object)id, (Object)addressDTO);
        if (addressDTO.getId() == null) {
            throw new BadRequestAlertException("Invalid id", ENTITY_NAME, "idnull");
        }
        if (!Objects.equals(id, addressDTO.getId())) {
            throw new BadRequestAlertException("Invalid ID", ENTITY_NAME, "idinvalid");
        }
        if (!this.addressRepository.existsById((Object)id)) {
            throw new BadRequestAlertException("Entity not found", ENTITY_NAME, "idnotfound");
        }
        AddressDTO result = this.addressService.save(addressDTO);
        return ((ResponseEntity.BodyBuilder)ResponseEntity.ok().headers(HeaderUtil.createEntityUpdateAlert((String)this.applicationName, (boolean)false, (String)ENTITY_NAME, (String)addressDTO.getId().toString()))).body((Object)result);
    }

    @PatchMapping(value={"/addresses/{id}"}, consumes={"application/json", "application/merge-patch+json"})
    public ResponseEntity<AddressDTO> partialUpdateAddress(@PathVariable(value="id", required=false) Long id, @NotNull @RequestBody AddressDTO addressDTO) throws URISyntaxException {
        this.log.debug("REST request to partial update Address partially : {}, {}", (Object)id, (Object)addressDTO);
        if (addressDTO.getId() == null) {
            throw new BadRequestAlertException("Invalid id", ENTITY_NAME, "idnull");
        }
        if (!Objects.equals(id, addressDTO.getId())) {
            throw new BadRequestAlertException("Invalid ID", ENTITY_NAME, "idinvalid");
        }
        if (!this.addressRepository.existsById((Object)id)) {
            throw new BadRequestAlertException("Entity not found", ENTITY_NAME, "idnotfound");
        }
        Optional result = this.addressService.partialUpdate(addressDTO);
        return ResponseUtil.wrapOrNotFound((Optional)result, (HttpHeaders)HeaderUtil.createEntityUpdateAlert((String)this.applicationName, (boolean)false, (String)ENTITY_NAME, (String)addressDTO.getId().toString()));
    }

    @GetMapping(value={"/addresses"})
    public List<AddressDTO> getAllAddresses(@RequestParam(required=false) String filter) {
        if ("distributor-is-null".equals(filter)) {
            this.log.debug("REST request to get all Addresss where distributor is null");
            return this.addressService.findAllWhereDistributorIsNull();
        }
        this.log.debug("REST request to get all Addresses");
        return this.addressService.findAll();
    }

    @GetMapping(value={"/addresses/{id}"})
    public ResponseEntity<AddressDTO> getAddress(@PathVariable Long id) {
        this.log.debug("REST request to get Address : {}", (Object)id);
        Optional addressDTO = this.addressService.findOne(id);
        return ResponseUtil.wrapOrNotFound((Optional)addressDTO);
    }

    @DeleteMapping(value={"/addresses/{id}"})
    public ResponseEntity<Void> deleteAddress(@PathVariable Long id) {
        this.log.debug("REST request to delete Address : {}", (Object)id);
        this.addressService.delete(id);
        return ResponseEntity.noContent().headers(HeaderUtil.createEntityDeletionAlert((String)this.applicationName, (boolean)false, (String)ENTITY_NAME, (String)id.toString())).build();
    }
}

