/*
 * Decompiled with CFR 0.152.
 */
package com.distribution.liquidation.upl.service;

import com.distribution.liquidation.upl.domain.AppUser_;
import com.distribution.liquidation.upl.domain.Distributor_;
import com.distribution.liquidation.upl.domain.RfidScan;
import com.distribution.liquidation.upl.domain.RfidScan_;
import com.distribution.liquidation.upl.repository.RfidScanRepository;
import com.distribution.liquidation.upl.service.criteria.RfidScanCriteria;
import com.distribution.liquidation.upl.service.dto.RfidScanDTO;
import com.distribution.liquidation.upl.service.mapper.RfidScanMapper;
import java.util.List;
import javax.persistence.criteria.JoinType;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;
import org.springframework.data.domain.Page;
import org.springframework.data.domain.Pageable;
import org.springframework.data.jpa.domain.Specification;
import org.springframework.stereotype.Service;
import org.springframework.transaction.annotation.Transactional;
import tech.jhipster.service.QueryService;
import tech.jhipster.service.filter.Filter;
import tech.jhipster.service.filter.RangeFilter;

@Service
@Transactional(readOnly=true)
public class RfidScanQueryService
extends QueryService<RfidScan> {
    private final Logger log = LoggerFactory.getLogger(RfidScanQueryService.class);
    private final RfidScanRepository rfidScanRepository;
    private final RfidScanMapper rfidScanMapper;

    public RfidScanQueryService(RfidScanRepository rfidScanRepository, RfidScanMapper rfidScanMapper) {
        this.rfidScanRepository = rfidScanRepository;
        this.rfidScanMapper = rfidScanMapper;
    }

    @Transactional(readOnly=true)
    public List<RfidScanDTO> findByCriteria(RfidScanCriteria criteria) {
        this.log.debug("find by criteria : {}", (Object)criteria);
        Specification specification = this.createSpecification(criteria);
        return this.rfidScanMapper.toDto(this.rfidScanRepository.findAll(specification));
    }

    @Transactional(readOnly=true)
    public Page<RfidScanDTO> findByCriteria(RfidScanCriteria criteria, Pageable page) {
        this.log.debug("find by criteria : {}, page: {}", (Object)criteria, (Object)page);
        Specification specification = this.createSpecification(criteria);
        return this.rfidScanRepository.findAll(specification, page).map(arg_0 -> ((RfidScanMapper)this.rfidScanMapper).toDto(arg_0));
    }

    @Transactional(readOnly=true)
    public long countByCriteria(RfidScanCriteria criteria) {
        this.log.debug("count by criteria : {}", (Object)criteria);
        Specification specification = this.createSpecification(criteria);
        return this.rfidScanRepository.count(specification);
    }

    protected Specification<RfidScan> createSpecification(RfidScanCriteria criteria) {
        Specification specification = Specification.where(null);
        if (criteria != null) {
            if (criteria.getDistinct() != null) {
                specification = specification.and(this.distinct(criteria.getDistinct().booleanValue()));
            }
            if (criteria.getId() != null) {
                specification = specification.and(this.buildRangeSpecification((RangeFilter)criteria.getId(), RfidScan_.id));
            }
            if (criteria.getCreatedDate() != null) {
                specification = specification.and(this.buildRangeSpecification((RangeFilter)criteria.getCreatedDate(), RfidScan_.createdDate));
            }
            if (criteria.getScanStatus() != null) {
                specification = specification.and(this.buildSpecification((Filter)criteria.getScanStatus(), RfidScan_.scanStatus));
            }
            if (criteria.getLocationCity() != null) {
                specification = specification.and(this.buildStringSpecification(criteria.getLocationCity(), RfidScan_.locationCity));
            }
            if (criteria.getLocationLat() != null) {
                specification = specification.and(this.buildSpecification((Filter)criteria.getLocationLat(), RfidScan_.locationLat));
            }
            if (criteria.getLocationLong() != null) {
                specification = specification.and(this.buildSpecification((Filter)criteria.getLocationLong(), RfidScan_.locationLong));
            }
            if (criteria.getAppUserId() != null) {
                specification = specification.and(this.buildSpecification((RangeFilter)criteria.getAppUserId(), root -> root.join(RfidScan_.appUser, JoinType.LEFT).get(AppUser_.id)));
            }
            if (criteria.getDistributorId() != null) {
                specification = specification.and(this.buildSpecification((RangeFilter)criteria.getDistributorId(), root -> root.join(RfidScan_.distributor, JoinType.LEFT).get(Distributor_.id)));
            }
        }
        return specification;
    }
}

