/*
 * Decompiled with CFR 0.152.
 */
package com.distribution.liquidation.upl.service.mapper;

import com.distribution.liquidation.upl.domain.AppUser;
import com.distribution.liquidation.upl.domain.Distributor;
import com.distribution.liquidation.upl.domain.FavoriteDistributor;
import com.distribution.liquidation.upl.domain.FavoriteDistributorKey;
import com.distribution.liquidation.upl.service.dto.AppUserDTO;
import com.distribution.liquidation.upl.service.dto.DistributorDTO;
import com.distribution.liquidation.upl.service.dto.FavoriteDistributorDTO;
import com.distribution.liquidation.upl.service.mapper.AppUserMapper;
import com.distribution.liquidation.upl.service.mapper.DistributorMapper;
import com.distribution.liquidation.upl.service.mapper.FavoriteDistributorMapper;
import java.util.ArrayList;
import java.util.List;
import org.springframework.beans.factory.annotation.Autowired;
import org.springframework.stereotype.Component;

@Component
public class FavoriteDistributorMapperImpl
implements FavoriteDistributorMapper {
    @Autowired
    private AppUserMapper appUserMapper;
    @Autowired
    private DistributorMapper distributorMapper;

    public FavoriteDistributorDTO toDto(FavoriteDistributor entity) {
        if (entity == null) {
            return null;
        }
        FavoriteDistributorDTO favoriteDistributorDTO = new FavoriteDistributorDTO();
        favoriteDistributorDTO.setAppUser((AppUserDTO)this.appUserMapper.toDto((Object)entity.getAppUser()));
        favoriteDistributorDTO.setDistributor(this.distributorMapper.toDto(entity.getDistributor()));
        favoriteDistributorDTO.setFavorite(entity.getFavorite());
        return favoriteDistributorDTO;
    }

    public List<FavoriteDistributor> toEntity(List<FavoriteDistributorDTO> dtoList) {
        if (dtoList == null) {
            return null;
        }
        ArrayList<FavoriteDistributor> list = new ArrayList<FavoriteDistributor>(dtoList.size());
        for (FavoriteDistributorDTO favoriteDistributorDTO : dtoList) {
            list.add(this.toEntity(favoriteDistributorDTO));
        }
        return list;
    }

    public List<FavoriteDistributorDTO> toDto(List<FavoriteDistributor> entityList) {
        if (entityList == null) {
            return null;
        }
        ArrayList<FavoriteDistributorDTO> list = new ArrayList<FavoriteDistributorDTO>(entityList.size());
        for (FavoriteDistributor favoriteDistributor : entityList) {
            list.add(this.toDto(favoriteDistributor));
        }
        return list;
    }

    public void partialUpdate(FavoriteDistributor entity, FavoriteDistributorDTO dto) {
        if (dto == null) {
            return;
        }
        if (dto.getAppUser() != null) {
            entity.setAppUser((AppUser)this.appUserMapper.toEntity((Object)dto.getAppUser()));
        }
        if (dto.getDistributor() != null) {
            entity.setDistributor((Distributor)this.distributorMapper.toEntity((Object)dto.getDistributor()));
        }
        if (dto.getFavorite() != null) {
            entity.setFavorite(dto.getFavorite());
        }
    }

    public FavoriteDistributor toEntity(FavoriteDistributorDTO dto) {
        if (dto == null) {
            return null;
        }
        FavoriteDistributor favoriteDistributor = new FavoriteDistributor();
        if (dto.getAppUser() != null) {
            if (favoriteDistributor.getId() == null) {
                favoriteDistributor.setId(new FavoriteDistributorKey());
            }
            this.appUserDTOToFavoriteDistributorKey(dto.getAppUser(), favoriteDistributor.getId());
        }
        if (dto.getDistributor() != null) {
            if (favoriteDistributor.getId() == null) {
                favoriteDistributor.setId(new FavoriteDistributorKey());
            }
            this.distributorDTOToFavoriteDistributorKey(dto.getDistributor(), favoriteDistributor.getId());
        }
        favoriteDistributor.setAppUser((AppUser)this.appUserMapper.toEntity((Object)dto.getAppUser()));
        favoriteDistributor.setDistributor((Distributor)this.distributorMapper.toEntity((Object)dto.getDistributor()));
        favoriteDistributor.setFavorite(dto.getFavorite());
        return favoriteDistributor;
    }

    protected void appUserDTOToFavoriteDistributorKey(AppUserDTO appUserDTO, FavoriteDistributorKey mappingTarget) {
        if (appUserDTO == null) {
            return;
        }
        mappingTarget.setAppUserId(appUserDTO.getId());
    }

    protected void distributorDTOToFavoriteDistributorKey(DistributorDTO distributorDTO, FavoriteDistributorKey mappingTarget) {
        if (distributorDTO == null) {
            return;
        }
        mappingTarget.setDistributorId(distributorDTO.getId());
    }
}

