/*
 * Decompiled with CFR 0.152.
 */
package com.distribution.liquidation.upl.service;

import com.distribution.liquidation.upl.domain.AppUser;
import com.distribution.liquidation.upl.domain.AppUser_;
import com.distribution.liquidation.upl.repository.AppUserRepository;
import com.distribution.liquidation.upl.service.criteria.AppUserCriteria;
import com.distribution.liquidation.upl.service.dto.AppUserDTO;
import com.distribution.liquidation.upl.service.dto.FileDTO;
import com.distribution.liquidation.upl.service.mapper.AppUserMapper;
import java.io.ByteArrayOutputStream;
import java.io.IOException;
import java.util.Arrays;
import java.util.List;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;
import org.springframework.data.domain.Page;
import org.springframework.data.domain.Pageable;
import org.springframework.data.jpa.domain.Specification;
import org.springframework.stereotype.Service;
import org.springframework.transaction.annotation.Transactional;
import tech.jhipster.service.QueryService;
import tech.jhipster.service.filter.Filter;
import tech.jhipster.service.filter.RangeFilter;

@Service
@Transactional(readOnly=true)
public class AppUserQueryService
extends QueryService<AppUser> {
    private final Logger log = LoggerFactory.getLogger(AppUserQueryService.class);
    private final AppUserRepository appUserRepository;
    private final AppUserMapper appUserMapper;

    public AppUserQueryService(AppUserRepository appUserRepository, AppUserMapper appUserMapper) {
        this.appUserRepository = appUserRepository;
        this.appUserMapper = appUserMapper;
    }

    @Transactional(readOnly=true)
    public List<AppUserDTO> findByCriteria(AppUserCriteria criteria) {
        this.log.debug("find by criteria : {}", (Object)criteria);
        Specification specification = this.createSpecification(criteria);
        return this.appUserMapper.toDto(this.appUserRepository.findAll(specification));
    }

    @Transactional(readOnly=true)
    public Page<AppUserDTO> findByCriteria(AppUserCriteria criteria, Pageable page) {
        this.log.debug("find by criteria : {}, page: {}", (Object)criteria, (Object)page);
        Specification specification = this.createSpecification(criteria);
        return this.appUserRepository.findAll(specification, page).map(arg_0 -> ((AppUserMapper)this.appUserMapper).toDto(arg_0));
    }

    @Transactional(readOnly=true)
    public long countByCriteria(AppUserCriteria criteria) {
        this.log.debug("count by criteria : {}", (Object)criteria);
        Specification specification = this.createSpecification(criteria);
        return this.appUserRepository.count(specification);
    }

    protected Specification<AppUser> createSpecification(AppUserCriteria criteria) {
        Specification specification = Specification.where(null);
        if (criteria != null) {
            if (criteria.getDistinct() != null) {
                specification = specification.and(this.distinct(criteria.getDistinct().booleanValue()));
            }
            if (criteria.getId() != null) {
                specification = specification.and(this.buildRangeSpecification((RangeFilter)criteria.getId(), AppUser_.id));
            }
            if (criteria.getEmail() != null) {
                specification = specification.and(this.buildStringSpecification(criteria.getEmail(), AppUser_.email));
            }
            if (criteria.getName() != null) {
                specification = specification.and(this.buildStringSpecification(criteria.getName(), AppUser_.name));
            }
            if (criteria.getUgdn() != null) {
                specification = specification.and(this.buildRangeSpecification((RangeFilter)criteria.getUgdn(), AppUser_.ugdn));
            }
            if (criteria.getTerritorycode() != null) {
                specification = specification.and(this.buildStringSpecification(criteria.getTerritorycode(), AppUser_.territorycode));
            }
            if (criteria.getTerritoryName() != null) {
                specification = specification.and(this.buildStringSpecification(criteria.getTerritoryName(), AppUser_.territoryName));
            }
            if (criteria.getCostCentreCode() != null) {
                specification = specification.and(this.buildStringSpecification(criteria.getCostCentreCode(), AppUser_.costCentreCode));
            }
            if (criteria.getCostCentreName() != null) {
                specification = specification.and(this.buildStringSpecification(criteria.getCostCentreName(), AppUser_.costCentreName));
            }
            if (criteria.getTmECN() != null) {
                specification = specification.and(this.buildStringSpecification(criteria.getTmECN(), AppUser_.tmECN));
            }
            if (criteria.getSbuCode() != null) {
                specification = specification.and(this.buildStringSpecification(criteria.getSbuCode(), AppUser_.sbuCode));
            }
            if (criteria.getSbuName() != null) {
                specification = specification.and(this.buildStringSpecification(criteria.getSbuName(), AppUser_.sbuName));
            }
            if (criteria.getRole() != null) {
                specification = specification.and(this.buildSpecification((Filter)criteria.getRole(), AppUser_.role));
            }
            if (criteria.getStatus() != null) {
                specification = specification.and(this.buildSpecification((Filter)criteria.getStatus(), AppUser_.status));
            }
        }
        return specification;
    }

    public FileDTO exportByCriteria(AppUserCriteria criteria) throws IOException {
        this.log.debug("export by criteria : {}", (Object)criteria);
        Specification specification = this.createSpecification(criteria);
        List<String> csvHeader = Arrays.asList("Territory Manager Id", "Territory Manager Name", "Territory Manager Email", "Territory Manager Code", "Territory Name");
        ByteArrayOutputStream bos = new ByteArrayOutputStream();
        csvHeader.forEach(s -> {
            try {
                bos.write(s.getBytes());
                bos.write(",".getBytes());
            }
            catch (IOException e) {
                e.printStackTrace();
            }
        });
        bos.write("\n".getBytes());
        this.appUserRepository.findAll(specification).forEach(appUser -> {
            try {
                bos.write(String.valueOf(appUser.getUgdn()).getBytes());
                bos.write(",".getBytes());
                bos.write(appUser.getName().getBytes());
                bos.write(",".getBytes());
                bos.write(appUser.getEmail().getBytes());
                bos.write(",".getBytes());
                bos.write(appUser.getTmECN().getBytes());
                bos.write(",".getBytes());
                bos.write(appUser.getTerritoryName().getBytes());
            }
            catch (IOException e) {
                e.printStackTrace();
            }
            try {
                bos.write("\n".getBytes());
            }
            catch (IOException e) {
                e.printStackTrace();
            }
        });
        bos.close();
        return new FileDTO("territory_managers.csv", bos.toByteArray());
    }
}

