/*
 * Decompiled with CFR 0.152.
 */
package com.distribution.liquidation.upl.web.rest;

import com.distribution.liquidation.upl.security.SecurityUtils;
import com.distribution.liquidation.upl.service.FavoriteDistributorService;
import com.distribution.liquidation.upl.service.dto.AppUserDTO;
import com.distribution.liquidation.upl.service.dto.FavoriteDistributorDTO;
import java.net.URI;
import java.net.URISyntaxException;
import javax.validation.Valid;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;
import org.springframework.beans.factory.annotation.Value;
import org.springframework.http.ResponseEntity;
import org.springframework.web.bind.annotation.PostMapping;
import org.springframework.web.bind.annotation.RequestBody;
import org.springframework.web.bind.annotation.RequestMapping;
import org.springframework.web.bind.annotation.RestController;
import tech.jhipster.web.util.HeaderUtil;

@RestController
@RequestMapping(value={"/api"})
public class FavoriteDistributorResource {
    private final Logger log = LoggerFactory.getLogger(FavoriteDistributorResource.class);
    private static final String ENTITY_NAME = "favoriteDistributor";
    @Value(value="${jhipster.clientApp.name}")
    private String applicationName;
    private final FavoriteDistributorService favoriteDistributorService;

    public FavoriteDistributorResource(FavoriteDistributorService favoriteDistributorService) {
        this.favoriteDistributorService = favoriteDistributorService;
    }

    @PostMapping(value={"/favorite-distributors"})
    public ResponseEntity<FavoriteDistributorDTO> createFavoriteDistributor(@Valid @RequestBody FavoriteDistributorDTO favoriteDistributorDTO) throws URISyntaxException {
        this.log.debug("REST request to save Favorite Distributor : {}", (Object)favoriteDistributorDTO);
        Long appUserId = Long.valueOf((String)SecurityUtils.getCurrentUserLogin().get());
        AppUserDTO appUserDTO = new AppUserDTO();
        appUserDTO.setId(appUserId);
        favoriteDistributorDTO.setAppUser(appUserDTO);
        FavoriteDistributorDTO result = this.favoriteDistributorService.save(favoriteDistributorDTO);
        return ((ResponseEntity.BodyBuilder)ResponseEntity.created((URI)new URI("/api/favorite-distributors/")).headers(HeaderUtil.createEntityCreationAlert((String)this.applicationName, (boolean)false, (String)ENTITY_NAME, (String)""))).body((Object)result);
    }
}

