/*
 * Decompiled with CFR 0.152.
 */
package com.distribution.liquidation.upl.service.impl;

import com.distribution.liquidation.upl.domain.Product;
import com.distribution.liquidation.upl.domain.RfidScan;
import com.distribution.liquidation.upl.domain.enumeration.ScanStatus;
import com.distribution.liquidation.upl.repository.ProductRepository;
import com.distribution.liquidation.upl.repository.RfidScanRepository;
import com.distribution.liquidation.upl.service.ProductService;
import com.distribution.liquidation.upl.service.dto.ProductDTO;
import com.distribution.liquidation.upl.service.dto.RfidDTO;
import com.distribution.liquidation.upl.service.exception.CustomBadRequestException;
import com.distribution.liquidation.upl.service.impl.AsyncJob;
import com.distribution.liquidation.upl.service.mapper.ProductMapper;
import com.fasterxml.jackson.core.JsonProcessingException;
import java.util.ArrayList;
import java.util.HashSet;
import java.util.Optional;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;
import org.springframework.data.domain.Page;
import org.springframework.data.domain.Pageable;
import org.springframework.stereotype.Service;
import org.springframework.transaction.annotation.Transactional;

@Service
@Transactional
public class ProductServiceImpl
implements ProductService {
    private final Logger log = LoggerFactory.getLogger(ProductServiceImpl.class);
    private final ProductRepository productRepository;
    private final RfidScanRepository rfidScanRepository;
    private final ProductMapper productMapper;
    private final AsyncJob asyncJob;

    public ProductServiceImpl(ProductRepository productRepository, RfidScanRepository rfidScanRepository, ProductMapper productMapper, AsyncJob asyncJob) {
        this.productRepository = productRepository;
        this.rfidScanRepository = rfidScanRepository;
        this.productMapper = productMapper;
        this.asyncJob = asyncJob;
    }

    public ProductDTO save(ProductDTO productDTO) {
        this.log.debug("Request to save Product : {}", (Object)productDTO);
        Product product = (Product)this.productMapper.toEntity((Object)productDTO);
        product = (Product)this.productRepository.save((Object)product);
        return this.productMapper.toDto(product);
    }

    public Optional<ProductDTO> partialUpdate(ProductDTO productDTO) {
        this.log.debug("Request to partially update Product : {}", (Object)productDTO);
        return this.productRepository.findById((Object)productDTO.getId()).map(existingProduct -> {
            this.productMapper.partialUpdate(existingProduct, (Object)productDTO);
            return existingProduct;
        }).map(arg_0 -> ((ProductRepository)this.productRepository).save(arg_0)).map(arg_0 -> ((ProductMapper)this.productMapper).toDto(arg_0));
    }

    @Transactional(readOnly=true)
    public Page<ProductDTO> findAll(Pageable pageable) {
        this.log.debug("Request to get all Products");
        return this.productRepository.findAll(pageable).map(arg_0 -> ((ProductMapper)this.productMapper).toDto(arg_0));
    }

    @Transactional(readOnly=true)
    public Optional<ProductDTO> findOne(Long id) {
        this.log.debug("Request to get Product : {}", (Object)id);
        return this.productRepository.findById((Object)id).map(arg_0 -> ((ProductMapper)this.productMapper).toDto(arg_0));
    }

    public void delete(Long id) {
        this.log.debug("Request to delete Product : {}", (Object)id);
        this.productRepository.deleteById((Object)id);
    }

    @Transactional
    public String fetchProductFromRFID(RfidDTO rfidDTO) {
        Optional optionalRfidScan = this.rfidScanRepository.findById((Object)rfidDTO.getRfidScanId());
        if (!optionalRfidScan.isPresent()) {
            throw new CustomBadRequestException("Invalid Scan Id");
        }
        RfidScan rfidScan = (RfidScan)optionalRfidScan.get();
        rfidScan.setScanStatus(ScanStatus.COMPLETE);
        this.rfidScanRepository.save((Object)rfidScan);
        ArrayList rfids = new ArrayList(new HashSet(rfidDTO.getRfids()));
        ArrayList asyncFutures = new ArrayList();
        rfids.forEach(rfid -> {
            try {
                asyncFutures.add(this.asyncJob.fetchRfidDataAsync(rfid, rfidDTO.getDistributorId(), rfidScan));
            }
            catch (JsonProcessingException e) {
                e.printStackTrace();
            }
        });
        this.asyncJob.sendScanCompleteEmail(asyncFutures, rfidScan.getId());
        return "Running Job to fetch data for RFIDs";
    }
}

