/*
 * Decompiled with CFR 0.152.
 */
package com.distribution.liquidation.upl.service;

import com.distribution.liquidation.upl.config.ApplicationProperties;
import java.nio.charset.StandardCharsets;
import java.util.Locale;
import javax.mail.MessagingException;
import javax.mail.internet.MimeMessage;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;
import org.springframework.context.MessageSource;
import org.springframework.core.io.ByteArrayResource;
import org.springframework.core.io.InputStreamSource;
import org.springframework.mail.MailException;
import org.springframework.mail.javamail.JavaMailSender;
import org.springframework.mail.javamail.MimeMessageHelper;
import org.springframework.scheduling.annotation.Async;
import org.springframework.stereotype.Service;
import org.thymeleaf.context.Context;
import org.thymeleaf.context.IContext;
import org.thymeleaf.spring5.SpringTemplateEngine;
import tech.jhipster.config.JHipsterProperties;

@Service
public class MailService {
    private final Logger log = LoggerFactory.getLogger(MailService.class);
    private final JavaMailSender javaMailSender;
    private final JHipsterProperties jHipsterProperties;
    private final ApplicationProperties.MailSettings mailSettings;
    private final MessageSource messageSource;
    private final SpringTemplateEngine templateEngine;

    public MailService(ApplicationProperties applicationProperties, JHipsterProperties jHipsterProperties, JavaMailSender javaMailSender, MessageSource messageSource, SpringTemplateEngine templateEngine) {
        this.mailSettings = applicationProperties.getMailSettings();
        this.jHipsterProperties = jHipsterProperties;
        this.javaMailSender = javaMailSender;
        this.messageSource = messageSource;
        this.templateEngine = templateEngine;
    }

    @Async
    public void sendEmail(String[] toList, String[] ccList, String subject, String content, boolean isMultipart, boolean isHtml, String attachmentName, byte[] attachmentData) {
        this.log.debug("Send email[multipart '{}' and html '{}'] to '{}' with subject '{}' and content={}", new Object[]{isMultipart, isHtml, toList, subject, content});
        MimeMessage mimeMessage = this.javaMailSender.createMimeMessage();
        try {
            MimeMessageHelper message = new MimeMessageHelper(mimeMessage, isMultipart, StandardCharsets.UTF_8.name());
            message.setTo(toList);
            message.setCc(ccList);
            message.setFrom(this.jHipsterProperties.getMail().getFrom());
            message.setSubject(subject);
            message.setText(content, isHtml);
            if (attachmentData != null && attachmentName != null) {
                message.addAttachment(attachmentName, (InputStreamSource)new ByteArrayResource(attachmentData));
            }
            this.javaMailSender.send(mimeMessage);
            this.log.debug("Sent email to User '{}, {}'", (Object)toList, (Object)ccList);
        }
        catch (MessagingException | MailException e) {
            this.log.warn("Email could not be sent to user '{}, {}'", new Object[]{toList, ccList, e});
        }
    }

    @Async
    public void sendEmailFromTemplate(String toUser, Object data, String templateName, String attachmentName, byte[] attachmentData) {
        Locale locale = Locale.forLanguageTag("en");
        Context context = new Context(locale);
        String subject = this.messageSource.getMessage("email.title", new Object[]{data}, locale);
        String content = this.templateEngine.process(templateName, (IContext)context);
        String[] ccList = this.mailSettings.getCcList();
        this.sendEmail(new String[]{toUser}, ccList, subject, content, true, true, attachmentName, attachmentData);
    }
}

