/*
 * Decompiled with CFR 0.152.
 */
package com.distribution.liquidation.upl.domain;

import com.distribution.liquidation.upl.domain.AppUser;
import com.distribution.liquidation.upl.domain.Distributor;
import com.distribution.liquidation.upl.domain.FavoriteDistributorKey;
import java.io.Serializable;
import java.util.Objects;
import javax.persistence.Column;
import javax.persistence.EmbeddedId;
import javax.persistence.Entity;
import javax.persistence.JoinColumn;
import javax.persistence.ManyToOne;
import javax.persistence.MapsId;
import javax.persistence.Table;
import org.hibernate.annotations.Cache;
import org.hibernate.annotations.CacheConcurrencyStrategy;
import org.hibernate.annotations.FilterDef;
import org.hibernate.annotations.ParamDef;

@Entity
@Table(name="favorite_distributor")
@FilterDef(name="forAppUserOnly", parameters={@ParamDef(name="appUserId", type="java.lang.Long")})
@Cache(usage=CacheConcurrencyStrategy.READ_WRITE)
public class FavoriteDistributor
implements Serializable {
    private static final long serialVersionUID = 1L;
    @EmbeddedId
    private FavoriteDistributorKey id;
    @ManyToOne
    @MapsId(value="appUserId")
    @JoinColumn(name="app_user_id")
    private AppUser appUser;
    @ManyToOne
    @MapsId(value="distributorId")
    @JoinColumn(name="distributor_id")
    private Distributor distributor;
    @Column(name="is_favorite")
    private Boolean isFavorite;

    public FavoriteDistributor() {
    }

    public FavoriteDistributor(AppUser appUser, Distributor distributor, Boolean isFavorite) {
        this.appUser = appUser;
        this.distributor = distributor;
        this.isFavorite = isFavorite;
        this.id = new FavoriteDistributorKey(appUser.getId(), distributor.getId());
    }

    public FavoriteDistributorKey getId() {
        return this.id;
    }

    public void setId(FavoriteDistributorKey id) {
        this.id = id;
    }

    public AppUser getAppUser() {
        return this.appUser;
    }

    public void setAppUser(AppUser appUser) {
        this.appUser = appUser;
    }

    public Distributor getDistributor() {
        return this.distributor;
    }

    public void setDistributor(Distributor distributor) {
        this.distributor = distributor;
    }

    public Boolean getFavorite() {
        return this.isFavorite;
    }

    public void setFavorite(Boolean favorite) {
        this.isFavorite = favorite;
    }

    public boolean equals(Object o) {
        if (this == o) {
            return true;
        }
        if (o == null || this.getClass() != o.getClass()) {
            return false;
        }
        FavoriteDistributor that = (FavoriteDistributor)o;
        return this.appUser.equals((Object)that.appUser) && this.distributor.equals((Object)that.distributor) && Objects.equals(this.isFavorite, that.isFavorite);
    }

    public int hashCode() {
        return Objects.hash(this.appUser, this.distributor, this.isFavorite);
    }

    public String toString() {
        return "FavoriteDistributor{appUser=" + this.appUser + ", distributor=" + this.distributor + ", isFavorite=" + this.isFavorite + '}';
    }
}

