/*
 * Decompiled with CFR 0.152.
 */
package com.distribution.liquidation.upl.web.rest;

import com.distribution.liquidation.upl.security.SecurityUtils;
import com.distribution.liquidation.upl.security.jwt.TokenProvider;
import com.distribution.liquidation.upl.service.AuthenticationService;
import com.distribution.liquidation.upl.service.dto.AuthInfoDTO;
import com.distribution.liquidation.upl.service.dto.AuthInfoMobileDTO;
import com.distribution.liquidation.upl.service.dto.AuthenticationDTO;
import com.distribution.liquidation.upl.web.rest.UserJWTController;
import com.distribution.liquidation.upl.web.rest.errors.BadRequestAlertException;
import com.distribution.liquidation.upl.web.rest.vm.MessageVM;
import com.fasterxml.jackson.core.JsonProcessingException;
import com.fasterxml.jackson.core.type.TypeReference;
import com.fasterxml.jackson.databind.ObjectMapper;
import java.util.Map;
import javax.validation.Valid;
import org.springframework.http.ResponseEntity;
import org.springframework.security.config.annotation.authentication.builders.AuthenticationManagerBuilder;
import org.springframework.web.bind.annotation.GetMapping;
import org.springframework.web.bind.annotation.PostMapping;
import org.springframework.web.bind.annotation.RequestBody;
import org.springframework.web.bind.annotation.RequestMapping;
import org.springframework.web.bind.annotation.RestController;
import org.springframework.web.client.HttpClientErrorException;

@RestController
@RequestMapping(value={"/api"})
public class UserJWTController {
    private final TokenProvider tokenProvider;
    private final AuthenticationManagerBuilder authenticationManagerBuilder;
    private final AuthenticationService authenticationService;

    public UserJWTController(TokenProvider tokenProvider, AuthenticationManagerBuilder authenticationManagerBuilder, AuthenticationService authenticationService) {
        this.tokenProvider = tokenProvider;
        this.authenticationManagerBuilder = authenticationManagerBuilder;
        this.authenticationService = authenticationService;
    }

    @PostMapping(value={"/authenticate"})
    public ResponseEntity<JWTToken> authenticate(@Valid @RequestBody AuthenticationDTO authenticationDTO) throws JsonProcessingException {
        try {
            JWTToken jwtToken = new JWTToken(this.authenticationService.authenticate(authenticationDTO));
            return ResponseEntity.ok().body((Object)jwtToken);
        }
        catch (HttpClientErrorException ex) {
            ObjectMapper mapper = new ObjectMapper();
            Map error = (Map)mapper.readValue(ex.getResponseBodyAsString(), (TypeReference)new /* Unavailable Anonymous Inner Class!! */);
            throw new BadRequestAlertException((String)error.get("error_description"), authenticationDTO.getCode(), (String)error.get("error"));
        }
    }

    @PostMapping(value={"/authenticate-mobile"})
    public ResponseEntity<JWTToken> authenticateMobile(@Valid @RequestBody AuthenticationDTO authenticationDTO) throws JsonProcessingException {
        try {
            JWTToken jwtToken = new JWTToken(this.authenticationService.authenticateMobile(authenticationDTO));
            return ResponseEntity.ok().body((Object)jwtToken);
        }
        catch (HttpClientErrorException ex) {
            ObjectMapper mapper = new ObjectMapper();
            Map error = (Map)mapper.readValue(ex.getResponseBodyAsString(), (TypeReference)new /* Unavailable Anonymous Inner Class!! */);
            throw new BadRequestAlertException((String)error.get("error_description"), authenticationDTO.getCode(), (String)error.get("error"));
        }
    }

    @GetMapping(value={"/auth-info"})
    public ResponseEntity<AuthInfoDTO> authInfo() {
        return ResponseEntity.ok().body((Object)this.authenticationService.authInfo());
    }

    @GetMapping(value={"/auth-info-mobile"})
    public ResponseEntity<AuthInfoMobileDTO> authInfoMobile() {
        return ResponseEntity.ok().body((Object)this.authenticationService.authInfoMobile());
    }

    @GetMapping(value={"/logout"})
    public ResponseEntity<MessageVM> logout() {
        String token = (String)SecurityUtils.getCurrentUserJWT().get();
        Boolean result = this.authenticationService.logout(token);
        if (result != null && result.booleanValue()) {
            return ResponseEntity.ok().body((Object)new MessageVM("Logout successfully."));
        }
        throw new BadRequestAlertException("Unable to find user token", "datrixAppUserLogin", "tokennotexists");
    }
}

