/*
 * Decompiled with CFR 0.152.
 */
package com.distribution.liquidation.upl.web.rest;

import com.distribution.liquidation.upl.repository.DistributorRepository;
import com.distribution.liquidation.upl.security.SecurityUtils;
import com.distribution.liquidation.upl.service.DistributorQueryService;
import com.distribution.liquidation.upl.service.DistributorService;
import com.distribution.liquidation.upl.service.criteria.DistributorCriteria;
import com.distribution.liquidation.upl.service.dto.DistributorDTO;
import com.distribution.liquidation.upl.service.dto.FileDTO;
import com.distribution.liquidation.upl.web.rest.errors.BadRequestAlertException;
import java.io.IOException;
import java.net.URI;
import java.net.URISyntaxException;
import java.util.List;
import java.util.Objects;
import java.util.Optional;
import javax.validation.Valid;
import javax.validation.constraints.NotNull;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;
import org.springdoc.api.annotations.ParameterObject;
import org.springframework.beans.factory.annotation.Value;
import org.springframework.data.domain.Page;
import org.springframework.data.domain.Pageable;
import org.springframework.http.HttpHeaders;
import org.springframework.http.ResponseEntity;
import org.springframework.web.bind.annotation.DeleteMapping;
import org.springframework.web.bind.annotation.GetMapping;
import org.springframework.web.bind.annotation.PatchMapping;
import org.springframework.web.bind.annotation.PathVariable;
import org.springframework.web.bind.annotation.PostMapping;
import org.springframework.web.bind.annotation.PutMapping;
import org.springframework.web.bind.annotation.RequestBody;
import org.springframework.web.bind.annotation.RequestMapping;
import org.springframework.web.bind.annotation.RestController;
import org.springframework.web.servlet.support.ServletUriComponentsBuilder;
import org.springframework.web.util.UriComponentsBuilder;
import tech.jhipster.web.util.HeaderUtil;
import tech.jhipster.web.util.PaginationUtil;
import tech.jhipster.web.util.ResponseUtil;

@RestController
@RequestMapping(value={"/api"})
public class DistributorResource {
    private final Logger log = LoggerFactory.getLogger(DistributorResource.class);
    private static final String ENTITY_NAME = "distributor";
    @Value(value="${jhipster.clientApp.name}")
    private String applicationName;
    private final DistributorService distributorService;
    private final DistributorRepository distributorRepository;
    private final DistributorQueryService distributorQueryService;

    public DistributorResource(DistributorService distributorService, DistributorRepository distributorRepository, DistributorQueryService distributorQueryService) {
        this.distributorService = distributorService;
        this.distributorRepository = distributorRepository;
        this.distributorQueryService = distributorQueryService;
    }

    @PostMapping(value={"/distributors"})
    public ResponseEntity<DistributorDTO> createDistributor(@Valid @RequestBody DistributorDTO distributorDTO) throws URISyntaxException {
        this.log.debug("REST request to save Distributor : {}", (Object)distributorDTO);
        if (distributorDTO.getId() != null) {
            throw new BadRequestAlertException("A new distributor cannot already have an ID", ENTITY_NAME, "idexists");
        }
        DistributorDTO result = this.distributorService.save(distributorDTO);
        return ((ResponseEntity.BodyBuilder)ResponseEntity.created((URI)new URI("/api/distributors/" + result.getId())).headers(HeaderUtil.createEntityCreationAlert((String)this.applicationName, (boolean)false, (String)ENTITY_NAME, (String)result.getId().toString()))).body((Object)result);
    }

    @PutMapping(value={"/distributors/{id}"})
    public ResponseEntity<DistributorDTO> updateDistributor(@PathVariable(value="id", required=false) Long id, @Valid @RequestBody DistributorDTO distributorDTO) throws URISyntaxException {
        this.log.debug("REST request to update Distributor : {}, {}", (Object)id, (Object)distributorDTO);
        if (distributorDTO.getId() == null) {
            throw new BadRequestAlertException("Invalid id", ENTITY_NAME, "idnull");
        }
        if (!Objects.equals(id, distributorDTO.getId())) {
            throw new BadRequestAlertException("Invalid ID", ENTITY_NAME, "idinvalid");
        }
        if (!this.distributorRepository.existsById((Object)id)) {
            throw new BadRequestAlertException("Entity not found", ENTITY_NAME, "idnotfound");
        }
        DistributorDTO result = this.distributorService.save(distributorDTO);
        return ((ResponseEntity.BodyBuilder)ResponseEntity.ok().headers(HeaderUtil.createEntityUpdateAlert((String)this.applicationName, (boolean)false, (String)ENTITY_NAME, (String)distributorDTO.getId().toString()))).body((Object)result);
    }

    @PatchMapping(value={"/distributors/{id}"}, consumes={"application/json", "application/merge-patch+json"})
    public ResponseEntity<DistributorDTO> partialUpdateDistributor(@PathVariable(value="id", required=false) Long id, @NotNull @RequestBody DistributorDTO distributorDTO) throws URISyntaxException {
        this.log.debug("REST request to partial update Distributor partially : {}, {}", (Object)id, (Object)distributorDTO);
        if (distributorDTO.getId() == null) {
            throw new BadRequestAlertException("Invalid id", ENTITY_NAME, "idnull");
        }
        if (!Objects.equals(id, distributorDTO.getId())) {
            throw new BadRequestAlertException("Invalid ID", ENTITY_NAME, "idinvalid");
        }
        if (!this.distributorRepository.existsById((Object)id)) {
            throw new BadRequestAlertException("Entity not found", ENTITY_NAME, "idnotfound");
        }
        Optional result = this.distributorService.partialUpdate(distributorDTO);
        return ResponseUtil.wrapOrNotFound((Optional)result, (HttpHeaders)HeaderUtil.createEntityUpdateAlert((String)this.applicationName, (boolean)false, (String)ENTITY_NAME, (String)distributorDTO.getId().toString()));
    }

    @GetMapping(value={"/distributors"})
    public ResponseEntity<Page<DistributorDTO>> getAllDistributors(DistributorCriteria criteria, @ParameterObject Pageable pageable) {
        this.log.debug("REST request to get Distributors by criteria: {}", (Object)criteria);
        Long appUserId = Long.parseLong((String)SecurityUtils.getCurrentUserLogin().get());
        Page page = this.distributorQueryService.findByCriteria(criteria, pageable, appUserId);
        HttpHeaders headers = PaginationUtil.generatePaginationHttpHeaders((UriComponentsBuilder)ServletUriComponentsBuilder.fromCurrentRequest(), (Page)page);
        return ((ResponseEntity.BodyBuilder)ResponseEntity.ok().headers(headers)).body((Object)page);
    }

    @GetMapping(value={"/distributors/all"})
    public ResponseEntity<List<DistributorDTO>> getAllDistributorsUnpaged(DistributorCriteria criteria) {
        this.log.debug("REST request to get Distributors by criteria UnPaged: {}", (Object)criteria);
        Long appUserId = Long.parseLong((String)SecurityUtils.getCurrentUserLogin().get());
        List page = this.distributorQueryService.findByCriteria(criteria, appUserId);
        return ResponseEntity.ok().body((Object)page);
    }

    @GetMapping(value={"/distributors/export"})
    public ResponseEntity<FileDTO> exportAllDistributors(DistributorCriteria criteria) throws IOException {
        this.log.debug("REST request to export Distributors by criteria: {}", (Object)criteria);
        FileDTO fileDTO = this.distributorQueryService.exportByCriteria(criteria);
        return ResponseEntity.ok().body((Object)fileDTO);
    }

    @GetMapping(value={"/distributors/count"})
    public ResponseEntity<Long> countDistributors(DistributorCriteria criteria) {
        this.log.debug("REST request to count Distributors by criteria: {}", (Object)criteria);
        return ResponseEntity.ok().body((Object)this.distributorQueryService.countByCriteria(criteria));
    }

    @GetMapping(value={"/distributors/{id}"})
    public ResponseEntity<DistributorDTO> getDistributor(@PathVariable Long id) {
        this.log.debug("REST request to get Distributor : {}", (Object)id);
        Long appUserId = Long.parseLong((String)SecurityUtils.getCurrentUserLogin().get());
        Optional distributorDTO = this.distributorService.findOne(id, appUserId);
        return ResponseUtil.wrapOrNotFound((Optional)distributorDTO);
    }

    @GetMapping(value={"/distributors/code/{code}"})
    public ResponseEntity<DistributorDTO> getDistributorByCode(@PathVariable String code) {
        this.log.debug("REST request to get Distributor By Code: {}", (Object)code);
        Long appUserId = Long.parseLong((String)SecurityUtils.getCurrentUserLogin().get());
        Optional distributorDTO = this.distributorService.findOneByCode(code, appUserId);
        return ResponseUtil.wrapOrNotFound((Optional)distributorDTO);
    }

    @DeleteMapping(value={"/distributors/{id}"})
    public ResponseEntity<Void> deleteDistributor(@PathVariable Long id) {
        this.log.debug("REST request to delete Distributor : {}", (Object)id);
        this.distributorService.delete(id);
        return ResponseEntity.noContent().headers(HeaderUtil.createEntityDeletionAlert((String)this.applicationName, (boolean)false, (String)ENTITY_NAME, (String)id.toString())).build();
    }
}

