/*
 * Decompiled with CFR 0.152.
 */
package com.distribution.liquidation.upl.service.impl;

import com.distribution.liquidation.upl.domain.AppUser;
import com.distribution.liquidation.upl.repository.AppUserRepository;
import com.distribution.liquidation.upl.service.AppUserService;
import com.distribution.liquidation.upl.service.dto.AppUserDTO;
import com.distribution.liquidation.upl.service.mapper.AppUserMapper;
import java.util.Optional;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;
import org.springframework.data.domain.Page;
import org.springframework.data.domain.Pageable;
import org.springframework.stereotype.Service;
import org.springframework.transaction.annotation.Transactional;

@Service
@Transactional
public class AppUserServiceImpl
implements AppUserService {
    private final Logger log = LoggerFactory.getLogger(AppUserServiceImpl.class);
    private final AppUserRepository appUserRepository;
    private final AppUserMapper appUserMapper;

    public AppUserServiceImpl(AppUserRepository appUserRepository, AppUserMapper appUserMapper) {
        this.appUserRepository = appUserRepository;
        this.appUserMapper = appUserMapper;
    }

    public AppUserDTO save(AppUserDTO appUserDTO) {
        this.log.debug("Request to save AppUser : {}", (Object)appUserDTO);
        AppUser appUser = (AppUser)this.appUserMapper.toEntity((Object)appUserDTO);
        appUser = (AppUser)this.appUserRepository.save((Object)appUser);
        return (AppUserDTO)this.appUserMapper.toDto((Object)appUser);
    }

    public Optional<AppUserDTO> partialUpdate(AppUserDTO appUserDTO) {
        this.log.debug("Request to partially update AppUser : {}", (Object)appUserDTO);
        return this.appUserRepository.findById((Object)appUserDTO.getId()).map(existingAppUser -> {
            this.appUserMapper.partialUpdate(existingAppUser, (Object)appUserDTO);
            return existingAppUser;
        }).map(arg_0 -> ((AppUserRepository)this.appUserRepository).save(arg_0)).map(arg_0 -> ((AppUserMapper)this.appUserMapper).toDto(arg_0));
    }

    @Transactional(readOnly=true)
    public Page<AppUserDTO> findAll(Pageable pageable) {
        this.log.debug("Request to get all AppUsers");
        return this.appUserRepository.findAll(pageable).map(arg_0 -> ((AppUserMapper)this.appUserMapper).toDto(arg_0));
    }

    @Transactional(readOnly=true)
    public Optional<AppUserDTO> findOne(Long id) {
        this.log.debug("Request to get AppUser : {}", (Object)id);
        return this.appUserRepository.findById((Object)id).map(arg_0 -> ((AppUserMapper)this.appUserMapper).toDto(arg_0));
    }

    public void delete(Long id) {
        this.log.debug("Request to delete AppUser : {}", (Object)id);
        this.appUserRepository.deleteById((Object)id);
    }
}

