/*
 * Decompiled with CFR 0.152.
 */
package com.distribution.liquidation.upl.service.impl;

import com.distribution.liquidation.upl.domain.Address;
import com.distribution.liquidation.upl.repository.AddressRepository;
import com.distribution.liquidation.upl.service.AddressService;
import com.distribution.liquidation.upl.service.dto.AddressDTO;
import com.distribution.liquidation.upl.service.mapper.AddressMapper;
import java.util.LinkedList;
import java.util.List;
import java.util.Optional;
import java.util.stream.Collectors;
import java.util.stream.StreamSupport;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;
import org.springframework.stereotype.Service;
import org.springframework.transaction.annotation.Transactional;

@Service
@Transactional
public class AddressServiceImpl
implements AddressService {
    private final Logger log = LoggerFactory.getLogger(AddressServiceImpl.class);
    private final AddressRepository addressRepository;
    private final AddressMapper addressMapper;

    public AddressServiceImpl(AddressRepository addressRepository, AddressMapper addressMapper) {
        this.addressRepository = addressRepository;
        this.addressMapper = addressMapper;
    }

    public AddressDTO save(AddressDTO addressDTO) {
        this.log.debug("Request to save Address : {}", (Object)addressDTO);
        Address address = (Address)this.addressMapper.toEntity((Object)addressDTO);
        address = (Address)this.addressRepository.save((Object)address);
        return (AddressDTO)this.addressMapper.toDto((Object)address);
    }

    public Optional<AddressDTO> partialUpdate(AddressDTO addressDTO) {
        this.log.debug("Request to partially update Address : {}", (Object)addressDTO);
        return this.addressRepository.findById((Object)addressDTO.getId()).map(existingAddress -> {
            this.addressMapper.partialUpdate(existingAddress, (Object)addressDTO);
            return existingAddress;
        }).map(arg_0 -> ((AddressRepository)this.addressRepository).save(arg_0)).map(arg_0 -> ((AddressMapper)this.addressMapper).toDto(arg_0));
    }

    @Transactional(readOnly=true)
    public List<AddressDTO> findAll() {
        this.log.debug("Request to get all Addresses");
        return this.addressRepository.findAll().stream().map(arg_0 -> ((AddressMapper)this.addressMapper).toDto(arg_0)).collect(Collectors.toCollection(LinkedList::new));
    }

    @Transactional(readOnly=true)
    public List<AddressDTO> findAllWhereDistributorIsNull() {
        this.log.debug("Request to get all addresses where Distributor is null");
        return StreamSupport.stream(this.addressRepository.findAll().spliterator(), false).filter(address -> address.getDistributor() == null).map(arg_0 -> ((AddressMapper)this.addressMapper).toDto(arg_0)).collect(Collectors.toCollection(LinkedList::new));
    }

    @Transactional(readOnly=true)
    public Optional<AddressDTO> findOne(Long id) {
        this.log.debug("Request to get Address : {}", (Object)id);
        return this.addressRepository.findById((Object)id).map(arg_0 -> ((AddressMapper)this.addressMapper).toDto(arg_0));
    }

    public void delete(Long id) {
        this.log.debug("Request to delete Address : {}", (Object)id);
        this.addressRepository.deleteById((Object)id);
    }
}

