/*
 * Decompiled with CFR 0.152.
 */
package com.distribution.liquidation.upl.config;

import com.distribution.liquidation.upl.domain.Address;
import com.distribution.liquidation.upl.domain.AppUser;
import com.distribution.liquidation.upl.domain.AppUserLogin;
import com.distribution.liquidation.upl.domain.Distributor;
import com.distribution.liquidation.upl.domain.Product;
import com.distribution.liquidation.upl.domain.ProductQuantity;
import com.distribution.liquidation.upl.domain.RfidScan;
import java.time.Duration;
import javax.cache.Cache;
import javax.cache.CacheManager;
import org.ehcache.config.Builder;
import org.ehcache.config.builders.CacheConfigurationBuilder;
import org.ehcache.config.builders.ExpiryPolicyBuilder;
import org.ehcache.config.builders.ResourcePoolsBuilder;
import org.ehcache.jsr107.Eh107Configuration;
import org.springframework.beans.factory.annotation.Autowired;
import org.springframework.boot.autoconfigure.cache.JCacheManagerCustomizer;
import org.springframework.boot.autoconfigure.orm.jpa.HibernatePropertiesCustomizer;
import org.springframework.boot.info.BuildProperties;
import org.springframework.boot.info.GitProperties;
import org.springframework.cache.annotation.EnableCaching;
import org.springframework.cache.interceptor.KeyGenerator;
import org.springframework.context.annotation.Bean;
import org.springframework.context.annotation.Configuration;
import tech.jhipster.config.JHipsterProperties;
import tech.jhipster.config.cache.PrefixedKeyGenerator;

@Configuration
@EnableCaching
public class CacheConfiguration {
    private GitProperties gitProperties;
    private BuildProperties buildProperties;
    private final javax.cache.configuration.Configuration<Object, Object> jcacheConfiguration;

    public CacheConfiguration(JHipsterProperties jHipsterProperties) {
        JHipsterProperties.Cache.Ehcache ehcache = jHipsterProperties.getCache().getEhcache();
        this.jcacheConfiguration = Eh107Configuration.fromEhcacheCacheConfiguration((org.ehcache.config.CacheConfiguration)CacheConfigurationBuilder.newCacheConfigurationBuilder(Object.class, Object.class, (Builder)ResourcePoolsBuilder.heap((long)ehcache.getMaxEntries())).withExpiry(ExpiryPolicyBuilder.timeToLiveExpiration((Duration)Duration.ofSeconds(ehcache.getTimeToLiveSeconds()))).build());
    }

    @Bean
    public HibernatePropertiesCustomizer hibernatePropertiesCustomizer(CacheManager cacheManager) {
        return hibernateProperties -> hibernateProperties.put("hibernate.javax.cache.cache_manager", cacheManager);
    }

    @Bean
    public JCacheManagerCustomizer cacheManagerCustomizer() {
        return cm -> {
            this.createCache(cm, Address.class.getName());
            this.createCache(cm, AppUser.class.getName());
            this.createCache(cm, AppUserLogin.class.getName());
            this.createCache(cm, Distributor.class.getName());
            this.createCache(cm, Product.class.getName());
            this.createCache(cm, RfidScan.class.getName());
            this.createCache(cm, ProductQuantity.class.getName());
        };
    }

    private void createCache(CacheManager cm, String cacheName) {
        Cache cache = cm.getCache(cacheName);
        if (cache != null) {
            cache.clear();
        } else {
            cm.createCache(cacheName, this.jcacheConfiguration);
        }
    }

    @Autowired(required=false)
    public void setGitProperties(GitProperties gitProperties) {
        this.gitProperties = gitProperties;
    }

    @Autowired(required=false)
    public void setBuildProperties(BuildProperties buildProperties) {
        this.buildProperties = buildProperties;
    }

    @Bean
    public KeyGenerator keyGenerator() {
        return new PrefixedKeyGenerator(this.gitProperties, this.buildProperties);
    }
}

