/*
 * Decompiled with CFR 0.152.
 */
package com.distribution.liquidation.upl.service.impl;

import com.distribution.liquidation.upl.domain.ProductQuantity;
import com.distribution.liquidation.upl.repository.ProductQuantityRepository;
import com.distribution.liquidation.upl.service.ProductQuantityService;
import com.distribution.liquidation.upl.service.dto.ProductQuantityDTO;
import com.distribution.liquidation.upl.service.mapper.ProductQuantityMapper;
import java.util.LinkedList;
import java.util.List;
import java.util.Optional;
import java.util.stream.Collectors;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;
import org.springframework.stereotype.Service;
import org.springframework.transaction.annotation.Transactional;

@Service
@Transactional
public class ProductQuantityServiceImpl
implements ProductQuantityService {
    private final Logger log = LoggerFactory.getLogger(ProductQuantityServiceImpl.class);
    private final ProductQuantityRepository productQuantityRepository;
    private final ProductQuantityMapper productQuantityMapper;

    public ProductQuantityServiceImpl(ProductQuantityRepository productQuantityRepository, ProductQuantityMapper productQuantityMapper) {
        this.productQuantityRepository = productQuantityRepository;
        this.productQuantityMapper = productQuantityMapper;
    }

    public ProductQuantityDTO save(ProductQuantityDTO productQuantityDTO) {
        this.log.debug("Request to save ProductQuantity : {}", (Object)productQuantityDTO);
        ProductQuantity productQuantity = (ProductQuantity)this.productQuantityMapper.toEntity((Object)productQuantityDTO);
        productQuantity = (ProductQuantity)this.productQuantityRepository.save((Object)productQuantity);
        return (ProductQuantityDTO)this.productQuantityMapper.toDto((Object)productQuantity);
    }

    public Optional<ProductQuantityDTO> partialUpdate(ProductQuantityDTO productQuantityDTO) {
        this.log.debug("Request to partially update ProductQuantity : {}", (Object)productQuantityDTO);
        return this.productQuantityRepository.findById((Object)productQuantityDTO.getId()).map(existingProductQuantity -> {
            this.productQuantityMapper.partialUpdate(existingProductQuantity, (Object)productQuantityDTO);
            return existingProductQuantity;
        }).map(arg_0 -> ((ProductQuantityRepository)this.productQuantityRepository).save(arg_0)).map(arg_0 -> ((ProductQuantityMapper)this.productQuantityMapper).toDto(arg_0));
    }

    @Transactional(readOnly=true)
    public List<ProductQuantityDTO> findAll() {
        this.log.debug("Request to get all ProductQuantities");
        return this.productQuantityRepository.findAll().stream().map(arg_0 -> ((ProductQuantityMapper)this.productQuantityMapper).toDto(arg_0)).collect(Collectors.toCollection(LinkedList::new));
    }

    @Transactional(readOnly=true)
    public Optional<ProductQuantityDTO> findOne(Long id) {
        this.log.debug("Request to get ProductQuantity : {}", (Object)id);
        return this.productQuantityRepository.findById((Object)id).map(arg_0 -> ((ProductQuantityMapper)this.productQuantityMapper).toDto(arg_0));
    }

    public void delete(Long id) {
        this.log.debug("Request to delete ProductQuantity : {}", (Object)id);
        this.productQuantityRepository.deleteById((Object)id);
    }
}

