/*
 * Decompiled with CFR 0.152.
 */
package com.distribution.liquidation.upl.service.impl;

import com.distribution.liquidation.upl.domain.AppUser;
import com.distribution.liquidation.upl.domain.AppUserLogin;
import com.distribution.liquidation.upl.repository.AppUserLoginRepository;
import com.distribution.liquidation.upl.repository.AppUserRepository;
import com.distribution.liquidation.upl.security.jwt.TokenProvider;
import com.distribution.liquidation.upl.service.AuthenticationService;
import com.distribution.liquidation.upl.service.SsoService;
import com.distribution.liquidation.upl.service.dto.AuthInfoDTO;
import com.distribution.liquidation.upl.service.dto.AuthInfoMobileDTO;
import com.distribution.liquidation.upl.service.dto.AuthenticationDTO;
import com.distribution.liquidation.upl.service.dto.OktaUserDTO;
import com.distribution.liquidation.upl.service.exception.AuthenticationException;
import java.time.LocalDate;
import java.time.ZoneId;
import java.util.ArrayList;
import java.util.Optional;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;
import org.springframework.security.authentication.UsernamePasswordAuthenticationToken;
import org.springframework.security.core.Authentication;
import org.springframework.security.core.authority.SimpleGrantedAuthority;
import org.springframework.stereotype.Service;
import org.springframework.transaction.annotation.Transactional;

@Service
@Transactional
public class AuthenticationServiceImpl
implements AuthenticationService {
    private final Logger log = LoggerFactory.getLogger(AuthenticationServiceImpl.class);
    private final AppUserRepository appUserRepository;
    private final AppUserLoginRepository appUserLoginRepository;
    private final TokenProvider tokenProvider;
    private final SsoService oktaService;

    public AuthenticationServiceImpl(AppUserRepository appUserRepository, AppUserLoginRepository appUserLoginRepository, TokenProvider tokenProvider, SsoService oktaService) {
        this.appUserRepository = appUserRepository;
        this.appUserLoginRepository = appUserLoginRepository;
        this.tokenProvider = tokenProvider;
        this.oktaService = oktaService;
    }

    public String authenticate(AuthenticationDTO authenticationDTO) {
        this.log.debug("code : {}", (Object)authenticationDTO);
        OktaUserDTO oktaUser = this.oktaService.authenticate(authenticationDTO.getCode());
        String email = oktaUser.getEmail();
        Optional appUser = this.appUserRepository.findByEmail(email);
        if (appUser.isPresent()) {
            AppUser user = (AppUser)appUser.get();
            this.log.debug("User is present {}", (Object)user);
            if (user.isStatus().booleanValue()) {
                ArrayList<SimpleGrantedAuthority> authorities = new ArrayList<SimpleGrantedAuthority>();
                if (user.getRole() != null) {
                    SimpleGrantedAuthority authority = new SimpleGrantedAuthority(user.getRole().name());
                    authorities.add(authority);
                }
                UsernamePasswordAuthenticationToken authentication = new UsernamePasswordAuthenticationToken((Object)user.getId(), (Object)user.getEmail(), authorities);
                String token = this.tokenProvider.createToken((Authentication)authentication, false);
                AppUserLogin appUserLogin = new AppUserLogin();
                appUserLogin.setAppUser(user);
                appUserLogin.setLoginDate(LocalDate.now(ZoneId.systemDefault()));
                appUserLogin.setToken(token);
                this.appUserLoginRepository.save((Object)appUserLogin);
                return token;
            }
            this.log.debug("User is present but inactive throw AuthenticationException");
            throw new AuthenticationException("Invalid Username or Password");
        }
        this.log.debug("User is not present throw AuthenticationException");
        throw new AuthenticationException("Invalid Username or Password");
    }

    public String authenticateMobile(AuthenticationDTO authenticationDTO) {
        this.log.debug("code : {}", (Object)authenticationDTO);
        OktaUserDTO oktaUser = this.oktaService.authenticateAccessCode(authenticationDTO.getCode());
        String email = oktaUser.getEmail();
        Optional appUser = this.appUserRepository.findByEmail(email);
        if (appUser.isPresent()) {
            AppUser user = (AppUser)appUser.get();
            this.log.debug("User is present {}", (Object)user);
            if (user.isStatus().booleanValue()) {
                ArrayList<SimpleGrantedAuthority> authorities = new ArrayList<SimpleGrantedAuthority>();
                if (user.getRole() != null) {
                    SimpleGrantedAuthority authority = new SimpleGrantedAuthority(user.getRole().name());
                    authorities.add(authority);
                }
                UsernamePasswordAuthenticationToken authentication = new UsernamePasswordAuthenticationToken((Object)user.getId(), (Object)user.getEmail(), authorities);
                String token = this.tokenProvider.createToken((Authentication)authentication, false);
                AppUserLogin appUserLogin = new AppUserLogin();
                appUserLogin.setAppUser(user);
                appUserLogin.setLoginDate(LocalDate.now(ZoneId.systemDefault()));
                appUserLogin.setToken(token);
                this.appUserLoginRepository.save((Object)appUserLogin);
                return token;
            }
            this.log.debug("User is present but inactive throw AuthenticationException");
            throw new AuthenticationException("Invalid Username or Password");
        }
        this.log.debug("User is not present throw AuthenticationException");
        throw new AuthenticationException("Invalid Username or Password");
    }

    public Boolean logout(String token) {
        Optional appUserLogin = this.appUserLoginRepository.findByToken(token);
        if (appUserLogin.isPresent()) {
            AppUserLogin updateAppUserLogin = (AppUserLogin)appUserLogin.get();
            updateAppUserLogin.setLogoutDate(LocalDate.now(ZoneId.systemDefault()));
            this.appUserLoginRepository.save((Object)updateAppUserLogin);
            return true;
        }
        this.log.debug("Unable to find user login token");
        return false;
    }

    public AuthInfoDTO authInfo() {
        return this.oktaService.getAuthInfo();
    }

    public AuthInfoMobileDTO authInfoMobile() {
        return this.oktaService.getAuthInfoMobile();
    }
}

