/*
 * Decompiled with CFR 0.152.
 */
package com.distribution.liquidation.upl.service.mapper;

import com.distribution.liquidation.upl.domain.AppUser;
import com.distribution.liquidation.upl.domain.Distributor;
import com.distribution.liquidation.upl.domain.Product;
import com.distribution.liquidation.upl.domain.RfidScan;
import com.distribution.liquidation.upl.service.dto.AppUserDTO;
import com.distribution.liquidation.upl.service.dto.ProductDTO;
import com.distribution.liquidation.upl.service.dto.RfidScanDTO;
import com.distribution.liquidation.upl.service.mapper.DistributorMapper;
import com.distribution.liquidation.upl.service.mapper.ProductMapper;
import java.util.ArrayList;
import java.util.List;
import org.springframework.beans.factory.annotation.Autowired;
import org.springframework.stereotype.Component;

@Component
public class ProductMapperImpl
implements ProductMapper {
    @Autowired
    private DistributorMapper distributorMapper;

    public Product toEntity(ProductDTO dto) {
        if (dto == null) {
            return null;
        }
        Product product = new Product();
        product.setId(dto.getId());
        if (dto.getQuantity() != null) {
            product.setQuantity(Double.valueOf(dto.getQuantity().doubleValue()));
        }
        product.setCreatedDate(dto.getCreatedDate());
        product.distributor((Distributor)this.distributorMapper.toEntity((Object)dto.getDistributor()));
        product.setBarcode(dto.getBarcode());
        product.setBatch(dto.getBatch());
        product.setPrintDate(dto.getPrintDate());
        product.setDispatchDate(dto.getDispatchDate());
        product.setPackingProcessOrder(dto.getPackingProcessOrder());
        product.setPlantCode(dto.getPlantCode());
        product.setSkuCode(dto.getSkuCode());
        product.setProductCode(dto.getProductCode());
        product.setProductDescription(dto.getProductDescription());
        product.setMrpUnit(dto.getMrpUnit());
        product.setBatchNo(dto.getBatchNo());
        product.setExpDate(dto.getExpDate());
        product.setProductHeader(dto.getProductHeader());
        product.setBarcodeCount(dto.getBarcodeCount());
        product.setBarcodeStatus(dto.getBarcodeStatus());
        product.setTableName(dto.getTableName());
        product.setResponse(dto.getResponse());
        product.setPackType(dto.getPackType());
        product.setRfidTag(dto.getRfidTag());
        product.setRfidScan(this.rfidScanDTOToRfidScan(dto.getRfidScan()));
        return product;
    }

    public List<Product> toEntity(List<ProductDTO> dtoList) {
        if (dtoList == null) {
            return null;
        }
        ArrayList<Product> list = new ArrayList<Product>(dtoList.size());
        for (ProductDTO productDTO : dtoList) {
            list.add(this.toEntity(productDTO));
        }
        return list;
    }

    public List<ProductDTO> toDto(List<Product> entityList) {
        if (entityList == null) {
            return null;
        }
        ArrayList<ProductDTO> list = new ArrayList<ProductDTO>(entityList.size());
        for (Product product : entityList) {
            list.add(this.toDto(product));
        }
        return list;
    }

    public void partialUpdate(Product entity, ProductDTO dto) {
        if (dto == null) {
            return;
        }
        if (dto.getId() != null) {
            entity.setId(dto.getId());
        }
        if (dto.getQuantity() != null) {
            entity.setQuantity(Double.valueOf(dto.getQuantity().doubleValue()));
        }
        if (dto.getCreatedDate() != null) {
            entity.setCreatedDate(dto.getCreatedDate());
        }
        if (dto.getDistributor() != null) {
            entity.distributor((Distributor)this.distributorMapper.toEntity((Object)dto.getDistributor()));
        }
        if (dto.getBarcode() != null) {
            entity.setBarcode(dto.getBarcode());
        }
        if (dto.getBatch() != null) {
            entity.setBatch(dto.getBatch());
        }
        if (dto.getPrintDate() != null) {
            entity.setPrintDate(dto.getPrintDate());
        }
        if (dto.getDispatchDate() != null) {
            entity.setDispatchDate(dto.getDispatchDate());
        }
        if (dto.getPackingProcessOrder() != null) {
            entity.setPackingProcessOrder(dto.getPackingProcessOrder());
        }
        if (dto.getPlantCode() != null) {
            entity.setPlantCode(dto.getPlantCode());
        }
        if (dto.getSkuCode() != null) {
            entity.setSkuCode(dto.getSkuCode());
        }
        if (dto.getProductCode() != null) {
            entity.setProductCode(dto.getProductCode());
        }
        if (dto.getProductDescription() != null) {
            entity.setProductDescription(dto.getProductDescription());
        }
        if (dto.getMrpUnit() != null) {
            entity.setMrpUnit(dto.getMrpUnit());
        }
        if (dto.getBatchNo() != null) {
            entity.setBatchNo(dto.getBatchNo());
        }
        if (dto.getExpDate() != null) {
            entity.setExpDate(dto.getExpDate());
        }
        if (dto.getProductHeader() != null) {
            entity.setProductHeader(dto.getProductHeader());
        }
        if (dto.getBarcodeCount() != null) {
            entity.setBarcodeCount(dto.getBarcodeCount());
        }
        if (dto.getBarcodeStatus() != null) {
            entity.setBarcodeStatus(dto.getBarcodeStatus());
        }
        if (dto.getTableName() != null) {
            entity.setTableName(dto.getTableName());
        }
        if (dto.getResponse() != null) {
            entity.setResponse(dto.getResponse());
        }
        if (dto.getPackType() != null) {
            entity.setPackType(dto.getPackType());
        }
        if (dto.getRfidTag() != null) {
            entity.setRfidTag(dto.getRfidTag());
        }
        if (dto.getRfidScan() != null) {
            if (entity.getRfidScan() == null) {
                entity.setRfidScan(new RfidScan());
            }
            this.rfidScanDTOToRfidScan1(dto.getRfidScan(), entity.getRfidScan());
        }
    }

    public ProductDTO toDto(Product s) {
        if (s == null) {
            return null;
        }
        ProductDTO productDTO = new ProductDTO();
        productDTO.setId(s.getId());
        if (s.getQuantity() != null) {
            productDTO.setQuantity(Integer.valueOf(s.getQuantity().intValue()));
        }
        productDTO.setCreatedDate(s.getCreatedDate());
        productDTO.setBatch(s.getBatch());
        productDTO.setPrintDate(s.getPrintDate());
        productDTO.setDispatchDate(s.getDispatchDate());
        productDTO.setPackingProcessOrder(s.getPackingProcessOrder());
        productDTO.setPlantCode(s.getPlantCode());
        productDTO.setSkuCode(s.getSkuCode());
        productDTO.setProductCode(s.getProductCode());
        productDTO.setProductDescription(s.getProductDescription());
        productDTO.setMrpUnit(s.getMrpUnit());
        productDTO.setBatchNo(s.getBatchNo());
        productDTO.setExpDate(s.getExpDate());
        productDTO.setProductHeader(s.getProductHeader());
        productDTO.setBarcodeCount(s.getBarcodeCount());
        productDTO.setBarcodeStatus(s.getBarcodeStatus());
        productDTO.setTableName(s.getTableName());
        productDTO.setResponse(s.getResponse());
        productDTO.setPackType(s.getPackType());
        productDTO.setBarcode(s.getBarcode());
        productDTO.setRfidTag(s.getRfidTag());
        return productDTO;
    }

    protected AppUser appUserDTOToAppUser(AppUserDTO appUserDTO) {
        if (appUserDTO == null) {
            return null;
        }
        AppUser appUser = new AppUser();
        appUser.setId(appUserDTO.getId());
        appUser.setEmail(appUserDTO.getEmail());
        appUser.setName(appUserDTO.getName());
        appUser.setUgdn(appUserDTO.getUgdn());
        appUser.setTerritorycode(appUserDTO.getTerritorycode());
        appUser.setTerritoryName(appUserDTO.getTerritoryName());
        appUser.setCostCentreCode(appUserDTO.getCostCentreCode());
        appUser.setCostCentreName(appUserDTO.getCostCentreName());
        appUser.setTmECN(appUserDTO.getTmECN());
        appUser.setSbuCode(appUserDTO.getSbuCode());
        appUser.setSbuName(appUserDTO.getSbuName());
        appUser.setRole(appUserDTO.getRole());
        appUser.setStatus(appUserDTO.getStatus());
        return appUser;
    }

    protected RfidScan rfidScanDTOToRfidScan(RfidScanDTO rfidScanDTO) {
        if (rfidScanDTO == null) {
            return null;
        }
        RfidScan rfidScan = new RfidScan();
        rfidScan.setId(rfidScanDTO.getId());
        rfidScan.setCreatedDate(rfidScanDTO.getCreatedDate());
        rfidScan.setScanStatus(rfidScanDTO.getScanStatus());
        rfidScan.appUser(this.appUserDTOToAppUser(rfidScanDTO.getAppUser()));
        rfidScan.distributor((Distributor)this.distributorMapper.toEntity((Object)rfidScanDTO.getDistributor()));
        rfidScan.products(this.toEntity(rfidScanDTO.getProducts()));
        rfidScan.setLocationLat(rfidScanDTO.getLocationLat());
        rfidScan.setLocationLong(rfidScanDTO.getLocationLong());
        rfidScan.setLocationCity(rfidScanDTO.getLocationCity());
        return rfidScan;
    }

    protected void appUserDTOToAppUser1(AppUserDTO appUserDTO, AppUser mappingTarget) {
        if (appUserDTO == null) {
            return;
        }
        if (appUserDTO.getId() != null) {
            mappingTarget.setId(appUserDTO.getId());
        }
        if (appUserDTO.getEmail() != null) {
            mappingTarget.setEmail(appUserDTO.getEmail());
        }
        if (appUserDTO.getName() != null) {
            mappingTarget.setName(appUserDTO.getName());
        }
        if (appUserDTO.getUgdn() != null) {
            mappingTarget.setUgdn(appUserDTO.getUgdn());
        }
        if (appUserDTO.getTerritorycode() != null) {
            mappingTarget.setTerritorycode(appUserDTO.getTerritorycode());
        }
        if (appUserDTO.getTerritoryName() != null) {
            mappingTarget.setTerritoryName(appUserDTO.getTerritoryName());
        }
        if (appUserDTO.getCostCentreCode() != null) {
            mappingTarget.setCostCentreCode(appUserDTO.getCostCentreCode());
        }
        if (appUserDTO.getCostCentreName() != null) {
            mappingTarget.setCostCentreName(appUserDTO.getCostCentreName());
        }
        if (appUserDTO.getTmECN() != null) {
            mappingTarget.setTmECN(appUserDTO.getTmECN());
        }
        if (appUserDTO.getSbuCode() != null) {
            mappingTarget.setSbuCode(appUserDTO.getSbuCode());
        }
        if (appUserDTO.getSbuName() != null) {
            mappingTarget.setSbuName(appUserDTO.getSbuName());
        }
        if (appUserDTO.getRole() != null) {
            mappingTarget.setRole(appUserDTO.getRole());
        }
        if (appUserDTO.getStatus() != null) {
            mappingTarget.setStatus(appUserDTO.getStatus());
        }
    }

    protected void rfidScanDTOToRfidScan1(RfidScanDTO rfidScanDTO, RfidScan mappingTarget) {
        if (rfidScanDTO == null) {
            return;
        }
        if (rfidScanDTO.getId() != null) {
            mappingTarget.setId(rfidScanDTO.getId());
        }
        if (rfidScanDTO.getCreatedDate() != null) {
            mappingTarget.setCreatedDate(rfidScanDTO.getCreatedDate());
        }
        if (rfidScanDTO.getScanStatus() != null) {
            mappingTarget.setScanStatus(rfidScanDTO.getScanStatus());
        }
        if (rfidScanDTO.getAppUser() != null) {
            if (mappingTarget.getAppUser() == null) {
                mappingTarget.appUser(new AppUser());
            }
            this.appUserDTOToAppUser1(rfidScanDTO.getAppUser(), mappingTarget.getAppUser());
        }
        if (rfidScanDTO.getDistributor() != null) {
            mappingTarget.distributor((Distributor)this.distributorMapper.toEntity((Object)rfidScanDTO.getDistributor()));
        }
        if (mappingTarget.getProducts() != null) {
            List list = this.toEntity(rfidScanDTO.getProducts());
            if (list != null) {
                mappingTarget.getProducts().clear();
                mappingTarget.getProducts().addAll(list);
            }
        } else {
            List list = this.toEntity(rfidScanDTO.getProducts());
            if (list != null) {
                mappingTarget.products(list);
            }
        }
        if (rfidScanDTO.getLocationLat() != null) {
            mappingTarget.setLocationLat(rfidScanDTO.getLocationLat());
        }
        if (rfidScanDTO.getLocationLong() != null) {
            mappingTarget.setLocationLong(rfidScanDTO.getLocationLong());
        }
        if (rfidScanDTO.getLocationCity() != null) {
            mappingTarget.setLocationCity(rfidScanDTO.getLocationCity());
        }
    }
}

