/*
 * Decompiled with CFR 0.152.
 */
package com.distribution.liquidation.upl.web.rest;

import com.distribution.liquidation.upl.repository.ProductRepository;
import com.distribution.liquidation.upl.security.SecurityUtils;
import com.distribution.liquidation.upl.service.DistributorQueryService;
import com.distribution.liquidation.upl.service.ProductQueryService;
import com.distribution.liquidation.upl.service.ProductService;
import com.distribution.liquidation.upl.service.criteria.DistributorCriteria;
import com.distribution.liquidation.upl.service.criteria.ProductCriteria;
import com.distribution.liquidation.upl.service.dto.DistributorDTO;
import com.distribution.liquidation.upl.service.dto.DistributorWithAllProductsDTO;
import com.distribution.liquidation.upl.service.dto.DistributorWithProductsDTO;
import com.distribution.liquidation.upl.service.dto.ProductDTO;
import com.distribution.liquidation.upl.service.dto.RfidDTO;
import com.distribution.liquidation.upl.web.rest.errors.BadRequestAlertException;
import com.distribution.liquidation.upl.web.rest.vm.MessageVM;
import com.fasterxml.jackson.core.JsonProcessingException;
import java.net.URI;
import java.net.URISyntaxException;
import java.time.Instant;
import java.util.ArrayList;
import java.util.List;
import java.util.Objects;
import java.util.Optional;
import java.util.stream.Collectors;
import javax.validation.Valid;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;
import org.springdoc.api.annotations.ParameterObject;
import org.springframework.beans.factory.annotation.Value;
import org.springframework.data.domain.Page;
import org.springframework.data.domain.PageImpl;
import org.springframework.data.domain.Pageable;
import org.springframework.http.HttpHeaders;
import org.springframework.http.ResponseEntity;
import org.springframework.web.bind.annotation.DeleteMapping;
import org.springframework.web.bind.annotation.GetMapping;
import org.springframework.web.bind.annotation.PatchMapping;
import org.springframework.web.bind.annotation.PathVariable;
import org.springframework.web.bind.annotation.PostMapping;
import org.springframework.web.bind.annotation.PutMapping;
import org.springframework.web.bind.annotation.RequestBody;
import org.springframework.web.bind.annotation.RequestMapping;
import org.springframework.web.bind.annotation.RequestParam;
import org.springframework.web.bind.annotation.RestController;
import org.springframework.web.servlet.support.ServletUriComponentsBuilder;
import org.springframework.web.util.UriComponentsBuilder;
import tech.jhipster.web.util.HeaderUtil;
import tech.jhipster.web.util.PaginationUtil;
import tech.jhipster.web.util.ResponseUtil;

@RestController
@RequestMapping(value={"/api"})
public class ProductResource {
    private final Logger log = LoggerFactory.getLogger(ProductResource.class);
    private static final String ENTITY_NAME = "product";
    @Value(value="${jhipster.clientApp.name}")
    private String applicationName;
    private final ProductService productService;
    private final ProductRepository productRepository;
    private final ProductQueryService productQueryService;
    private final DistributorQueryService distributorQueryService;

    public ProductResource(ProductService productService, ProductRepository productRepository, ProductQueryService productQueryService, DistributorQueryService distributorQueryService) {
        this.productService = productService;
        this.productRepository = productRepository;
        this.productQueryService = productQueryService;
        this.distributorQueryService = distributorQueryService;
    }

    @PostMapping(value={"/products"})
    public ResponseEntity<ProductDTO> createProduct(@RequestBody ProductDTO productDTO) throws URISyntaxException {
        this.log.debug("REST request to save Product : {}", (Object)productDTO);
        if (productDTO.getId() != null) {
            throw new BadRequestAlertException("A new product cannot already have an ID", ENTITY_NAME, "idexists");
        }
        ProductDTO result = this.productService.save(productDTO);
        return ((ResponseEntity.BodyBuilder)ResponseEntity.created((URI)new URI("/api/products/" + result.getId())).headers(HeaderUtil.createEntityCreationAlert((String)this.applicationName, (boolean)false, (String)ENTITY_NAME, (String)result.getId().toString()))).body((Object)result);
    }

    @PostMapping(value={"/products/rfid"})
    public ResponseEntity<MessageVM> createProductFromRfid(@Valid @RequestBody RfidDTO rfidDTO) throws URISyntaxException, JsonProcessingException {
        this.log.debug("REST request to save Product from RFID: {}", (Object)rfidDTO);
        String result = this.productService.fetchProductFromRFID(rfidDTO);
        return ResponseEntity.ok((Object)new MessageVM(result));
    }

    @PutMapping(value={"/products/{id}"})
    public ResponseEntity<ProductDTO> updateProduct(@PathVariable(value="id", required=false) Long id, @RequestBody ProductDTO productDTO) throws URISyntaxException {
        this.log.debug("REST request to update Product : {}, {}", (Object)id, (Object)productDTO);
        if (productDTO.getId() == null) {
            throw new BadRequestAlertException("Invalid id", ENTITY_NAME, "idnull");
        }
        if (!Objects.equals(id, productDTO.getId())) {
            throw new BadRequestAlertException("Invalid ID", ENTITY_NAME, "idinvalid");
        }
        if (!this.productRepository.existsById((Object)id)) {
            throw new BadRequestAlertException("Entity not found", ENTITY_NAME, "idnotfound");
        }
        ProductDTO result = this.productService.save(productDTO);
        return ((ResponseEntity.BodyBuilder)ResponseEntity.ok().headers(HeaderUtil.createEntityUpdateAlert((String)this.applicationName, (boolean)false, (String)ENTITY_NAME, (String)productDTO.getId().toString()))).body((Object)result);
    }

    @PatchMapping(value={"/products/{id}"}, consumes={"application/json", "application/merge-patch+json"})
    public ResponseEntity<ProductDTO> partialUpdateProduct(@PathVariable(value="id", required=false) Long id, @RequestBody ProductDTO productDTO) throws URISyntaxException {
        this.log.debug("REST request to partial update Product partially : {}, {}", (Object)id, (Object)productDTO);
        if (productDTO.getId() == null) {
            throw new BadRequestAlertException("Invalid id", ENTITY_NAME, "idnull");
        }
        if (!Objects.equals(id, productDTO.getId())) {
            throw new BadRequestAlertException("Invalid ID", ENTITY_NAME, "idinvalid");
        }
        if (!this.productRepository.existsById((Object)id)) {
            throw new BadRequestAlertException("Entity not found", ENTITY_NAME, "idnotfound");
        }
        Optional result = this.productService.partialUpdate(productDTO);
        return ResponseUtil.wrapOrNotFound((Optional)result, (HttpHeaders)HeaderUtil.createEntityUpdateAlert((String)this.applicationName, (boolean)false, (String)ENTITY_NAME, (String)productDTO.getId().toString()));
    }

    @GetMapping(value={"/products"})
    public ResponseEntity<List<ProductDTO>> getAllProducts(ProductCriteria criteria, @ParameterObject Pageable pageable) {
        this.log.debug("REST request to get Products by criteria: {}", (Object)criteria);
        Page page = this.productQueryService.findByCriteria(criteria, pageable);
        HttpHeaders headers = PaginationUtil.generatePaginationHttpHeaders((UriComponentsBuilder)ServletUriComponentsBuilder.fromCurrentRequest(), (Page)page);
        return ((ResponseEntity.BodyBuilder)ResponseEntity.ok().headers(headers)).body((Object)page.getContent());
    }

    @GetMapping(value={"/products/count"})
    public ResponseEntity<Long> countProducts(ProductCriteria criteria) {
        this.log.debug("REST request to count Products by criteria: {}", (Object)criteria);
        return ResponseEntity.ok().body((Object)this.productQueryService.countByCriteria(criteria));
    }

    @GetMapping(value={"/products/{id}"})
    public ResponseEntity<ProductDTO> getProduct(@PathVariable Long id) {
        this.log.debug("REST request to get Product : {}", (Object)id);
        Optional productDTO = this.productService.findOne(id);
        return ResponseUtil.wrapOrNotFound((Optional)productDTO);
    }

    @DeleteMapping(value={"/products/{id}"})
    public ResponseEntity<Void> deleteProduct(@PathVariable Long id) {
        this.log.debug("REST request to delete Product : {}", (Object)id);
        this.productService.delete(id);
        return ResponseEntity.noContent().headers(HeaderUtil.createEntityDeletionAlert((String)this.applicationName, (boolean)false, (String)ENTITY_NAME, (String)id.toString())).build();
    }

    @GetMapping(value={"/products/daily-unique-products-count"})
    public ResponseEntity<Long> countDailyUniqueProducts() {
        this.log.debug("REST request to get Daily Unique Product");
        Long appUserId = Long.valueOf((String)SecurityUtils.getCurrentUserLogin().get());
        Long result = this.productQueryService.countDailyUniqueProducts(appUserId);
        return ResponseEntity.ok().body((Object)result);
    }

    @GetMapping(value={"/products/daily-unique-products"})
    public ResponseEntity<Page<DistributorWithProductsDTO>> getProductsForDistributor(@ParameterObject Pageable pageable) {
        this.log.debug("REST request to get Daily Unique Product");
        Long appUserId = Long.valueOf((String)SecurityUtils.getCurrentUserLogin().get());
        List result = this.productQueryService.getProductsForDistributor(appUserId, pageable);
        PageImpl page = new PageImpl(result, pageable, this.productQueryService.countDistributorWithProduct(appUserId, new ArrayList(), null, null).longValue());
        HttpHeaders headers = PaginationUtil.generatePaginationHttpHeaders((UriComponentsBuilder)ServletUriComponentsBuilder.fromCurrentRequest(), (Page)page);
        return ((ResponseEntity.BodyBuilder)ResponseEntity.ok().headers(headers)).body((Object)page);
    }

    @GetMapping(value={"/products/scanned-products"})
    public ResponseEntity<Page<DistributorWithAllProductsDTO>> getScannedProducts(DistributorCriteria criteria, @ParameterObject Pageable pageable, @RequestParam(value="fromDate", required=false) Instant fromDate, @RequestParam(value="toDate", required=false) Instant toDate) {
        this.log.debug("REST request to get Scanned Product History");
        Long appUserId = Long.valueOf((String)SecurityUtils.getCurrentUserLogin().get());
        List distributorIds = null;
        if (criteria.getId() != null || criteria.getCode() != null || criteria.getName() != null || criteria.getDeliveringPlantName() != null || criteria.getDeliveringPlantCode() != null || criteria.getTerritoryCode() != null || criteria.getTerritoryName() != null || criteria.getMobileNumber() != null || criteria.getEmail() != null || criteria.getPriceGroup() != null || criteria.getStatus() != null || criteria.getAppUserId() != null) {
            distributorIds = this.distributorQueryService.findByCriteria(criteria, null).stream().map(DistributorDTO::getId).collect(Collectors.toList());
        }
        List result = this.productQueryService.getProductsInDateRangeForDistributor(appUserId, pageable, distributorIds, fromDate, toDate);
        PageImpl page = new PageImpl(result, pageable, this.productQueryService.countDistributorWithProduct(appUserId, distributorIds, fromDate, toDate).longValue());
        HttpHeaders headers = PaginationUtil.generatePaginationHttpHeaders((UriComponentsBuilder)ServletUriComponentsBuilder.fromCurrentRequest(), (Page)page);
        return ((ResponseEntity.BodyBuilder)ResponseEntity.ok().headers(headers)).body((Object)page);
    }

    @GetMapping(value={"/products/scanned-products/{distributorId}"})
    public ResponseEntity<List<DistributorWithAllProductsDTO>> getScannedProductsForDistributor(@PathVariable(value="distributorId") Long distributorId, @RequestParam(value="fromDate", required=false) Instant fromDate, @RequestParam(value="toDate", required=false) Instant toDate) {
        this.log.debug("REST request to get Scanned Product History");
        Long appUserId = Long.valueOf((String)SecurityUtils.getCurrentUserLogin().get());
        List result = this.productQueryService.getProductsInDateRangeForDistributor(appUserId, distributorId, fromDate, toDate);
        return ResponseEntity.ok().body((Object)result);
    }
}

