/*
 * Decompiled with CFR 0.152.
 */
package com.distribution.liquidation.upl.service;

import com.distribution.liquidation.upl.domain.Distributor;
import com.distribution.liquidation.upl.domain.Distributor_;
import com.distribution.liquidation.upl.domain.Product;
import com.distribution.liquidation.upl.domain.ProductQuantity;
import com.distribution.liquidation.upl.domain.Product_;
import com.distribution.liquidation.upl.domain.RfidScan;
import com.distribution.liquidation.upl.domain.RfidScan_;
import com.distribution.liquidation.upl.domain.enumeration.ScanStatus;
import com.distribution.liquidation.upl.repository.ProductQuantityRepository;
import com.distribution.liquidation.upl.repository.ProductRepository;
import com.distribution.liquidation.upl.repository.RfidScanRepository;
import com.distribution.liquidation.upl.security.SecurityUtils;
import com.distribution.liquidation.upl.service.RfidScanQueryService;
import com.distribution.liquidation.upl.service.criteria.ProductCriteria;
import com.distribution.liquidation.upl.service.criteria.RfidScanCriteria;
import com.distribution.liquidation.upl.service.dto.DistributorWithAllProductsDTO;
import com.distribution.liquidation.upl.service.dto.DistributorWithProductsDTO;
import com.distribution.liquidation.upl.service.dto.ProductDTO;
import com.distribution.liquidation.upl.service.mapper.DistributorMapper;
import com.distribution.liquidation.upl.service.mapper.ProductMapper;
import java.time.Instant;
import java.time.temporal.ChronoUnit;
import java.util.ArrayList;
import java.util.Collections;
import java.util.Comparator;
import java.util.List;
import java.util.Map;
import java.util.Optional;
import java.util.stream.Collectors;
import javax.persistence.EntityManager;
import javax.persistence.NoResultException;
import javax.persistence.TypedQuery;
import javax.persistence.criteria.CriteriaBuilder;
import javax.persistence.criteria.CriteriaQuery;
import javax.persistence.criteria.Expression;
import javax.persistence.criteria.JoinType;
import javax.persistence.criteria.Root;
import javax.persistence.criteria.Selection;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;
import org.springframework.data.domain.Page;
import org.springframework.data.domain.Pageable;
import org.springframework.data.jpa.domain.Specification;
import org.springframework.stereotype.Service;
import org.springframework.transaction.annotation.Transactional;
import tech.jhipster.service.QueryService;
import tech.jhipster.service.filter.InstantFilter;
import tech.jhipster.service.filter.LongFilter;
import tech.jhipster.service.filter.RangeFilter;
import tech.jhipster.service.filter.StringFilter;

@Service
@Transactional(readOnly=true)
public class ProductQueryService
extends QueryService<Product> {
    private final Logger log = LoggerFactory.getLogger(ProductQueryService.class);
    private final ProductRepository productRepository;
    private final ProductMapper productMapper;
    private final DistributorMapper distributorMapper;
    private final RfidScanRepository rfidScanRepository;
    private final ProductQuantityRepository productQuantityRepository;
    private final RfidScanQueryService rfidScanQueryService;
    private final EntityManager entityManager;
    private final Comparator<Product> quantityComparator = (p1, p2) -> (int)(p2.getQuantity() - p1.getQuantity());

    public ProductQueryService(ProductRepository productRepository, ProductMapper productMapper, DistributorMapper distributorMapper, RfidScanRepository rfidScanRepository, ProductQuantityRepository productQuantityRepository, RfidScanQueryService rfidScanQueryService, EntityManager entityManager) {
        this.productRepository = productRepository;
        this.productMapper = productMapper;
        this.distributorMapper = distributorMapper;
        this.rfidScanRepository = rfidScanRepository;
        this.productQuantityRepository = productQuantityRepository;
        this.rfidScanQueryService = rfidScanQueryService;
        this.entityManager = entityManager;
    }

    @Transactional(readOnly=true)
    public List<ProductDTO> findByCriteria(ProductCriteria criteria) {
        this.log.debug("find by criteria : {}", (Object)criteria);
        Specification specification = this.createSpecification(criteria);
        return this.productMapper.toDto(this.productRepository.findAll(specification));
    }

    @Transactional(readOnly=true)
    public Page<ProductDTO> findByCriteria(ProductCriteria criteria, Pageable page) {
        this.log.debug("find by criteria : {}, page: {}", (Object)criteria, (Object)page);
        Specification specification = this.createSpecification(criteria);
        return this.productRepository.findAll(specification, page).map(arg_0 -> ((ProductMapper)this.productMapper).toDto(arg_0));
    }

    @Transactional(readOnly=true)
    public long countByCriteria(ProductCriteria criteria) {
        this.log.debug("count by criteria : {}", (Object)criteria);
        Specification specification = this.createSpecification(criteria);
        return this.productRepository.count(specification);
    }

    @Transactional(readOnly=true)
    public long countDailyUniqueProducts(Long appUserId) {
        this.log.debug("count daily unique products for userId: {}", (Object)appUserId);
        List rfids = this.getRfids(appUserId, Instant.now(), null);
        ProductCriteria criteria = new ProductCriteria();
        LongFilter rfidFilter = new LongFilter();
        rfidFilter.setIn(rfids);
        criteria.setRfidScanId(rfidFilter);
        StringFilter skuFilter = new StringFilter();
        skuFilter.setNotEquals((Object)"");
        criteria.setSkuCode(skuFilter);
        StringFilter barcodeStatus = new StringFilter();
        barcodeStatus.setEquals((Object)"G");
        criteria.setBarcodeStatus(barcodeStatus);
        Specification specification = this.createSpecification(criteria);
        return this.productRepository.count(specification);
    }

    @Transactional(readOnly=true)
    public List<DistributorWithProductsDTO> getProductsForDistributor(Long appUserId, Pageable page) {
        this.log.debug("count daily unique products for userId: {}", (Object)appUserId);
        List rfids = this.getRfidIdsGrouped(this.getRfids(appUserId, null, null), page);
        return this.rfidScanRepository.findAllById((Iterable)rfids).stream().map(rfidScan -> {
            Map<String, List<Product>> groupedProducts = rfidScan.getProducts().stream().filter(p -> p.getBarcodeStatus().equals("G") && !p.getSkuCode().trim().isEmpty()).collect(Collectors.groupingBy(Product::getSkuCode));
            ArrayList distributorProducts = new ArrayList();
            groupedProducts.forEach((skuCode, _products) -> {
                Product product = (Product)_products.get(0);
                Double qty = _products.size();
                qty = this.getQuantityInMT(product, qty);
                product.setQuantity(qty);
                distributorProducts.add(product);
            });
            distributorProducts.sort(this.quantityComparator);
            List topProducts = distributorProducts.subList(0, Math.min(distributorProducts.size(), 3));
            List bottomProducts = distributorProducts.subList(Math.max(0, distributorProducts.size() - 3), distributorProducts.size());
            return this.distributorMapper.toDtoWithProducts(rfidScan.getDistributor(), topProducts, bottomProducts);
        }).collect(Collectors.toList());
    }

    @Transactional(readOnly=true)
    public List<DistributorWithAllProductsDTO> getProductsInDateRangeForDistributor(Long appUserId, Pageable page, List<Long> passedDistributorIds, Instant fromDate, Instant toDate) {
        List finalRfids;
        this.log.debug("get scanned products for userId: {}, {}, {}, {}", new Object[]{appUserId, fromDate, toDate, passedDistributorIds});
        List rfids = this.getRfids(appUserId, fromDate, toDate);
        if (passedDistributorIds != null) {
            List rfidScans = this.rfidScanRepository.findAllById((Iterable)this.getRfidIdsGrouped(rfids, null));
            List validDistributorIds = rfidScans.stream().map(RfidScan::getDistributor).map(Distributor::getId).collect(Collectors.toList());
            passedDistributorIds.removeIf(distributorId -> !validDistributorIds.contains(distributorId));
            finalRfids = rfidScans.stream().filter(rfidScan -> rfids.contains(rfidScan.getId())).filter(rfidScan -> passedDistributorIds.contains(rfidScan.getDistributor().getId())).map(RfidScan::getId).collect(Collectors.toList());
        } else {
            finalRfids = this.getRfidIdsGrouped(rfids, page);
        }
        return this.rfidScanRepository.findAllById((Iterable)finalRfids).stream().map(rfidScan -> this.mapRfidScanToProducts(rfidScan, true)).collect(Collectors.toList());
    }

    @Transactional(readOnly=true)
    public List<DistributorWithAllProductsDTO> getProductsInDateRangeForDistributor(Long appUserId, Long distributorId, Instant fromDate, Instant toDate) {
        this.log.debug("get scanned products for distributor: {}, {}, {}, {}", new Object[]{appUserId, fromDate, toDate, distributorId});
        List rfids = this.getRfids(appUserId, fromDate, toDate);
        return this.rfidScanRepository.findAllById((Iterable)rfids).stream().sorted(Comparator.comparing(RfidScan::getCreatedDate)).filter(rfidScan -> rfidScan.getDistributor().getId().equals(distributorId)).map(rfidScan -> this.mapRfidScanToProducts(rfidScan, false)).collect(Collectors.toList());
    }

    private Instant getLastScannedDate(RfidScanCriteria criteria) {
        Instant lastScannedDate;
        CriteriaBuilder criteriaBuilder = this.entityManager.getCriteriaBuilder();
        CriteriaQuery criteriaQuery = criteriaBuilder.createQuery(Instant.class);
        Root root = criteriaQuery.from(RfidScan.class);
        criteriaQuery = criteriaQuery.select((Selection)root.get(RfidScan_.createdDate));
        if (SecurityUtils.hasCurrentUserThisAuthority((String)"TERRITORY_MANAGER")) {
            criteriaQuery.where((Expression)this.rfidScanQueryService.createSpecification(criteria).toPredicate(root, criteriaQuery, criteriaBuilder));
        }
        criteriaQuery.orderBy(Collections.singletonList(criteriaBuilder.desc((Expression)root.get(RfidScan_.createdDate))));
        TypedQuery q = this.entityManager.createQuery(criteriaQuery).setMaxResults(1);
        try {
            lastScannedDate = (Instant)q.getSingleResult();
        }
        catch (NoResultException ex) {
            lastScannedDate = Instant.now();
        }
        return lastScannedDate;
    }

    private List<Long> getRfidIdsFromQuery(RfidScanCriteria criteria) {
        ArrayList rfids;
        CriteriaBuilder criteriaBuilder = this.entityManager.getCriteriaBuilder();
        CriteriaQuery criteriaQuery = criteriaBuilder.createQuery(Long.class);
        Root root = criteriaQuery.from(RfidScan.class);
        criteriaQuery = criteriaQuery.select((Selection)root.get(RfidScan_.id));
        criteriaQuery.where((Expression)this.rfidScanQueryService.createSpecification(criteria).toPredicate(root, criteriaQuery, criteriaBuilder));
        TypedQuery q = this.entityManager.createQuery(criteriaQuery);
        try {
            rfids = q.getResultList();
        }
        catch (NoResultException ex) {
            rfids = new ArrayList();
        }
        return rfids;
    }

    private List<Long> getRfidIdsGrouped(List<Long> passedRfid, Pageable page) {
        ArrayList rfids;
        RfidScanCriteria criteria = new RfidScanCriteria();
        LongFilter idFilter = new LongFilter();
        idFilter.setIn(passedRfid);
        criteria.setId(idFilter);
        CriteriaBuilder criteriaBuilder = this.entityManager.getCriteriaBuilder();
        CriteriaQuery criteriaQuery = criteriaBuilder.createQuery(Long.class);
        Root root = criteriaQuery.from(RfidScan.class);
        criteriaQuery = criteriaQuery.select((Selection)criteriaBuilder.function("min", Long.class, new Expression[]{root.get(RfidScan_.id)}));
        if (SecurityUtils.hasCurrentUserThisAuthority((String)"TERRITORY_MANAGER")) {
            criteriaQuery.where((Expression)this.rfidScanQueryService.createSpecification(criteria).toPredicate(root, criteriaQuery, criteriaBuilder));
        }
        criteriaQuery.groupBy(new Expression[]{root.get(RfidScan_.distributor).get(Distributor_.id)});
        TypedQuery q = this.entityManager.createQuery(criteriaQuery);
        if (page != null) {
            q.setFirstResult((int)page.getOffset()).setMaxResults(page.getPageSize());
        }
        try {
            rfids = q.getResultList();
        }
        catch (NoResultException ex) {
            rfids = new ArrayList();
        }
        return rfids;
    }

    private List<Long> getRfids(Long appUserId, Instant fromDate, Instant toDate) {
        RfidScanCriteria scanCriteria = new RfidScanCriteria();
        if (SecurityUtils.hasCurrentUserThisAuthority((String)"TERRITORY_MANAGER")) {
            LongFilter appUserFilter = new LongFilter();
            appUserFilter.setEquals((Object)appUserId);
            scanCriteria.setAppUserId(appUserFilter);
        }
        RfidScanCriteria.ScanStatusFilter statusFilter = new RfidScanCriteria.ScanStatusFilter();
        statusFilter.setEquals((Object)ScanStatus.COMPLETE);
        scanCriteria.setScanStatus(statusFilter);
        InstantFilter dateFilter = new InstantFilter();
        if (fromDate == null && toDate == null) {
            dateFilter.setGreaterThanOrEqual(this.getLastScannedDate(scanCriteria).truncatedTo(ChronoUnit.DAYS));
        } else {
            if (fromDate != null) {
                dateFilter.setGreaterThanOrEqual(fromDate.truncatedTo(ChronoUnit.DAYS));
            }
            if (toDate != null) {
                dateFilter.setLessThanOrEqual(toDate.plus(1L, ChronoUnit.DAYS).truncatedTo(ChronoUnit.DAYS));
            }
        }
        scanCriteria.setCreatedDate(dateFilter);
        return this.getRfidIdsFromQuery(scanCriteria);
    }

    protected Specification<Product> createSpecification(ProductCriteria criteria) {
        Specification specification = Specification.where(null);
        if (criteria != null) {
            if (criteria.getDistinct() != null) {
                specification = specification.and(this.distinct(criteria.getDistinct().booleanValue()));
            }
            if (criteria.getId() != null) {
                specification = specification.and(this.buildRangeSpecification((RangeFilter)criteria.getId(), Product_.id));
            }
            if (criteria.getBatch() != null) {
                specification = specification.and(this.buildStringSpecification(criteria.getBarcodeCount(), Product_.batch));
            }
            if (criteria.getPrintDate() != null) {
                specification = specification.and(this.buildStringSpecification(criteria.getPrintDate(), Product_.printDate));
            }
            if (criteria.getDispatchDate() != null) {
                specification = specification.and(this.buildStringSpecification(criteria.getDispatchDate(), Product_.dispatchDate));
            }
            if (criteria.getPackingProcessOrder() != null) {
                specification = specification.and(this.buildStringSpecification(criteria.getPackingProcessOrder(), Product_.packingProcessOrder));
            }
            if (criteria.getPlantCode() != null) {
                specification = specification.and(this.buildStringSpecification(criteria.getPlantCode(), Product_.plantCode));
            }
            if (criteria.getSkuCode() != null) {
                specification = specification.and(this.buildStringSpecification(criteria.getSkuCode(), Product_.skuCode));
            }
            if (criteria.getProductCode() != null) {
                specification = specification.and(this.buildStringSpecification(criteria.getProductCode(), Product_.productCode));
            }
            if (criteria.getProductDescription() != null) {
                specification = specification.and(this.buildStringSpecification(criteria.getProductDescription(), Product_.productDescription));
            }
            if (criteria.getMrpUnit() != null) {
                specification = specification.and(this.buildStringSpecification(criteria.getMrpUnit(), Product_.mrpUnit));
            }
            if (criteria.getBatchNo() != null) {
                specification = specification.and(this.buildStringSpecification(criteria.getBatchNo(), Product_.batchNo));
            }
            if (criteria.getBarcode() != null) {
                specification = specification.and(this.buildStringSpecification(criteria.getBarcode(), Product_.barcode));
            }
            if (criteria.getRfidTag() != null) {
                specification = specification.and(this.buildStringSpecification(criteria.getRfidTag(), Product_.rfidTag));
            }
            if (criteria.getExpDate() != null) {
                specification = specification.and(this.buildStringSpecification(criteria.getExpDate(), Product_.expDate));
            }
            if (criteria.getProductHeader() != null) {
                specification = specification.and(this.buildStringSpecification(criteria.getProductHeader(), Product_.productHeader));
            }
            if (criteria.getBarcodeCount() != null) {
                specification = specification.and(this.buildStringSpecification(criteria.getBarcodeCount(), Product_.barcodeCount));
            }
            if (criteria.getBarcodeStatus() != null) {
                specification = specification.and(this.buildStringSpecification(criteria.getBarcodeStatus(), Product_.barcodeStatus));
            }
            if (criteria.getTableName() != null) {
                specification = specification.and(this.buildStringSpecification(criteria.getTableName(), Product_.tableName));
            }
            if (criteria.getResponse() != null) {
                specification = specification.and(this.buildStringSpecification(criteria.getResponse(), Product_.response));
            }
            if (criteria.getPackType() != null) {
                specification = specification.and(this.buildStringSpecification(criteria.getPackType(), Product_.packType));
            }
            if (criteria.getQuantity() != null) {
                specification = specification.and(this.buildRangeSpecification((RangeFilter)criteria.getQuantity(), Product_.quantity));
            }
            if (criteria.getCreationDate() != null) {
                specification = specification.and(this.buildRangeSpecification((RangeFilter)criteria.getCreationDate(), Product_.createdDate));
            }
            if (criteria.getDistributorId() != null) {
                specification = specification.and(this.buildSpecification((RangeFilter)criteria.getDistributorId(), root -> root.join(Product_.distributor, JoinType.LEFT).get(Distributor_.id)));
            }
            if (criteria.getRfidScanId() != null) {
                specification = specification.and(this.buildSpecification((RangeFilter)criteria.getRfidScanId(), root -> root.join(Product_.rfidScan, JoinType.LEFT).get(RfidScan_.id)));
            }
        }
        return specification;
    }

    public Long countDistributorWithProduct(Long appUserId, List<Long> passedDistributorIds, Instant fromDate, Instant toDate) {
        List rfids = this.getRfidIdsGrouped(this.getRfids(appUserId, fromDate, toDate), null);
        if (passedDistributorIds != null) {
            List validDistributorIds = this.rfidScanRepository.findAllById((Iterable)rfids).stream().map(RfidScan::getDistributor).map(Distributor::getId).collect(Collectors.toList());
            passedDistributorIds.removeIf(distributorId -> !validDistributorIds.contains(distributorId));
            return passedDistributorIds.size();
        }
        return rfids.size();
    }

    private DistributorWithAllProductsDTO mapRfidScanToProducts(RfidScan rfidScan, boolean onlyFewNeeded) {
        Map<String, List<Product>> groupedProducts = rfidScan.getProducts().stream().filter(p -> p.getBarcodeStatus().equals("G") && !p.getSkuCode().trim().isEmpty()).collect(Collectors.groupingBy(Product::getSkuCode));
        ArrayList distributorProducts = new ArrayList();
        groupedProducts.forEach((skuCode, _products) -> {
            Product product = (Product)_products.get(0);
            Double qty = _products.size();
            qty = this.getQuantityInMT(product, qty);
            product.setQuantity(qty);
            distributorProducts.add(product);
        });
        distributorProducts.sort(this.quantityComparator);
        return this.distributorMapper.toDtoWithAllProducts(rfidScan, rfidScan.getDistributor(), onlyFewNeeded ? distributorProducts.subList(0, Math.min(distributorProducts.size(), 5)) : distributorProducts);
    }

    private Double getQuantityInMT(Product product, Double qty) {
        Optional savedQty = this.productQuantityRepository.findByMaterial(product.getSkuCode());
        if (savedQty.isPresent()) {
            ProductQuantity productQuantity = (ProductQuantity)savedQty.get();
            qty = qty * (double)productQuantity.getPackSize().intValue();
            switch (productQuantity.getBaseUnit()) {
                case "KG": 
                case "L": {
                    qty = qty / 1000.0;
                    break;
                }
                case "GM": 
                case "ML": {
                    qty = qty / 1000000.0;
                    break;
                }
                default: {
                    qty = qty / 1.0;
                }
            }
        }
        return qty;
    }
}

