/*
 * Decompiled with CFR 0.152.
 */
package com.distribution.liquidation.upl.web.rest;

import com.distribution.liquidation.upl.domain.enumeration.ScanStatus;
import com.distribution.liquidation.upl.repository.RfidScanRepository;
import com.distribution.liquidation.upl.service.RfidScanQueryService;
import com.distribution.liquidation.upl.service.RfidScanService;
import com.distribution.liquidation.upl.service.criteria.RfidScanCriteria;
import com.distribution.liquidation.upl.service.dto.RfidScanDTO;
import com.distribution.liquidation.upl.web.rest.errors.BadRequestAlertException;
import java.net.URI;
import java.net.URISyntaxException;
import java.time.Instant;
import java.util.List;
import java.util.Objects;
import java.util.Optional;
import javax.validation.Valid;
import javax.validation.constraints.NotNull;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;
import org.springframework.beans.factory.annotation.Value;
import org.springframework.http.HttpHeaders;
import org.springframework.http.ResponseEntity;
import org.springframework.web.bind.annotation.DeleteMapping;
import org.springframework.web.bind.annotation.GetMapping;
import org.springframework.web.bind.annotation.PatchMapping;
import org.springframework.web.bind.annotation.PathVariable;
import org.springframework.web.bind.annotation.PostMapping;
import org.springframework.web.bind.annotation.PutMapping;
import org.springframework.web.bind.annotation.RequestBody;
import org.springframework.web.bind.annotation.RequestMapping;
import org.springframework.web.bind.annotation.RestController;
import tech.jhipster.web.util.HeaderUtil;
import tech.jhipster.web.util.ResponseUtil;

@RestController
@RequestMapping(value={"/api"})
public class RfidScanResource {
    private final Logger log = LoggerFactory.getLogger(RfidScanResource.class);
    private static final String ENTITY_NAME = "rfidScan";
    @Value(value="${jhipster.clientApp.name}")
    private String applicationName;
    private final RfidScanService rfidScanService;
    private final RfidScanRepository rfidScanRepository;
    private final RfidScanQueryService rfidScanQueryService;

    public RfidScanResource(RfidScanService rfidScanService, RfidScanRepository rfidScanRepository, RfidScanQueryService rfidScanQueryService) {
        this.rfidScanService = rfidScanService;
        this.rfidScanRepository = rfidScanRepository;
        this.rfidScanQueryService = rfidScanQueryService;
    }

    @PostMapping(value={"/rfid-scans"})
    public ResponseEntity<RfidScanDTO> createRfidScan(@Valid @RequestBody RfidScanDTO rfidScanDTO) throws URISyntaxException {
        this.log.debug("REST request to save RfidScan : {}", (Object)rfidScanDTO);
        rfidScanDTO.setScanStatus(ScanStatus.SCANNING);
        rfidScanDTO.setCreatedDate(Instant.now());
        if (rfidScanDTO.getId() != null) {
            throw new BadRequestAlertException("A new rfidScan cannot already have an ID", ENTITY_NAME, "idexists");
        }
        RfidScanDTO result = this.rfidScanService.save(rfidScanDTO);
        return ((ResponseEntity.BodyBuilder)ResponseEntity.created((URI)new URI("/api/rfid-scans/" + result.getId())).headers(HeaderUtil.createEntityCreationAlert((String)this.applicationName, (boolean)false, (String)ENTITY_NAME, (String)result.getId().toString()))).body((Object)result);
    }

    @PutMapping(value={"/rfid-scans/{id}"})
    public ResponseEntity<RfidScanDTO> updateRfidScan(@PathVariable(value="id", required=false) Long id, @Valid @RequestBody RfidScanDTO rfidScanDTO) throws URISyntaxException {
        this.log.debug("REST request to update RfidScan : {}, {}", (Object)id, (Object)rfidScanDTO);
        if (rfidScanDTO.getId() == null) {
            throw new BadRequestAlertException("Invalid id", ENTITY_NAME, "idnull");
        }
        if (!Objects.equals(id, rfidScanDTO.getId())) {
            throw new BadRequestAlertException("Invalid ID", ENTITY_NAME, "idinvalid");
        }
        if (!this.rfidScanRepository.existsById((Object)id)) {
            throw new BadRequestAlertException("Entity not found", ENTITY_NAME, "idnotfound");
        }
        RfidScanDTO result = this.rfidScanService.save(rfidScanDTO);
        return ((ResponseEntity.BodyBuilder)ResponseEntity.ok().headers(HeaderUtil.createEntityUpdateAlert((String)this.applicationName, (boolean)false, (String)ENTITY_NAME, (String)rfidScanDTO.getId().toString()))).body((Object)result);
    }

    @PatchMapping(value={"/rfid-scans/{id}"}, consumes={"application/json", "application/merge-patch+json"})
    public ResponseEntity<RfidScanDTO> partialUpdateRfidScan(@PathVariable(value="id", required=false) Long id, @NotNull @RequestBody RfidScanDTO rfidScanDTO) throws URISyntaxException {
        this.log.debug("REST request to partial update RfidScan partially : {}, {}", (Object)id, (Object)rfidScanDTO);
        if (rfidScanDTO.getId() == null) {
            throw new BadRequestAlertException("Invalid id", ENTITY_NAME, "idnull");
        }
        if (!Objects.equals(id, rfidScanDTO.getId())) {
            throw new BadRequestAlertException("Invalid ID", ENTITY_NAME, "idinvalid");
        }
        if (!this.rfidScanRepository.existsById((Object)id)) {
            throw new BadRequestAlertException("Entity not found", ENTITY_NAME, "idnotfound");
        }
        Optional result = this.rfidScanService.partialUpdate(rfidScanDTO);
        return ResponseUtil.wrapOrNotFound((Optional)result, (HttpHeaders)HeaderUtil.createEntityUpdateAlert((String)this.applicationName, (boolean)false, (String)ENTITY_NAME, (String)rfidScanDTO.getId().toString()));
    }

    @GetMapping(value={"/rfid-scans"})
    public ResponseEntity<List<RfidScanDTO>> getAllRfidScans(RfidScanCriteria criteria) {
        this.log.debug("REST request to get RfidScans by criteria: {}", (Object)criteria);
        List entityList = this.rfidScanQueryService.findByCriteria(criteria);
        return ResponseEntity.ok().body((Object)entityList);
    }

    @GetMapping(value={"/rfid-scans/count"})
    public ResponseEntity<Long> countRfidScans(RfidScanCriteria criteria) {
        this.log.debug("REST request to count RfidScans by criteria: {}", (Object)criteria);
        return ResponseEntity.ok().body((Object)this.rfidScanQueryService.countByCriteria(criteria));
    }

    @GetMapping(value={"/rfid-scans/{id}"})
    public ResponseEntity<RfidScanDTO> getRfidScan(@PathVariable Long id) {
        this.log.debug("REST request to get RfidScan : {}", (Object)id);
        Optional rfidScanDTO = this.rfidScanService.findOne(id);
        return ResponseUtil.wrapOrNotFound((Optional)rfidScanDTO);
    }

    @DeleteMapping(value={"/rfid-scans/{id}"})
    public ResponseEntity<Void> deleteRfidScan(@PathVariable Long id) {
        this.log.debug("REST request to delete RfidScan : {}", (Object)id);
        this.rfidScanService.delete(id);
        return ResponseEntity.noContent().headers(HeaderUtil.createEntityDeletionAlert((String)this.applicationName, (boolean)false, (String)ENTITY_NAME, (String)id.toString())).build();
    }
}

