/*
 * Decompiled with CFR 0.152.
 */
package com.distribution.liquidation.upl.service;

import com.distribution.liquidation.upl.domain.Address_;
import com.distribution.liquidation.upl.domain.AppUser_;
import com.distribution.liquidation.upl.domain.Distributor;
import com.distribution.liquidation.upl.domain.Distributor_;
import com.distribution.liquidation.upl.repository.DistributorRepository;
import com.distribution.liquidation.upl.security.SecurityUtils;
import com.distribution.liquidation.upl.service.criteria.DistributorCriteria;
import com.distribution.liquidation.upl.service.dto.DistributorDTO;
import com.distribution.liquidation.upl.service.mapper.DistributorMapper;
import java.util.List;
import javax.persistence.criteria.JoinType;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;
import org.springframework.data.domain.Page;
import org.springframework.data.domain.Pageable;
import org.springframework.data.jpa.domain.Specification;
import org.springframework.stereotype.Service;
import org.springframework.transaction.annotation.Transactional;
import tech.jhipster.service.QueryService;
import tech.jhipster.service.filter.Filter;
import tech.jhipster.service.filter.LongFilter;
import tech.jhipster.service.filter.RangeFilter;

@Service
@Transactional(readOnly=true)
public class DistributorQueryService
extends QueryService<Distributor> {
    private final Logger log = LoggerFactory.getLogger(DistributorQueryService.class);
    private final DistributorRepository distributorRepository;
    private final DistributorMapper distributorMapper;

    public DistributorQueryService(DistributorRepository distributorRepository, DistributorMapper distributorMapper) {
        this.distributorRepository = distributorRepository;
        this.distributorMapper = distributorMapper;
    }

    @Transactional(readOnly=true)
    public List<DistributorDTO> findByCriteria(DistributorCriteria criteria) {
        this.log.debug("find by criteria : {}", (Object)criteria);
        Specification specification = this.createSpecification(criteria);
        return this.distributorMapper.toDto(this.distributorRepository.findAll(specification));
    }

    @Transactional(readOnly=true)
    public Page<DistributorDTO> findByCriteria(DistributorCriteria criteria, Pageable page, Long appUserId) {
        this.log.debug("find by criteria : {}, page: {}", (Object)criteria, (Object)page);
        if (SecurityUtils.hasCurrentUserThisAuthority((String)"TERRITORY_MANAGER")) {
            LongFilter appUserFilter = new LongFilter();
            appUserFilter.setEquals((Object)appUserId);
            criteria.setAppUserId(appUserFilter);
        }
        Specification specification = this.createSpecification(criteria);
        return this.distributorRepository.findAll(specification, page).map(arg_0 -> ((DistributorMapper)this.distributorMapper).toDto(arg_0));
    }

    @Transactional(readOnly=true)
    public long countByCriteria(DistributorCriteria criteria) {
        this.log.debug("count by criteria : {}", (Object)criteria);
        Specification specification = this.createSpecification(criteria);
        return this.distributorRepository.count(specification);
    }

    protected Specification<Distributor> createSpecification(DistributorCriteria criteria) {
        Specification specification = Specification.where(null);
        if (criteria != null) {
            if (criteria.getDistinct() != null) {
                specification = specification.and(this.distinct(criteria.getDistinct().booleanValue()));
            }
            if (criteria.getId() != null) {
                specification = specification.and(this.buildRangeSpecification((RangeFilter)criteria.getId(), Distributor_.id));
            }
            if (criteria.getCode() != null) {
                specification = specification.and(this.buildStringSpecification(criteria.getCode(), Distributor_.code));
            }
            if (criteria.getName() != null) {
                specification = specification.and(this.buildStringSpecification(criteria.getName(), Distributor_.name));
            }
            if (criteria.getDeliveringPlantName() != null) {
                specification = specification.and(this.buildStringSpecification(criteria.getDeliveringPlantName(), Distributor_.deliveringPlantName));
            }
            if (criteria.getDeliveringPlantCode() != null) {
                specification = specification.and(this.buildStringSpecification(criteria.getDeliveringPlantCode(), Distributor_.deliveringPlantCode));
            }
            if (criteria.getTerritoryCode() != null) {
                specification = specification.and(this.buildRangeSpecification((RangeFilter)criteria.getTerritoryCode(), Distributor_.territoryCode));
            }
            if (criteria.getTerritoryName() != null) {
                specification = specification.and(this.buildStringSpecification(criteria.getTerritoryName(), Distributor_.territoryName));
            }
            if (criteria.getMobileNumber() != null) {
                specification = specification.and(this.buildStringSpecification(criteria.getMobileNumber(), Distributor_.mobileNumber));
            }
            if (criteria.getEmail() != null) {
                specification = specification.and(this.buildStringSpecification(criteria.getEmail(), Distributor_.email));
            }
            if (criteria.getPriceGroup() != null) {
                specification = specification.and(this.buildSpecification((Filter)criteria.getPriceGroup(), Distributor_.priceGroup));
            }
            if (criteria.getStatus() != null) {
                specification = specification.and(this.buildSpecification((Filter)criteria.getStatus(), Distributor_.status));
            }
            if (criteria.getAddressId() != null) {
                specification = specification.and(this.buildSpecification((RangeFilter)criteria.getAddressId(), root -> root.join(Distributor_.address, JoinType.LEFT).get(Address_.id)));
            }
            if (criteria.getAppUserId() != null) {
                specification = specification.and(this.buildSpecification((RangeFilter)criteria.getAppUserId(), root -> root.join(Distributor_.appUser, JoinType.LEFT).get(AppUser_.id)));
            }
        }
        return specification;
    }
}

