/*
 * Decompiled with CFR 0.152.
 */
package com.distribution.liquidation.upl.service.impl;

import com.distribution.liquidation.upl.service.SsoService;
import com.distribution.liquidation.upl.service.dto.AuthInfoDTO;
import com.distribution.liquidation.upl.service.dto.AuthInfoMobileDTO;
import com.distribution.liquidation.upl.service.dto.OktaAuthDTO;
import com.distribution.liquidation.upl.service.dto.OktaUserDTO;
import com.distribution.liquidation.upl.service.exception.CustomBadRequestException;
import java.io.UnsupportedEncodingException;
import java.net.URLEncoder;
import java.nio.charset.StandardCharsets;
import java.util.Arrays;
import java.util.Collections;
import java.util.HashMap;
import java.util.Random;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;
import org.springframework.beans.factory.annotation.Autowired;
import org.springframework.beans.factory.annotation.Value;
import org.springframework.http.HttpEntity;
import org.springframework.http.HttpHeaders;
import org.springframework.http.HttpMethod;
import org.springframework.http.MediaType;
import org.springframework.stereotype.Service;
import org.springframework.transaction.annotation.Transactional;
import org.springframework.util.LinkedMultiValueMap;
import org.springframework.util.MultiValueMap;
import org.springframework.web.client.RestTemplate;

@Service
@Transactional
public class OktaServiceImpl
implements SsoService {
    @Value(value="${application.oauth.web.redirect-base-uri}")
    private String redirectBaseUrl;
    @Value(value="${application.oauth.web.issuer-url}")
    private String issuerUrl;
    @Value(value="${application.oauth.web.client-id}")
    private String clientId;
    @Value(value="${application.oauth.web.client-secret}")
    private String clientSecret;
    @Value(value="${application.oauth.mobile.issuer-url}")
    private String mobileIssuerUrl;
    @Value(value="${application.oauth.mobile.client-id}")
    private String mobileClientId;
    @Value(value="${application.oauth.mobile.redirect-uri}")
    private String mobileRedirectUri;
    @Value(value="${application.oauth.mobile.end-session-redirect-uri}")
    private String mobileEndSessionRedirectUri;
    @Value(value="${application.oauth.mobile.discovery-uri}")
    private String mobileDiscoveryUri;
    @Value(value="${application.oauth.mobile.require-hardware-backed-key-store}")
    private Boolean mobileRequireHardwareBackedKeyStore;
    HttpHeaders headers = new HttpHeaders();
    @Autowired
    RestTemplate restTemplate;
    final Logger log = LoggerFactory.getLogger(OktaServiceImpl.class);

    public OktaUserDTO authenticate(String authCode) {
        LinkedMultiValueMap data = new LinkedMultiValueMap();
        data.add((Object)"grant_type", (Object)"authorization_code");
        data.add((Object)"redirect_uri", (Object)(this.redirectBaseUrl + "/login"));
        data.add((Object)"code", (Object)authCode);
        this.headers.setContentType(MediaType.APPLICATION_FORM_URLENCODED);
        this.headers.setBasicAuth(this.clientId, this.clientSecret);
        this.headers.setAccept(Collections.singletonList(MediaType.APPLICATION_JSON));
        HttpEntity entity = new HttpEntity((Object)data, (MultiValueMap)this.headers);
        OktaAuthDTO response = (OktaAuthDTO)this.restTemplate.exchange(this.issuerUrl + "/oauth2/v1/token", HttpMethod.POST, entity, OktaAuthDTO.class, new Object[0]).getBody();
        assert (response != null);
        return this.getUserInfo(response.getAccessToken(), "/oauth2/v1/userinfo");
    }

    public OktaUserDTO authenticateAccessCode(String accessCode) {
        return this.getUserInfo(accessCode, "/oauth2/default/v1/userinfo");
    }

    public OktaUserDTO getUserInfo(String accessToken, String path) {
        this.headers.setBearerAuth(accessToken);
        HttpEntity entity = new HttpEntity((Object)"", (MultiValueMap)this.headers);
        return (OktaUserDTO)this.restTemplate.exchange(this.issuerUrl + path, HttpMethod.GET, entity, OktaUserDTO.class, new Object[0]).getBody();
    }

    public AuthInfoDTO getAuthInfo() {
        HashMap<String, String> loginUrlParams = new HashMap<String, String>();
        byte[] randomString = new byte[7];
        new Random().nextBytes(randomString);
        loginUrlParams.put("client_id", this.clientId);
        loginUrlParams.put("redirect_uri", this.redirectBaseUrl + "/login");
        loginUrlParams.put("state", new String(randomString, StandardCharsets.UTF_8));
        loginUrlParams.put("response_type", "code");
        loginUrlParams.put("response_mode", "query");
        loginUrlParams.put("scope", "openid profile email");
        String loginUrl = this.issuerUrl + "/oauth2/v1/authorize?" + loginUrlParams.entrySet().stream().map(p -> {
            try {
                return URLEncoder.encode((String)p.getKey(), "UTF-8") + "=" + URLEncoder.encode((String)p.getValue(), "UTF-8");
            }
            catch (UnsupportedEncodingException e) {
                this.log.error(e.getMessage());
                throw new CustomBadRequestException("Something went wrong. Please try again later.");
            }
        }).reduce((p1, p2) -> p1 + "&" + p2).orElse("");
        HashMap<String, String> logoutUrlParams = new HashMap<String, String>();
        logoutUrlParams.put("fromURI", this.redirectBaseUrl + "/logout");
        String logoutUrl = this.issuerUrl + "/login/signout?" + logoutUrlParams.entrySet().stream().map(p -> {
            try {
                return URLEncoder.encode((String)p.getKey(), "UTF-8") + "=" + URLEncoder.encode((String)p.getValue(), "UTF-8");
            }
            catch (UnsupportedEncodingException e) {
                throw new UnsupportedOperationException(e);
            }
        }).reduce((p1, p2) -> p1 + "&" + p2).orElse("");
        AuthInfoDTO authInfoDTO = new AuthInfoDTO();
        authInfoDTO.setLoginUrl(loginUrl);
        authInfoDTO.setLogoutUrl(logoutUrl);
        return authInfoDTO;
    }

    public AuthInfoMobileDTO getAuthInfoMobile() {
        AuthInfoMobileDTO authInfoMobileDTO = new AuthInfoMobileDTO();
        authInfoMobileDTO.setClientId(this.mobileClientId);
        authInfoMobileDTO.setIssuerUrl(this.mobileIssuerUrl);
        authInfoMobileDTO.setRedirectUri(this.mobileRedirectUri);
        authInfoMobileDTO.setDiscoveryUri(this.mobileDiscoveryUri);
        authInfoMobileDTO.setEndSessionRedirectUri(this.mobileEndSessionRedirectUri);
        authInfoMobileDTO.setRequireHardwareBackedKeyStore(Boolean.valueOf(false));
        authInfoMobileDTO.setScopes(Arrays.asList("openid", "profile", "email", "offline_access"));
        return authInfoMobileDTO;
    }
}

