/*
 * Decompiled with CFR 0.152.
 */
package com.distribution.liquidation.upl.config;

import com.distribution.liquidation.upl.security.jwt.JWTConfigurer;
import com.distribution.liquidation.upl.security.jwt.TokenProvider;
import javax.servlet.Filter;
import org.springframework.context.annotation.Import;
import org.springframework.http.HttpMethod;
import org.springframework.security.config.annotation.SecurityConfigurerAdapter;
import org.springframework.security.config.annotation.method.configuration.EnableGlobalMethodSecurity;
import org.springframework.security.config.annotation.web.builders.HttpSecurity;
import org.springframework.security.config.annotation.web.builders.WebSecurity;
import org.springframework.security.config.annotation.web.configuration.EnableWebSecurity;
import org.springframework.security.config.annotation.web.configuration.WebSecurityConfigurerAdapter;
import org.springframework.security.config.annotation.web.configurers.ExpressionUrlAuthorizationConfigurer;
import org.springframework.security.config.http.SessionCreationPolicy;
import org.springframework.security.web.AuthenticationEntryPoint;
import org.springframework.security.web.access.AccessDeniedHandler;
import org.springframework.security.web.authentication.UsernamePasswordAuthenticationFilter;
import org.springframework.security.web.header.writers.ReferrerPolicyHeaderWriter;
import org.springframework.web.filter.CorsFilter;
import org.zalando.problem.spring.web.advice.security.SecurityProblemSupport;
import tech.jhipster.config.JHipsterProperties;

@EnableWebSecurity
@EnableGlobalMethodSecurity(prePostEnabled=true, securedEnabled=true)
@Import(value={SecurityProblemSupport.class})
public class SecurityConfiguration
extends WebSecurityConfigurerAdapter {
    private final JHipsterProperties jHipsterProperties;
    private final TokenProvider tokenProvider;
    private final CorsFilter corsFilter;
    private final SecurityProblemSupport problemSupport;

    public SecurityConfiguration(TokenProvider tokenProvider, CorsFilter corsFilter, JHipsterProperties jHipsterProperties, SecurityProblemSupport problemSupport) {
        this.tokenProvider = tokenProvider;
        this.corsFilter = corsFilter;
        this.problemSupport = problemSupport;
        this.jHipsterProperties = jHipsterProperties;
    }

    public void configure(WebSecurity web) {
        ((WebSecurity.IgnoredRequestConfigurer)((WebSecurity.IgnoredRequestConfigurer)web.ignoring().antMatchers(HttpMethod.OPTIONS, new String[]{"/**"})).antMatchers(new String[]{"/swagger-ui/**"})).antMatchers(new String[]{"/test/**"});
    }

    public void configure(HttpSecurity http) throws Exception {
        ((HttpSecurity)((HttpSecurity)((ExpressionUrlAuthorizationConfigurer.AuthorizedUrl)((ExpressionUrlAuthorizationConfigurer.AuthorizedUrl)((ExpressionUrlAuthorizationConfigurer.AuthorizedUrl)((ExpressionUrlAuthorizationConfigurer.AuthorizedUrl)((ExpressionUrlAuthorizationConfigurer.AuthorizedUrl)((ExpressionUrlAuthorizationConfigurer.AuthorizedUrl)((ExpressionUrlAuthorizationConfigurer.AuthorizedUrl)((ExpressionUrlAuthorizationConfigurer.AuthorizedUrl)((ExpressionUrlAuthorizationConfigurer.AuthorizedUrl)((ExpressionUrlAuthorizationConfigurer.AuthorizedUrl)((ExpressionUrlAuthorizationConfigurer.AuthorizedUrl)((ExpressionUrlAuthorizationConfigurer.AuthorizedUrl)((HttpSecurity)((HttpSecurity)((HttpSecurity)((HttpSecurity)http.csrf().disable()).addFilterBefore((Filter)this.corsFilter, UsernamePasswordAuthenticationFilter.class).exceptionHandling().authenticationEntryPoint((AuthenticationEntryPoint)this.problemSupport).accessDeniedHandler((AccessDeniedHandler)this.problemSupport).and()).headers().contentSecurityPolicy(this.jHipsterProperties.getSecurity().getContentSecurityPolicy()).and().referrerPolicy(ReferrerPolicyHeaderWriter.ReferrerPolicy.STRICT_ORIGIN_WHEN_CROSS_ORIGIN).and().permissionsPolicy().policy("camera=(), fullscreen=(self), geolocation=(), gyroscope=(), magnetometer=(), microphone=(), midi=(), payment=(), sync-xhr=()").and().frameOptions().deny().and()).sessionManagement().sessionCreationPolicy(SessionCreationPolicy.STATELESS).and()).authorizeRequests().antMatchers(HttpMethod.OPTIONS, new String[]{"/api/**"})).permitAll().antMatchers(new String[]{"/api/authenticate"})).permitAll().antMatchers(new String[]{"/api/authenticate-mobile"})).permitAll().antMatchers(new String[]{"/api/auth-info"})).permitAll().antMatchers(new String[]{"/api/auth-info-mobile"})).permitAll().antMatchers(new String[]{"/api/admin/**"})).hasAuthority("ROLE_ADMIN").antMatchers(new String[]{"/api/**"})).authenticated().antMatchers(new String[]{"/management/health"})).permitAll().antMatchers(new String[]{"/management/health/**"})).permitAll().antMatchers(new String[]{"/management/info"})).permitAll().antMatchers(new String[]{"/management/prometheus"})).permitAll().antMatchers(new String[]{"/management/**"})).hasAuthority("ROLE_ADMIN").and()).httpBasic().and()).apply((SecurityConfigurerAdapter)this.securityConfigurerAdapter());
    }

    private JWTConfigurer securityConfigurerAdapter() {
        return new JWTConfigurer(this.tokenProvider);
    }
}

