/*
 * Decompiled with CFR 0.152.
 */
package com.distribution.liquidation.upl.service.impl;

import com.distribution.liquidation.upl.service.FileService;
import com.distribution.liquidation.upl.service.ProductQueryService;
import com.distribution.liquidation.upl.service.dto.DistributorWithAllProductsDTO;
import com.distribution.liquidation.upl.service.dto.FileDTO;
import java.io.ByteArrayOutputStream;
import java.io.IOException;
import java.io.OutputStream;
import java.time.Instant;
import java.time.ZoneId;
import java.time.format.DateTimeFormatter;
import java.util.Arrays;
import java.util.Collection;
import java.util.List;
import java.util.concurrent.atomic.AtomicInteger;
import java.util.stream.Collectors;
import org.apache.poi.ss.usermodel.BorderStyle;
import org.apache.poi.ss.usermodel.Cell;
import org.apache.poi.ss.usermodel.CellStyle;
import org.apache.poi.ss.usermodel.FillPatternType;
import org.apache.poi.ss.usermodel.Font;
import org.apache.poi.ss.usermodel.HorizontalAlignment;
import org.apache.poi.ss.usermodel.IndexedColors;
import org.apache.poi.ss.usermodel.Row;
import org.apache.poi.ss.util.CellRangeAddress;
import org.apache.poi.xssf.usermodel.XSSFCellStyle;
import org.apache.poi.xssf.usermodel.XSSFFont;
import org.apache.poi.xssf.usermodel.XSSFRow;
import org.apache.poi.xssf.usermodel.XSSFSheet;
import org.apache.poi.xssf.usermodel.XSSFWorkbook;
import org.springframework.stereotype.Service;

@Service
public class FileServiceImpl
implements FileService {
    private final ProductQueryService productQueryService;

    public FileServiceImpl(ProductQueryService productQueryService) {
        this.productQueryService = productQueryService;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public FileDTO exportScannedProducts(Long appUserId, List<Long> passedDistributorIds, Instant fromDate, Instant toDate) throws IOException {
        List distributorIds = this.productQueryService.getProductsInDateRangeForDistributor(appUserId, null, passedDistributorIds, fromDate, toDate).stream().map(DistributorWithAllProductsDTO::getId).collect(Collectors.toList());
        List data = distributorIds.stream().map(distributorId -> this.productQueryService.getProductsInDateRangeForDistributor(appUserId, distributorId, fromDate, toDate)).flatMap(Collection::stream).collect(Collectors.toList());
        ByteArrayOutputStream bos = new ByteArrayOutputStream();
        XSSFWorkbook workbook = this.createExcel(data);
        try {
            workbook.write((OutputStream)bos);
        }
        finally {
            workbook.close();
            bos.close();
        }
        return new FileDTO("history.xlsx", bos.toByteArray());
    }

    private XSSFWorkbook createExcel(List<DistributorWithAllProductsDTO> data) {
        XSSFWorkbook workbook = new XSSFWorkbook();
        XSSFSheet sheet = workbook.createSheet();
        XSSFFont boldFont = workbook.createFont();
        boldFont.setFontHeight(10.0);
        boldFont.setBold(true);
        XSSFCellStyle distributorLabel = workbook.createCellStyle();
        distributorLabel.setAlignment(HorizontalAlignment.CENTER);
        distributorLabel.setBorderBottom(BorderStyle.THIN);
        distributorLabel.setBorderLeft(BorderStyle.THIN);
        distributorLabel.setBorderRight(BorderStyle.THIN);
        distributorLabel.setBorderTop(BorderStyle.THIN);
        distributorLabel.setFillPattern(FillPatternType.SOLID_FOREGROUND);
        distributorLabel.setFillForegroundColor(IndexedColors.LIGHT_GREEN.getIndex());
        distributorLabel.setFont((Font)boldFont);
        XSSFCellStyle scannedLabel = workbook.createCellStyle();
        scannedLabel.setAlignment(HorizontalAlignment.CENTER);
        scannedLabel.setBorderBottom(BorderStyle.THIN);
        scannedLabel.setBorderLeft(BorderStyle.THIN);
        scannedLabel.setBorderRight(BorderStyle.THIN);
        scannedLabel.setBorderTop(BorderStyle.THIN);
        scannedLabel.setFillPattern(FillPatternType.SOLID_FOREGROUND);
        scannedLabel.setFillForegroundColor(IndexedColors.LIGHT_YELLOW.getIndex());
        scannedLabel.setFont((Font)boldFont);
        XSSFCellStyle scannedText = workbook.createCellStyle();
        scannedText.setAlignment(HorizontalAlignment.CENTER);
        scannedText.setBorderBottom(BorderStyle.THIN);
        scannedText.setBorderLeft(BorderStyle.THIN);
        scannedText.setBorderRight(BorderStyle.THIN);
        scannedText.setBorderTop(BorderStyle.THIN);
        scannedText.setFillPattern(FillPatternType.SOLID_FOREGROUND);
        scannedText.setFillForegroundColor(IndexedColors.LIGHT_YELLOW.getIndex());
        XSSFCellStyle locationLabel = workbook.createCellStyle();
        locationLabel.setAlignment(HorizontalAlignment.CENTER);
        locationLabel.setBorderBottom(BorderStyle.THIN);
        locationLabel.setBorderLeft(BorderStyle.THIN);
        locationLabel.setBorderRight(BorderStyle.THIN);
        locationLabel.setBorderTop(BorderStyle.THIN);
        locationLabel.setFillPattern(FillPatternType.SOLID_FOREGROUND);
        locationLabel.setFillForegroundColor(IndexedColors.LIGHT_BLUE.getIndex());
        locationLabel.setFont((Font)boldFont);
        XSSFCellStyle locationText = workbook.createCellStyle();
        locationText.setAlignment(HorizontalAlignment.CENTER);
        locationText.setBorderBottom(BorderStyle.THIN);
        locationText.setBorderLeft(BorderStyle.THIN);
        locationText.setBorderRight(BorderStyle.THIN);
        locationText.setBorderTop(BorderStyle.THIN);
        locationText.setFillPattern(FillPatternType.SOLID_FOREGROUND);
        locationText.setFillForegroundColor(IndexedColors.LIGHT_BLUE.getIndex());
        XSSFCellStyle productLabel = workbook.createCellStyle();
        productLabel.setAlignment(HorizontalAlignment.CENTER);
        productLabel.setBorderBottom(BorderStyle.THIN);
        productLabel.setBorderLeft(BorderStyle.THIN);
        productLabel.setBorderRight(BorderStyle.THIN);
        productLabel.setBorderTop(BorderStyle.THIN);
        productLabel.setFillPattern(FillPatternType.SOLID_FOREGROUND);
        productLabel.setFillForegroundColor(IndexedColors.GREY_25_PERCENT.getIndex());
        productLabel.setFont((Font)boldFont);
        XSSFCellStyle normalStyle = workbook.createCellStyle();
        normalStyle.setAlignment(HorizontalAlignment.CENTER);
        normalStyle.setBorderBottom(BorderStyle.THIN);
        normalStyle.setBorderLeft(BorderStyle.THIN);
        normalStyle.setBorderRight(BorderStyle.THIN);
        normalStyle.setBorderTop(BorderStyle.THIN);
        AtomicInteger rowNum = new AtomicInteger();
        AtomicInteger colNum = new AtomicInteger();
        DateTimeFormatter dateTimeFormatter = DateTimeFormatter.ofPattern("dd MMM yyyy hh:mm:ss").withZone(ZoneId.of("Asia/Kolkata"));
        data.stream().collect(Collectors.groupingBy(DistributorWithAllProductsDTO::getId)).forEach((id, distributorWithAllProductsDTO) -> distributorWithAllProductsDTO.forEach(dto -> {
            String distributorName = dto.getName();
            String distributorCode = dto.getCode();
            XSSFRow row = sheet.createRow(rowNum.getAndIncrement());
            Cell cell = row.createCell(colNum.getAndIncrement());
            cell.setCellValue(distributorName + " (" + distributorCode + ")");
            cell.setCellStyle((CellStyle)distributorLabel);
            while (colNum.get() < 4) {
                cell = row.createCell(colNum.getAndIncrement());
                cell.setCellStyle((CellStyle)distributorLabel);
            }
            sheet.addMergedRegion(new CellRangeAddress(sheet.getLastRowNum(), sheet.getLastRowNum(), 0, 3));
            colNum.set(0);
            row = sheet.createRow(rowNum.getAndIncrement());
            cell = row.createCell(colNum.getAndIncrement());
            cell.setCellValue("Location");
            cell.setCellStyle((CellStyle)locationLabel);
            cell = row.createCell(colNum.getAndIncrement());
            cell.setCellValue(dto.getRfidScan().getLocationCity());
            cell.setCellStyle((CellStyle)locationText);
            while (colNum.get() < 4) {
                cell = row.createCell(colNum.getAndIncrement());
                cell.setCellStyle((CellStyle)locationText);
            }
            sheet.addMergedRegion(new CellRangeAddress(sheet.getLastRowNum(), sheet.getLastRowNum(), 1, 3));
            colNum.set(0);
            row = sheet.createRow(rowNum.getAndIncrement());
            cell = row.createCell(colNum.getAndIncrement());
            cell.setCellValue("Scanned On");
            cell.setCellStyle((CellStyle)scannedLabel);
            cell = row.createCell(colNum.getAndIncrement());
            cell.setCellValue(dateTimeFormatter.format(dto.getRfidScan().getCreatedDate()));
            cell.setCellStyle((CellStyle)scannedText);
            while (colNum.get() < 4) {
                cell = row.createCell(colNum.getAndIncrement());
                cell.setCellStyle((CellStyle)scannedLabel);
            }
            sheet.addMergedRegion(new CellRangeAddress(sheet.getLastRowNum(), sheet.getLastRowNum(), 1, 3));
            colNum.set(0);
            XSSFRow finalRow = row = sheet.createRow(rowNum.getAndIncrement());
            Arrays.asList("Product Name", "SKU Code", "Qty", "Count").forEach(arg_0 -> FileServiceImpl.lambda$null$1((Row)finalRow, colNum, productLabel, arg_0));
            colNum.set(0);
            Long[] total = new Long[]{0L};
            dto.getProducts().forEach(product -> {
                XSSFRow productRow = sheet.createRow(rowNum.getAndIncrement());
                Cell labelCell = productRow.createCell(colNum.getAndIncrement());
                labelCell.setCellValue(product.getProductCode());
                labelCell.setCellStyle((CellStyle)normalStyle);
                labelCell = productRow.createCell(colNum.getAndIncrement());
                labelCell.setCellValue(product.getSkuCode());
                labelCell.setCellStyle((CellStyle)normalStyle);
                labelCell = productRow.createCell(colNum.getAndIncrement());
                labelCell.setCellValue(product.getQuantity() + " MT");
                labelCell.setCellStyle((CellStyle)normalStyle);
                labelCell = productRow.createCell(colNum.getAndIncrement());
                labelCell.setCellValue((double)product.getCount().longValue());
                labelCell.setCellStyle((CellStyle)normalStyle);
                total[0] = total[0] + product.getCount();
                colNum.set(0);
            });
            colNum.set(0);
            row = sheet.createRow(rowNum.getAndIncrement());
            cell = row.createCell(colNum.getAndIncrement());
            cell.setCellValue("Total");
            cell.setCellStyle((CellStyle)normalStyle);
            while (colNum.get() < 3) {
                cell = row.createCell(colNum.getAndIncrement());
                cell.setCellStyle((CellStyle)normalStyle);
            }
            cell = row.createCell(colNum.get());
            cell.setCellValue((double)total[0].longValue());
            cell.setCellStyle((CellStyle)normalStyle);
            colNum.set(0);
        }));
        sheet.autoSizeColumn(0);
        sheet.autoSizeColumn(1);
        sheet.autoSizeColumn(2);
        sheet.autoSizeColumn(3);
        return workbook;
    }

    private static /* synthetic */ void lambda$null$1(Row finalRow, AtomicInteger colNum, XSSFCellStyle productLabel, String label) {
        Cell labelCell = finalRow.createCell(colNum.getAndIncrement());
        labelCell.setCellValue(label);
        labelCell.setCellStyle((CellStyle)productLabel);
    }
}

