/*
 * Decompiled with CFR 0.152.
 */
package com.distribution.liquidation.upl.service.impl;

import com.distribution.liquidation.upl.domain.AppUserLogin;
import com.distribution.liquidation.upl.repository.AppUserLoginRepository;
import com.distribution.liquidation.upl.service.AppUserLoginService;
import com.distribution.liquidation.upl.service.dto.AppUserLoginDTO;
import com.distribution.liquidation.upl.service.mapper.AppUserLoginMapper;
import java.util.Optional;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;
import org.springframework.data.domain.Page;
import org.springframework.data.domain.Pageable;
import org.springframework.stereotype.Service;
import org.springframework.transaction.annotation.Transactional;

@Service
@Transactional
public class AppUserLoginServiceImpl
implements AppUserLoginService {
    private final Logger log = LoggerFactory.getLogger(AppUserLoginServiceImpl.class);
    private final AppUserLoginRepository appUserLoginRepository;
    private final AppUserLoginMapper appUserLoginMapper;

    public AppUserLoginServiceImpl(AppUserLoginRepository appUserLoginRepository, AppUserLoginMapper appUserLoginMapper) {
        this.appUserLoginRepository = appUserLoginRepository;
        this.appUserLoginMapper = appUserLoginMapper;
    }

    public AppUserLoginDTO save(AppUserLoginDTO appUserLoginDTO) {
        this.log.debug("Request to save AppUserLogin : {}", (Object)appUserLoginDTO);
        AppUserLogin appUserLogin = (AppUserLogin)this.appUserLoginMapper.toEntity((Object)appUserLoginDTO);
        appUserLogin = (AppUserLogin)this.appUserLoginRepository.save((Object)appUserLogin);
        return this.appUserLoginMapper.toDto(appUserLogin);
    }

    public Optional<AppUserLoginDTO> partialUpdate(AppUserLoginDTO appUserLoginDTO) {
        this.log.debug("Request to partially update AppUserLogin : {}", (Object)appUserLoginDTO);
        return this.appUserLoginRepository.findById((Object)appUserLoginDTO.getId()).map(existingAppUserLogin -> {
            this.appUserLoginMapper.partialUpdate(existingAppUserLogin, (Object)appUserLoginDTO);
            return existingAppUserLogin;
        }).map(arg_0 -> ((AppUserLoginRepository)this.appUserLoginRepository).save(arg_0)).map(arg_0 -> ((AppUserLoginMapper)this.appUserLoginMapper).toDto(arg_0));
    }

    @Transactional(readOnly=true)
    public Page<AppUserLoginDTO> findAll(Pageable pageable) {
        this.log.debug("Request to get all AppUserLogins");
        return this.appUserLoginRepository.findAll(pageable).map(arg_0 -> ((AppUserLoginMapper)this.appUserLoginMapper).toDto(arg_0));
    }

    @Transactional(readOnly=true)
    public Optional<AppUserLoginDTO> findOne(Long id) {
        this.log.debug("Request to get AppUserLogin : {}", (Object)id);
        return this.appUserLoginRepository.findById((Object)id).map(arg_0 -> ((AppUserLoginMapper)this.appUserLoginMapper).toDto(arg_0));
    }

    public void delete(Long id) {
        this.log.debug("Request to delete AppUserLogin : {}", (Object)id);
        this.appUserLoginRepository.deleteById((Object)id);
    }

    public Optional<AppUserLoginDTO> findByToken(String authToken) {
        this.log.debug("Request to find AppUserLogin : {}", (Object)authToken);
        return this.appUserLoginRepository.findByToken(authToken).map(arg_0 -> ((AppUserLoginMapper)this.appUserLoginMapper).toDto(arg_0));
    }
}

