/*
 * Decompiled with CFR 0.152.
 */
package com.distribution.liquidation.upl.service.impl;

import com.distribution.liquidation.upl.domain.RfidScan;
import com.distribution.liquidation.upl.repository.RfidScanRepository;
import com.distribution.liquidation.upl.security.SecurityUtils;
import com.distribution.liquidation.upl.service.RfidScanService;
import com.distribution.liquidation.upl.service.dto.AppUserDTO;
import com.distribution.liquidation.upl.service.dto.RfidScanDTO;
import com.distribution.liquidation.upl.service.mapper.RfidScanMapper;
import java.util.LinkedList;
import java.util.List;
import java.util.Optional;
import java.util.stream.Collectors;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;
import org.springframework.stereotype.Service;
import org.springframework.transaction.annotation.Transactional;

@Service
@Transactional
public class RfidScanServiceImpl
implements RfidScanService {
    private final Logger log = LoggerFactory.getLogger(RfidScanServiceImpl.class);
    private final RfidScanRepository rfidScanRepository;
    private final RfidScanMapper rfidScanMapper;

    public RfidScanServiceImpl(RfidScanRepository rfidScanRepository, RfidScanMapper rfidScanMapper) {
        this.rfidScanRepository = rfidScanRepository;
        this.rfidScanMapper = rfidScanMapper;
    }

    public RfidScanDTO save(RfidScanDTO rfidScanDTO) {
        this.log.debug("Request to save RfidScan : {}", (Object)rfidScanDTO);
        Long appUserId = Long.valueOf((String)SecurityUtils.getCurrentUserLogin().get());
        AppUserDTO appUserDTO = new AppUserDTO();
        appUserDTO.setId(appUserId);
        rfidScanDTO.setAppUser(appUserDTO);
        RfidScan rfidScan = (RfidScan)this.rfidScanMapper.toEntity((Object)rfidScanDTO);
        rfidScan = (RfidScan)this.rfidScanRepository.save((Object)rfidScan);
        return this.rfidScanMapper.toDto(rfidScan);
    }

    public Optional<RfidScanDTO> partialUpdate(RfidScanDTO rfidScanDTO) {
        this.log.debug("Request to partially update RfidScan : {}", (Object)rfidScanDTO);
        return this.rfidScanRepository.findById((Object)rfidScanDTO.getId()).map(existingRfidScan -> {
            this.rfidScanMapper.partialUpdate(existingRfidScan, (Object)rfidScanDTO);
            return existingRfidScan;
        }).map(arg_0 -> ((RfidScanRepository)this.rfidScanRepository).save(arg_0)).map(arg_0 -> ((RfidScanMapper)this.rfidScanMapper).toDto(arg_0));
    }

    @Transactional(readOnly=true)
    public List<RfidScanDTO> findAll() {
        this.log.debug("Request to get all RfidScans");
        return this.rfidScanRepository.findAll().stream().map(arg_0 -> ((RfidScanMapper)this.rfidScanMapper).toDto(arg_0)).collect(Collectors.toCollection(LinkedList::new));
    }

    @Transactional(readOnly=true)
    public Optional<RfidScanDTO> findOne(Long id) {
        this.log.debug("Request to get RfidScan : {}", (Object)id);
        return this.rfidScanRepository.findById((Object)id).map(arg_0 -> ((RfidScanMapper)this.rfidScanMapper).toDto(arg_0));
    }

    public void delete(Long id) {
        this.log.debug("Request to delete RfidScan : {}", (Object)id);
        this.rfidScanRepository.deleteById((Object)id);
    }
}

