/*
 * Decompiled with CFR 0.152.
 */
package com.distribution.liquidation.upl.web.rest;

import com.distribution.liquidation.upl.repository.ProductQuantityRepository;
import com.distribution.liquidation.upl.service.ProductQuantityService;
import com.distribution.liquidation.upl.service.dto.ProductQuantityDTO;
import com.distribution.liquidation.upl.web.rest.errors.BadRequestAlertException;
import java.net.URI;
import java.net.URISyntaxException;
import java.util.List;
import java.util.Objects;
import java.util.Optional;
import javax.validation.Valid;
import javax.validation.constraints.NotNull;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;
import org.springframework.beans.factory.annotation.Value;
import org.springframework.http.HttpHeaders;
import org.springframework.http.ResponseEntity;
import org.springframework.web.bind.annotation.DeleteMapping;
import org.springframework.web.bind.annotation.GetMapping;
import org.springframework.web.bind.annotation.PatchMapping;
import org.springframework.web.bind.annotation.PathVariable;
import org.springframework.web.bind.annotation.PostMapping;
import org.springframework.web.bind.annotation.PutMapping;
import org.springframework.web.bind.annotation.RequestBody;
import org.springframework.web.bind.annotation.RequestMapping;
import org.springframework.web.bind.annotation.RestController;
import tech.jhipster.web.util.HeaderUtil;
import tech.jhipster.web.util.ResponseUtil;

@RestController
@RequestMapping(value={"/api"})
public class ProductQuantityResource {
    private final Logger log = LoggerFactory.getLogger(ProductQuantityResource.class);
    private static final String ENTITY_NAME = "productQuantity";
    @Value(value="${jhipster.clientApp.name}")
    private String applicationName;
    private final ProductQuantityService productQuantityService;
    private final ProductQuantityRepository productQuantityRepository;

    public ProductQuantityResource(ProductQuantityService productQuantityService, ProductQuantityRepository productQuantityRepository) {
        this.productQuantityService = productQuantityService;
        this.productQuantityRepository = productQuantityRepository;
    }

    @PostMapping(value={"/product-quantities"})
    public ResponseEntity<ProductQuantityDTO> createProductQuantity(@Valid @RequestBody ProductQuantityDTO productQuantityDTO) throws URISyntaxException {
        this.log.debug("REST request to save ProductQuantity : {}", (Object)productQuantityDTO);
        if (productQuantityDTO.getId() != null) {
            throw new BadRequestAlertException("A new productQuantity cannot already have an ID", ENTITY_NAME, "idexists");
        }
        ProductQuantityDTO result = this.productQuantityService.save(productQuantityDTO);
        return ((ResponseEntity.BodyBuilder)ResponseEntity.created((URI)new URI("/api/product-quantities/" + result.getId())).headers(HeaderUtil.createEntityCreationAlert((String)this.applicationName, (boolean)false, (String)ENTITY_NAME, (String)result.getId().toString()))).body((Object)result);
    }

    @PutMapping(value={"/product-quantities/{id}"})
    public ResponseEntity<ProductQuantityDTO> updateProductQuantity(@PathVariable(value="id", required=false) Long id, @Valid @RequestBody ProductQuantityDTO productQuantityDTO) throws URISyntaxException {
        this.log.debug("REST request to update ProductQuantity : {}, {}", (Object)id, (Object)productQuantityDTO);
        if (productQuantityDTO.getId() == null) {
            throw new BadRequestAlertException("Invalid id", ENTITY_NAME, "idnull");
        }
        if (!Objects.equals(id, productQuantityDTO.getId())) {
            throw new BadRequestAlertException("Invalid ID", ENTITY_NAME, "idinvalid");
        }
        if (!this.productQuantityRepository.existsById((Object)id)) {
            throw new BadRequestAlertException("Entity not found", ENTITY_NAME, "idnotfound");
        }
        ProductQuantityDTO result = this.productQuantityService.save(productQuantityDTO);
        return ((ResponseEntity.BodyBuilder)ResponseEntity.ok().headers(HeaderUtil.createEntityUpdateAlert((String)this.applicationName, (boolean)false, (String)ENTITY_NAME, (String)productQuantityDTO.getId().toString()))).body((Object)result);
    }

    @PatchMapping(value={"/product-quantities/{id}"}, consumes={"application/json", "application/merge-patch+json"})
    public ResponseEntity<ProductQuantityDTO> partialUpdateProductQuantity(@PathVariable(value="id", required=false) Long id, @NotNull @RequestBody ProductQuantityDTO productQuantityDTO) throws URISyntaxException {
        this.log.debug("REST request to partial update ProductQuantity partially : {}, {}", (Object)id, (Object)productQuantityDTO);
        if (productQuantityDTO.getId() == null) {
            throw new BadRequestAlertException("Invalid id", ENTITY_NAME, "idnull");
        }
        if (!Objects.equals(id, productQuantityDTO.getId())) {
            throw new BadRequestAlertException("Invalid ID", ENTITY_NAME, "idinvalid");
        }
        if (!this.productQuantityRepository.existsById((Object)id)) {
            throw new BadRequestAlertException("Entity not found", ENTITY_NAME, "idnotfound");
        }
        Optional result = this.productQuantityService.partialUpdate(productQuantityDTO);
        return ResponseUtil.wrapOrNotFound((Optional)result, (HttpHeaders)HeaderUtil.createEntityUpdateAlert((String)this.applicationName, (boolean)false, (String)ENTITY_NAME, (String)productQuantityDTO.getId().toString()));
    }

    @GetMapping(value={"/product-quantities"})
    public List<ProductQuantityDTO> getAllProductQuantities() {
        this.log.debug("REST request to get all ProductQuantities");
        return this.productQuantityService.findAll();
    }

    @GetMapping(value={"/product-quantities/{id}"})
    public ResponseEntity<ProductQuantityDTO> getProductQuantity(@PathVariable Long id) {
        this.log.debug("REST request to get ProductQuantity : {}", (Object)id);
        Optional productQuantityDTO = this.productQuantityService.findOne(id);
        return ResponseUtil.wrapOrNotFound((Optional)productQuantityDTO);
    }

    @DeleteMapping(value={"/product-quantities/{id}"})
    public ResponseEntity<Void> deleteProductQuantity(@PathVariable Long id) {
        this.log.debug("REST request to delete ProductQuantity : {}", (Object)id);
        this.productQuantityService.delete(id);
        return ResponseEntity.noContent().headers(HeaderUtil.createEntityDeletionAlert((String)this.applicationName, (boolean)false, (String)ENTITY_NAME, (String)id.toString())).build();
    }
}

