/*
 * Decompiled with CFR 0.152.
 */
package com.distribution.liquidation.upl.service.impl;

import com.distribution.liquidation.upl.config.ApplicationProperties;
import com.distribution.liquidation.upl.domain.Distributor;
import com.distribution.liquidation.upl.domain.Product;
import com.distribution.liquidation.upl.repository.ProductRepository;
import com.distribution.liquidation.upl.service.dto.DistributorDTO;
import com.distribution.liquidation.upl.service.impl.AsyncJob;
import com.distribution.liquidation.upl.service.mapper.DistributorMapper;
import com.fasterxml.jackson.core.JsonProcessingException;
import com.fasterxml.jackson.databind.ObjectMapper;
import java.time.Instant;
import java.util.Objects;
import java.util.Optional;
import javax.transaction.Transactional;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;
import org.springframework.http.ResponseEntity;
import org.springframework.scheduling.annotation.Async;
import org.springframework.stereotype.Service;
import org.springframework.web.client.RestTemplate;

@Service
public class AsyncJob {
    private final Logger log = LoggerFactory.getLogger(AsyncJob.class);
    private final DistributorMapper distributorMapper;
    private final RestTemplate restTemplate;
    private final ApplicationProperties.QodeNext qodeNext;
    private final ObjectMapper objectMapper;
    private final ProductRepository productRepository;

    public AsyncJob(DistributorMapper distributorMapper, RestTemplate restTemplate, ObjectMapper objectMapper, ApplicationProperties applicationProperties, ProductRepository productRepository) {
        this.distributorMapper = distributorMapper;
        this.restTemplate = restTemplate;
        this.objectMapper = objectMapper;
        this.qodeNext = applicationProperties.getQodeNext();
        this.productRepository = productRepository;
    }

    @Async
    @Transactional
    public void fetchRfidDataAsync(String rfid, Long distributorId) throws JsonProcessingException {
        String url = String.format("%s?UID=%s", this.qodeNext.getRfidEndpoint(), rfid);
        ResponseEntity responseEntity = this.restTemplate.getForEntity(url, QodeNextResponse.class, new Object[0]);
        this.log.info("Making QodeNext API call: {}, Response: {}", (Object)url, (Object)this.objectMapper.writeValueAsString(responseEntity.getBody()));
        Product product = this.mapQodeNextResponseToProduct((QodeNextResponse)Objects.requireNonNull(responseEntity.getBody()), distributorId);
        Optional alreadySavedProduct = this.productRepository.findByBarcode(product.getBarcode());
        if (alreadySavedProduct.isPresent()) {
            product.setId(((Product)alreadySavedProduct.get()).getId());
            product.setCreatedDate(Instant.now());
        }
        this.productRepository.save((Object)product);
    }

    private Product mapQodeNextResponseToProduct(QodeNextResponse body, Long distributorId) throws JsonProcessingException {
        RfidDetails responseMap = (RfidDetails)body.NewDataSet.Table0.get(0);
        Product product = new Product();
        product.setResponse(this.objectMapper.writeValueAsString((Object)responseMap));
        product.setBarcode(responseMap.BARCODE);
        product.setBatch(responseMap.BATCH);
        product.setPrintDate(responseMap.PRINTDATE);
        product.setDispatchDate(responseMap.DISPATCHDATE);
        product.setPackingProcessOrder(responseMap.PackingProcessorder);
        product.setPlantCode(responseMap.Plant_Code);
        product.setSkuCode(responseMap.SKU_Code);
        product.setProductCode(responseMap.Product_Code);
        product.setProductDescription(responseMap.Product_Description);
        product.setMrpUnit(responseMap.MRP_Unit);
        product.setBatchNo(responseMap.Batch_No);
        product.setExpDate(responseMap.EXP_Date);
        product.setProductHeader(responseMap.Product_Header);
        product.setBarcodeCount(responseMap.BarcodeCount);
        product.setBarcodeStatus(responseMap.BARCODE_STATUS);
        product.setTableName(responseMap.TableName);
        product.setPackType(responseMap.PackType);
        product.setQuantity(Integer.valueOf(1));
        DistributorDTO distributorDTO = new DistributorDTO();
        distributorDTO.setId(distributorId);
        product.setDistributor((Distributor)this.distributorMapper.toEntity((Object)distributorDTO));
        return product;
    }
}

