/*
 * Decompiled with CFR 0.152.
 */
package com.distribution.liquidation.upl.service;

import com.distribution.liquidation.upl.domain.Distributor;
import com.distribution.liquidation.upl.domain.Distributor_;
import com.distribution.liquidation.upl.domain.Product;
import com.distribution.liquidation.upl.domain.Product_;
import com.distribution.liquidation.upl.repository.AppUserRepository;
import com.distribution.liquidation.upl.repository.DistributorRepository;
import com.distribution.liquidation.upl.repository.ProductRepository;
import com.distribution.liquidation.upl.security.SecurityUtils;
import com.distribution.liquidation.upl.service.ProductQueryService;
import com.distribution.liquidation.upl.service.criteria.ProductCriteria;
import com.distribution.liquidation.upl.service.dto.DistributorWithAllProductsDTO;
import com.distribution.liquidation.upl.service.dto.DistributorWithProductsDTO;
import com.distribution.liquidation.upl.service.dto.ProductDTO;
import com.distribution.liquidation.upl.service.mapper.DistributorMapper;
import com.distribution.liquidation.upl.service.mapper.ProductMapper;
import java.time.Instant;
import java.time.temporal.ChronoUnit;
import java.util.ArrayList;
import java.util.Collections;
import java.util.Comparator;
import java.util.List;
import java.util.Map;
import java.util.stream.Collectors;
import javax.persistence.EntityManager;
import javax.persistence.NoResultException;
import javax.persistence.TypedQuery;
import javax.persistence.criteria.CriteriaBuilder;
import javax.persistence.criteria.CriteriaQuery;
import javax.persistence.criteria.Expression;
import javax.persistence.criteria.JoinType;
import javax.persistence.criteria.Root;
import javax.persistence.criteria.Selection;
import org.jetbrains.annotations.NotNull;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;
import org.springframework.data.domain.Page;
import org.springframework.data.domain.PageImpl;
import org.springframework.data.domain.Pageable;
import org.springframework.data.jpa.domain.Specification;
import org.springframework.stereotype.Service;
import org.springframework.transaction.annotation.Transactional;
import tech.jhipster.service.QueryService;
import tech.jhipster.service.filter.InstantFilter;
import tech.jhipster.service.filter.LongFilter;
import tech.jhipster.service.filter.RangeFilter;
import tech.jhipster.service.filter.StringFilter;

@Service
@Transactional(readOnly=true)
public class ProductQueryService
extends QueryService<Product> {
    private final Logger log = LoggerFactory.getLogger(ProductQueryService.class);
    private final ProductRepository productRepository;
    private final ProductMapper productMapper;
    private final DistributorMapper distributorMapper;
    private final DistributorRepository distributorRepository;
    private final EntityManager entityManager;
    private final Comparator<Product> quantityComparator = (p1, p2) -> p2.getQuantity() - p1.getQuantity();

    public ProductQueryService(ProductRepository productRepository, AppUserRepository appUserRepository, DistributorRepository distributorRepository, AppUserRepository appUserRepository1, ProductMapper productMapper, DistributorMapper distributorMapper, EntityManager entityManager) {
        this.productRepository = productRepository;
        this.productMapper = productMapper;
        this.distributorRepository = distributorRepository;
        this.distributorMapper = distributorMapper;
        this.entityManager = entityManager;
    }

    @Transactional(readOnly=true)
    public List<ProductDTO> findByCriteria(ProductCriteria criteria) {
        this.log.debug("find by criteria : {}", (Object)criteria);
        Specification specification = this.createSpecification(criteria);
        return this.productMapper.toDto(this.productRepository.findAll(specification));
    }

    @Transactional(readOnly=true)
    public Page<ProductDTO> findByCriteria(ProductCriteria criteria, Pageable page) {
        this.log.debug("find by criteria : {}, page: {}", (Object)criteria, (Object)page);
        Specification specification = this.createSpecification(criteria);
        return this.productRepository.findAll(specification, page).map(arg_0 -> ((ProductMapper)this.productMapper).toDto(arg_0));
    }

    @Transactional(readOnly=true)
    public long countByCriteria(ProductCriteria criteria) {
        this.log.debug("count by criteria : {}", (Object)criteria);
        Specification specification = this.createSpecification(criteria);
        return this.productRepository.count(specification);
    }

    @Transactional(readOnly=true)
    public long countDailyUniqueProducts(Long appUserId) {
        this.log.debug("count daily unique products for userId: {}", (Object)appUserId);
        ProductCriteria criteria = this.getProductCriteria(appUserId, null, null);
        Specification specification = this.createSpecification(criteria);
        return this.productRepository.count(specification);
    }

    @Transactional(readOnly=true)
    public List<DistributorWithProductsDTO> getProductsForDistributor(Long appUserId, Pageable page) {
        this.log.debug("count daily unique products for userId: {}", (Object)appUserId);
        ProductCriteria criteria = this.getProductCriteria(appUserId, null, null);
        List distributorIds = this.getDailyDistributorIds(page, criteria);
        LongFilter distributorIdFilter = new LongFilter();
        distributorIdFilter.setIn(distributorIds);
        criteria.setDistributorId(distributorIdFilter);
        Specification specification = this.createSpecification(criteria);
        List products = this.productRepository.findAll(specification);
        Map<Long, List<Product>> data = products.stream().collect(Collectors.groupingBy(product -> product.getDistributor().getId()));
        return data.entrySet().stream().map(entry -> {
            Map<String, List<Product>> groupedProducts = ((List)entry.getValue()).stream().collect(Collectors.groupingBy(Product::getSkuCode));
            ArrayList distributorProducts = new ArrayList();
            groupedProducts.forEach((skuCode, _products) -> {
                Product product = (Product)_products.get(0);
                product.setQuantity(Integer.valueOf(_products.size()));
                distributorProducts.add(product);
            });
            distributorProducts.sort(this.quantityComparator);
            List topProducts = distributorProducts.subList(0, Math.min(distributorProducts.size(), 3));
            List bottomProducts = distributorProducts.subList(Math.max(0, distributorProducts.size() - 3), distributorProducts.size());
            return this.distributorMapper.toDtoWithProducts(((Product)((List)entry.getValue()).get(0)).getDistributor(), topProducts, bottomProducts);
        }).collect(Collectors.toList());
    }

    @Transactional(readOnly=true)
    public List<DistributorWithAllProductsDTO> getProductsInDateRangeForDistributor(Long appUserId, Pageable page, List<Long> passedDistributorIds, Instant fromDate, Instant toDate) {
        this.log.debug("get scanned products for userId: {}", (Object)appUserId);
        ProductCriteria criteria = this.getProductCriteria(appUserId, fromDate, toDate);
        List distributorIds = this.getDailyDistributorIds(page, criteria);
        this.log.debug("passedDistributorIds: {}, distributorIds: {}", passedDistributorIds, (Object)distributorIds);
        LongFilter distributorIdFilter = new LongFilter();
        if (!passedDistributorIds.isEmpty()) {
            List validDistributorIds = this.getDailyDistributorIds(null, criteria);
            passedDistributorIds.removeIf(distributorId -> !validDistributorIds.contains(distributorId));
            passedDistributorIds = new PageImpl(passedDistributorIds, page, (long)passedDistributorIds.size()).getContent();
            distributorIdFilter.setIn(passedDistributorIds);
            criteria.setDistributorId(distributorIdFilter);
        } else {
            distributorIdFilter.setIn(distributorIds);
            criteria.setDistributorId(distributorIdFilter);
        }
        Specification specification = this.createSpecification(criteria);
        List products = this.productRepository.findAll(specification);
        Map<Long, List<Product>> data = products.stream().collect(Collectors.groupingBy(product -> product.getDistributor().getId()));
        return data.entrySet().stream().map(entry -> {
            Map<String, List<Product>> groupedProducts = ((List)entry.getValue()).stream().collect(Collectors.groupingBy(Product::getSkuCode));
            ArrayList distributorProducts = new ArrayList();
            groupedProducts.forEach((skuCode, _products) -> {
                Product product = (Product)_products.get(0);
                product.setQuantity(Integer.valueOf(_products.size()));
                distributorProducts.add(product);
            });
            distributorProducts.sort(this.quantityComparator);
            return this.distributorMapper.toDtoWithAllProducts(((Product)((List)entry.getValue()).get(0)).getDistributor(), distributorProducts);
        }).collect(Collectors.toList());
    }

    @NotNull
    private List<Long> getDailyDistributorIds(Pageable page, ProductCriteria criteria) {
        CriteriaBuilder criteriaBuilder = this.entityManager.getCriteriaBuilder();
        CriteriaQuery criteriaQuery = criteriaBuilder.createQuery(DistributorProduct.class);
        Root root = criteriaQuery.from(Product.class);
        TypedQuery q = this.entityManager.createQuery(criteriaQuery.multiselect(new Selection[]{root.get(Product_.distributor).get(Distributor_.id), criteriaBuilder.function("max", Instant.class, new Expression[]{root.get(Product_.createdDate)})}).where((Expression)this.createSpecification(criteria).toPredicate(root, criteriaQuery, criteriaBuilder)).groupBy(new Expression[]{root.get(Product_.distributor).get(Distributor_.id)}).orderBy(Collections.singletonList(criteriaBuilder.desc(criteriaBuilder.function("max", Instant.class, new Expression[]{root.get(Product_.createdDate)})))));
        if (page != null) {
            q.setFirstResult((int)page.getOffset()).setMaxResults(page.getPageSize());
        }
        return q.getResultStream().map(distributorProduct -> distributorProduct.id).collect(Collectors.toList());
    }

    private Instant getLastScannedDate(ProductCriteria criteria) {
        Instant lastScannedDate;
        CriteriaBuilder criteriaBuilder = this.entityManager.getCriteriaBuilder();
        CriteriaQuery criteriaQuery = criteriaBuilder.createQuery(Instant.class);
        Root root = criteriaQuery.from(Product.class);
        criteriaQuery = criteriaQuery.select((Selection)root.get(Product_.createdDate));
        if (SecurityUtils.hasCurrentUserThisAuthority((String)"TERRITORY_MANAGER")) {
            criteriaQuery.where((Expression)this.createSpecification(criteria).toPredicate(root, criteriaQuery, criteriaBuilder));
        }
        criteriaQuery.orderBy(Collections.singletonList(criteriaBuilder.desc((Expression)root.get(Product_.createdDate))));
        TypedQuery q = this.entityManager.createQuery(criteriaQuery).setMaxResults(1);
        try {
            lastScannedDate = (Instant)q.getSingleResult();
        }
        catch (NoResultException ex) {
            lastScannedDate = Instant.now();
        }
        return lastScannedDate;
    }

    private ProductCriteria getProductCriteria(Long appUserId, Instant fromDate, Instant toDate) {
        ProductCriteria criteria = new ProductCriteria();
        if (SecurityUtils.hasCurrentUserThisAuthority((String)"TERRITORY_MANAGER")) {
            List distributorIds = this.distributorRepository.findAllByAppUserIdAndStatusIsTrue(appUserId).stream().filter(Distributor::isStatus).map(Distributor::getId).collect(Collectors.toList());
            LongFilter distributorIdFilter = new LongFilter();
            distributorIdFilter.setIn(distributorIds);
            criteria.setDistributorId(distributorIdFilter);
        }
        InstantFilter dateFilter = new InstantFilter();
        if (fromDate == null && toDate == null) {
            dateFilter.setGreaterThan(this.getLastScannedDate(criteria).truncatedTo(ChronoUnit.DAYS));
        } else {
            if (fromDate != null) {
                dateFilter.setGreaterThanOrEqual(fromDate.truncatedTo(ChronoUnit.DAYS));
            }
            if (toDate != null) {
                dateFilter.setLessThanOrEqual(toDate.truncatedTo(ChronoUnit.DAYS));
            }
        }
        criteria.setCreationDate(dateFilter);
        StringFilter skuFilter = new StringFilter();
        skuFilter.setNotEquals((Object)"");
        criteria.setSkuCode(skuFilter);
        StringFilter barcodeStatus = new StringFilter();
        barcodeStatus.setEquals((Object)"G");
        criteria.setBarcodeStatus(barcodeStatus);
        return criteria;
    }

    protected Specification<Product> createSpecification(ProductCriteria criteria) {
        Specification specification = Specification.where(null);
        if (criteria != null) {
            if (criteria.getDistinct() != null) {
                specification = specification.and(this.distinct(criteria.getDistinct().booleanValue()));
            }
            if (criteria.getId() != null) {
                specification = specification.and(this.buildRangeSpecification((RangeFilter)criteria.getId(), Product_.id));
            }
            if (criteria.getBatch() != null) {
                specification = specification.and(this.buildStringSpecification(criteria.getBarcodeCount(), Product_.batch));
            }
            if (criteria.getPrintDate() != null) {
                specification = specification.and(this.buildStringSpecification(criteria.getPrintDate(), Product_.printDate));
            }
            if (criteria.getDispatchDate() != null) {
                specification = specification.and(this.buildStringSpecification(criteria.getDispatchDate(), Product_.dispatchDate));
            }
            if (criteria.getPackingProcessOrder() != null) {
                specification = specification.and(this.buildStringSpecification(criteria.getPackingProcessOrder(), Product_.packingProcessOrder));
            }
            if (criteria.getPlantCode() != null) {
                specification = specification.and(this.buildStringSpecification(criteria.getPlantCode(), Product_.plantCode));
            }
            if (criteria.getSkuCode() != null) {
                specification = specification.and(this.buildStringSpecification(criteria.getSkuCode(), Product_.skuCode));
            }
            if (criteria.getProductCode() != null) {
                specification = specification.and(this.buildStringSpecification(criteria.getProductCode(), Product_.productCode));
            }
            if (criteria.getProductDescription() != null) {
                specification = specification.and(this.buildStringSpecification(criteria.getProductDescription(), Product_.productDescription));
            }
            if (criteria.getMrpUnit() != null) {
                specification = specification.and(this.buildStringSpecification(criteria.getMrpUnit(), Product_.mrpUnit));
            }
            if (criteria.getBatchNo() != null) {
                specification = specification.and(this.buildStringSpecification(criteria.getBatchNo(), Product_.batchNo));
            }
            if (criteria.getExpDate() != null) {
                specification = specification.and(this.buildStringSpecification(criteria.getExpDate(), Product_.expDate));
            }
            if (criteria.getProductHeader() != null) {
                specification = specification.and(this.buildStringSpecification(criteria.getProductHeader(), Product_.productHeader));
            }
            if (criteria.getBarcodeCount() != null) {
                specification = specification.and(this.buildStringSpecification(criteria.getBarcodeCount(), Product_.barcodeCount));
            }
            if (criteria.getBarcodeStatus() != null) {
                specification = specification.and(this.buildStringSpecification(criteria.getBarcodeStatus(), Product_.barcodeStatus));
            }
            if (criteria.getTableName() != null) {
                specification = specification.and(this.buildStringSpecification(criteria.getTableName(), Product_.tableName));
            }
            if (criteria.getResponse() != null) {
                specification = specification.and(this.buildStringSpecification(criteria.getResponse(), Product_.response));
            }
            if (criteria.getPackType() != null) {
                specification = specification.and(this.buildStringSpecification(criteria.getPackType(), Product_.packType));
            }
            if (criteria.getQuantity() != null) {
                specification = specification.and(this.buildRangeSpecification((RangeFilter)criteria.getQuantity(), Product_.quantity));
            }
            if (criteria.getCreationDate() != null) {
                specification = specification.and(this.buildRangeSpecification((RangeFilter)criteria.getCreationDate(), Product_.createdDate));
            }
            if (criteria.getDistributorId() != null) {
                specification = specification.and(this.buildSpecification((RangeFilter)criteria.getDistributorId(), root -> root.join(Product_.distributor, JoinType.LEFT).get(Distributor_.id)));
            }
        }
        return specification;
    }

    public Long countDistributorWithProduct(Long appUserId, List<Long> passedDistributorIds, Instant fromDate, Instant toDate) {
        ProductCriteria criteria = this.getProductCriteria(appUserId, fromDate, toDate);
        List distributorIds = this.getDailyDistributorIds(null, criteria);
        if (!passedDistributorIds.isEmpty()) {
            List validDistributorIds = this.getDailyDistributorIds(null, criteria);
            passedDistributorIds.removeIf(distributorId -> !validDistributorIds.contains(distributorId));
            return passedDistributorIds.size();
        }
        return distributorIds.size();
    }
}

