/*
 * Decompiled with CFR 0.152.
 */
package com.distribution.liquidation.upl.web.rest;

import com.distribution.liquidation.upl.repository.AppUserRepository;
import com.distribution.liquidation.upl.security.SecurityUtils;
import com.distribution.liquidation.upl.service.AppUserQueryService;
import com.distribution.liquidation.upl.service.AppUserService;
import com.distribution.liquidation.upl.service.criteria.AppUserCriteria;
import com.distribution.liquidation.upl.service.dto.AppUserDTO;
import com.distribution.liquidation.upl.web.rest.errors.BadRequestAlertException;
import java.net.URI;
import java.net.URISyntaxException;
import java.util.Objects;
import java.util.Optional;
import javax.validation.Valid;
import javax.validation.constraints.NotNull;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;
import org.springdoc.api.annotations.ParameterObject;
import org.springframework.beans.factory.annotation.Value;
import org.springframework.data.domain.Page;
import org.springframework.data.domain.Pageable;
import org.springframework.http.HttpHeaders;
import org.springframework.http.ResponseEntity;
import org.springframework.web.bind.annotation.DeleteMapping;
import org.springframework.web.bind.annotation.GetMapping;
import org.springframework.web.bind.annotation.PatchMapping;
import org.springframework.web.bind.annotation.PathVariable;
import org.springframework.web.bind.annotation.PostMapping;
import org.springframework.web.bind.annotation.PutMapping;
import org.springframework.web.bind.annotation.RequestBody;
import org.springframework.web.bind.annotation.RequestMapping;
import org.springframework.web.bind.annotation.RestController;
import org.springframework.web.servlet.support.ServletUriComponentsBuilder;
import org.springframework.web.util.UriComponentsBuilder;
import tech.jhipster.web.util.HeaderUtil;
import tech.jhipster.web.util.PaginationUtil;
import tech.jhipster.web.util.ResponseUtil;

@RestController
@RequestMapping(value={"/api"})
public class AppUserResource {
    private final Logger log = LoggerFactory.getLogger(AppUserResource.class);
    private static final String ENTITY_NAME = "appUser";
    @Value(value="${jhipster.clientApp.name}")
    private String applicationName;
    private final AppUserService appUserService;
    private final AppUserRepository appUserRepository;
    private final AppUserQueryService appUserQueryService;

    public AppUserResource(AppUserService appUserService, AppUserRepository appUserRepository, AppUserQueryService appUserQueryService) {
        this.appUserService = appUserService;
        this.appUserRepository = appUserRepository;
        this.appUserQueryService = appUserQueryService;
    }

    @PostMapping(value={"/app-users"})
    public ResponseEntity<AppUserDTO> createAppUser(@Valid @RequestBody AppUserDTO appUserDTO) throws URISyntaxException {
        this.log.debug("REST request to save AppUser : {}", (Object)appUserDTO);
        if (appUserDTO.getId() != null) {
            throw new BadRequestAlertException("A new appUser cannot already have an ID", ENTITY_NAME, "idexists");
        }
        AppUserDTO result = this.appUserService.save(appUserDTO);
        return ((ResponseEntity.BodyBuilder)ResponseEntity.created((URI)new URI("/api/app-users/" + result.getId())).headers(HeaderUtil.createEntityCreationAlert((String)this.applicationName, (boolean)false, (String)ENTITY_NAME, (String)result.getId().toString()))).body((Object)result);
    }

    @PutMapping(value={"/app-users/{id}"})
    public ResponseEntity<AppUserDTO> updateAppUser(@PathVariable(value="id", required=false) Long id, @Valid @RequestBody AppUserDTO appUserDTO) throws URISyntaxException {
        this.log.debug("REST request to update AppUser : {}, {}", (Object)id, (Object)appUserDTO);
        if (appUserDTO.getId() == null) {
            throw new BadRequestAlertException("Invalid id", ENTITY_NAME, "idnull");
        }
        if (!Objects.equals(id, appUserDTO.getId())) {
            throw new BadRequestAlertException("Invalid ID", ENTITY_NAME, "idinvalid");
        }
        if (!this.appUserRepository.existsById((Object)id)) {
            throw new BadRequestAlertException("Entity not found", ENTITY_NAME, "idnotfound");
        }
        AppUserDTO result = this.appUserService.save(appUserDTO);
        return ((ResponseEntity.BodyBuilder)ResponseEntity.ok().headers(HeaderUtil.createEntityUpdateAlert((String)this.applicationName, (boolean)false, (String)ENTITY_NAME, (String)appUserDTO.getId().toString()))).body((Object)result);
    }

    @PatchMapping(value={"/app-users/{id}"}, consumes={"application/json", "application/merge-patch+json"})
    public ResponseEntity<AppUserDTO> partialUpdateAppUser(@PathVariable(value="id", required=false) Long id, @NotNull @RequestBody AppUserDTO appUserDTO) throws URISyntaxException {
        this.log.debug("REST request to partial update AppUser partially : {}, {}", (Object)id, (Object)appUserDTO);
        if (appUserDTO.getId() == null) {
            throw new BadRequestAlertException("Invalid id", ENTITY_NAME, "idnull");
        }
        if (!Objects.equals(id, appUserDTO.getId())) {
            throw new BadRequestAlertException("Invalid ID", ENTITY_NAME, "idinvalid");
        }
        if (!this.appUserRepository.existsById((Object)id)) {
            throw new BadRequestAlertException("Entity not found", ENTITY_NAME, "idnotfound");
        }
        Optional result = this.appUserService.partialUpdate(appUserDTO);
        return ResponseUtil.wrapOrNotFound((Optional)result, (HttpHeaders)HeaderUtil.createEntityUpdateAlert((String)this.applicationName, (boolean)false, (String)ENTITY_NAME, (String)appUserDTO.getId().toString()));
    }

    @GetMapping(value={"/app-users"})
    public ResponseEntity<AppUserDTO> getLoggedInAppUser() {
        this.log.debug("REST request to get LoggedIn AppUser");
        Long id = Long.valueOf((String)SecurityUtils.getCurrentUserLogin().get());
        Optional appUserDTO = this.appUserService.findOne(id);
        return ResponseUtil.wrapOrNotFound((Optional)appUserDTO);
    }

    @GetMapping(value={"/app-users/all"})
    public ResponseEntity<Page<AppUserDTO>> getAllAppUsers(AppUserCriteria criteria, @ParameterObject Pageable pageable) {
        this.log.debug("REST request to get AppUsers by criteria: {}", (Object)criteria);
        Page page = this.appUserQueryService.findByCriteria(criteria, pageable);
        HttpHeaders headers = PaginationUtil.generatePaginationHttpHeaders((UriComponentsBuilder)ServletUriComponentsBuilder.fromCurrentRequest(), (Page)page);
        return ((ResponseEntity.BodyBuilder)ResponseEntity.ok().headers(headers)).body((Object)page);
    }

    @GetMapping(value={"/app-users/count"})
    public ResponseEntity<Long> countAppUsers(AppUserCriteria criteria) {
        this.log.debug("REST request to count AppUsers by criteria: {}", (Object)criteria);
        return ResponseEntity.ok().body((Object)this.appUserQueryService.countByCriteria(criteria));
    }

    @GetMapping(value={"/app-users/{id}"})
    public ResponseEntity<AppUserDTO> getAppUser(@PathVariable Long id) {
        this.log.debug("REST request to get AppUser : {}", (Object)id);
        Optional appUserDTO = this.appUserService.findOne(id);
        return ResponseUtil.wrapOrNotFound((Optional)appUserDTO);
    }

    @DeleteMapping(value={"/app-users/{id}"})
    public ResponseEntity<Void> deleteAppUser(@PathVariable Long id) {
        this.log.debug("REST request to delete AppUser : {}", (Object)id);
        this.appUserService.delete(id);
        return ResponseEntity.noContent().headers(HeaderUtil.createEntityDeletionAlert((String)this.applicationName, (boolean)false, (String)ENTITY_NAME, (String)id.toString())).build();
    }
}

