/*
 * Decompiled with CFR 0.152.
 */
package com.distribution.liquidation.upl.service.impl;

import com.distribution.liquidation.upl.config.ApplicationProperties;
import com.distribution.liquidation.upl.domain.Distributor;
import com.distribution.liquidation.upl.domain.Product;
import com.distribution.liquidation.upl.repository.ProductRepository;
import com.distribution.liquidation.upl.service.ProductService;
import com.distribution.liquidation.upl.service.dto.DistributorDTO;
import com.distribution.liquidation.upl.service.dto.ProductDTO;
import com.distribution.liquidation.upl.service.dto.RfidDTO;
import com.distribution.liquidation.upl.service.impl.ProductServiceImpl;
import com.distribution.liquidation.upl.service.mapper.DistributorMapper;
import com.distribution.liquidation.upl.service.mapper.ProductMapper;
import com.fasterxml.jackson.core.JsonProcessingException;
import com.fasterxml.jackson.databind.ObjectMapper;
import java.time.Instant;
import java.util.Objects;
import java.util.Optional;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;
import org.springframework.data.domain.Page;
import org.springframework.data.domain.Pageable;
import org.springframework.http.ResponseEntity;
import org.springframework.stereotype.Service;
import org.springframework.transaction.annotation.Transactional;
import org.springframework.web.client.RestTemplate;

@Service
@Transactional
public class ProductServiceImpl
implements ProductService {
    private final Logger log = LoggerFactory.getLogger(ProductServiceImpl.class);
    private final ProductRepository productRepository;
    private final ProductMapper productMapper;
    private final DistributorMapper distributorMapper;
    private final RestTemplate restTemplate;
    private final ApplicationProperties.QodeNext qodeNext;
    private final ObjectMapper objectMapper;

    public ProductServiceImpl(ProductRepository productRepository, ProductMapper productMapper, DistributorMapper distributorMapper, RestTemplate restTemplate, ApplicationProperties applicationProperties, ObjectMapper objectMapper) {
        this.productRepository = productRepository;
        this.productMapper = productMapper;
        this.distributorMapper = distributorMapper;
        this.restTemplate = restTemplate;
        this.qodeNext = applicationProperties.getQodeNext();
        this.objectMapper = objectMapper;
    }

    public ProductDTO save(ProductDTO productDTO) {
        this.log.debug("Request to save Product : {}", (Object)productDTO);
        Product product = (Product)this.productMapper.toEntity((Object)productDTO);
        product = (Product)this.productRepository.save((Object)product);
        return this.productMapper.toDto(product);
    }

    public Optional<ProductDTO> partialUpdate(ProductDTO productDTO) {
        this.log.debug("Request to partially update Product : {}", (Object)productDTO);
        return this.productRepository.findById((Object)productDTO.getId()).map(existingProduct -> {
            this.productMapper.partialUpdate(existingProduct, (Object)productDTO);
            return existingProduct;
        }).map(arg_0 -> ((ProductRepository)this.productRepository).save(arg_0)).map(arg_0 -> ((ProductMapper)this.productMapper).toDto(arg_0));
    }

    @Transactional(readOnly=true)
    public Page<ProductDTO> findAll(Pageable pageable) {
        this.log.debug("Request to get all Products");
        return this.productRepository.findAll(pageable).map(arg_0 -> ((ProductMapper)this.productMapper).toDto(arg_0));
    }

    @Transactional(readOnly=true)
    public Optional<ProductDTO> findOne(Long id) {
        this.log.debug("Request to get Product : {}", (Object)id);
        return this.productRepository.findById((Object)id).map(arg_0 -> ((ProductMapper)this.productMapper).toDto(arg_0));
    }

    public void delete(Long id) {
        this.log.debug("Request to delete Product : {}", (Object)id);
        this.productRepository.deleteById((Object)id);
    }

    public ProductDTO fetchProductFromRFID(RfidDTO rfidDTO) throws JsonProcessingException {
        String url = String.format("%s?UID=%s", this.qodeNext.getRfidEndpoint(), rfidDTO.getRfid());
        ResponseEntity responseEntity = this.restTemplate.getForEntity(url, QodeNextResponse.class, new Object[0]);
        this.log.info("Making QodeNext API call: {}, Response: {}", (Object)url, (Object)this.objectMapper.writeValueAsString(responseEntity.getBody()));
        Product product = this.mapQodeNextResponseToProduct(Objects.requireNonNull((QodeNextResponse)responseEntity.getBody()), rfidDTO.getDistributorId());
        Optional alreadySavedProduct = this.productRepository.findByBarcode(rfidDTO.getRfid());
        if (alreadySavedProduct.isPresent()) {
            product.setId(((Product)alreadySavedProduct.get()).getId());
            product.setCreatedDate(Instant.now());
        }
        product = (Product)this.productRepository.save((Object)product);
        return this.productMapper.toDto(product);
    }

    private Product mapQodeNextResponseToProduct(QodeNextResponse body, Long distributorId) throws JsonProcessingException {
        RfidDetails responseMap = (RfidDetails)body.NewDataSet.Table0.get(0);
        Product product = new Product();
        product.setResponse(this.objectMapper.writeValueAsString((Object)responseMap));
        product.setBarcode(responseMap.BARCODE);
        product.setBatch(responseMap.BATCH);
        product.setPrintDate(responseMap.PRINTDATE);
        product.setDispatchDate(responseMap.DISPATCHDATE);
        product.setPackingProcessOrder(responseMap.PackingProcessorder);
        product.setPlantCode(responseMap.Plant_Code);
        product.setSkuCode(responseMap.SKU_Code);
        product.setProductCode(responseMap.Product_Code);
        product.setProductDescription(responseMap.Product_Description);
        product.setMrpUnit(responseMap.MRP_Unit);
        product.setBatchNo(responseMap.Batch_No);
        product.setExpDate(responseMap.EXP_Date);
        product.setProductHeader(responseMap.Product_Header);
        product.setBarcodeCount(responseMap.BarcodeCount);
        product.setBarcodeStatus(responseMap.BARCODE_STATUS);
        product.setTableName(responseMap.TableName);
        product.setPackType(responseMap.PackType);
        product.setQuantity(Integer.valueOf(1));
        DistributorDTO distributorDTO = new DistributorDTO();
        distributorDTO.setId(distributorId);
        product.setDistributor((Distributor)this.distributorMapper.toEntity((Object)distributorDTO));
        return product;
    }
}

