/*
 * Decompiled with CFR 0.152.
 */
package com.upl.digitalmodular.web.rest.errors;

import com.upl.digitalmodular.web.rest.errors.BadRequestAlertException;
import com.upl.digitalmodular.web.rest.errors.ErrorConstants;
import com.upl.digitalmodular.web.rest.errors.FieldErrorVM;
import java.net.URI;
import java.util.Arrays;
import java.util.List;
import java.util.Optional;
import java.util.stream.Collectors;
import javax.annotation.Nonnull;
import javax.annotation.Nullable;
import javax.servlet.http.HttpServletRequest;
import org.apache.commons.lang3.StringUtils;
import org.springframework.beans.factory.annotation.Value;
import org.springframework.core.env.Environment;
import org.springframework.dao.ConcurrencyFailureException;
import org.springframework.dao.DataAccessException;
import org.springframework.http.ResponseEntity;
import org.springframework.http.converter.HttpMessageConversionException;
import org.springframework.util.MultiValueMap;
import org.springframework.validation.BindingResult;
import org.springframework.web.bind.MethodArgumentNotValidException;
import org.springframework.web.bind.annotation.ControllerAdvice;
import org.springframework.web.bind.annotation.ExceptionHandler;
import org.springframework.web.context.request.NativeWebRequest;
import org.zalando.problem.DefaultProblem;
import org.zalando.problem.Problem;
import org.zalando.problem.ProblemBuilder;
import org.zalando.problem.Status;
import org.zalando.problem.StatusType;
import org.zalando.problem.ThrowableProblem;
import org.zalando.problem.spring.web.advice.ProblemHandling;
import org.zalando.problem.spring.web.advice.security.SecurityAdviceTrait;
import org.zalando.problem.violations.ConstraintViolationProblem;
import tech.jhipster.web.util.HeaderUtil;

@ControllerAdvice
public class ExceptionTranslator
implements ProblemHandling,
SecurityAdviceTrait {
    private static final String FIELD_ERRORS_KEY = "fieldErrors";
    private static final String MESSAGE_KEY = "message";
    private static final String PATH_KEY = "path";
    private static final String VIOLATIONS_KEY = "violations";
    @Value(value="${jhipster.clientApp.name}")
    private String applicationName;
    private final Environment env;

    public ExceptionTranslator(Environment env) {
        this.env = env;
    }

    public ResponseEntity<Problem> process(@Nullable ResponseEntity<Problem> entity, NativeWebRequest request) {
        if (entity == null) {
            return null;
        }
        Problem problem = (Problem)entity.getBody();
        if (!(problem instanceof ConstraintViolationProblem) && !(problem instanceof DefaultProblem)) {
            return entity;
        }
        HttpServletRequest nativeRequest = (HttpServletRequest)request.getNativeRequest(HttpServletRequest.class);
        String requestUri = nativeRequest != null ? nativeRequest.getRequestURI() : "";
        ProblemBuilder builder = Problem.builder().withType(Problem.DEFAULT_TYPE.equals(problem.getType()) ? ErrorConstants.DEFAULT_TYPE : problem.getType()).withStatus(problem.getStatus()).withTitle(problem.getTitle()).with(PATH_KEY, (Object)requestUri);
        if (problem instanceof ConstraintViolationProblem) {
            builder.with(VIOLATIONS_KEY, (Object)((ConstraintViolationProblem)problem).getViolations()).with(MESSAGE_KEY, (Object)"error.validation");
        } else {
            builder.withCause(((DefaultProblem)problem).getCause()).withDetail(problem.getDetail()).withInstance(problem.getInstance());
            problem.getParameters().forEach((arg_0, arg_1) -> ((ProblemBuilder)builder).with(arg_0, arg_1));
            if (!problem.getParameters().containsKey(MESSAGE_KEY) && problem.getStatus() != null) {
                builder.with(MESSAGE_KEY, (Object)("error.http." + problem.getStatus().getStatusCode()));
            }
        }
        return new ResponseEntity((Object)builder.build(), (MultiValueMap)entity.getHeaders(), entity.getStatusCode());
    }

    public ResponseEntity<Problem> handleMethodArgumentNotValid(MethodArgumentNotValidException ex, @Nonnull NativeWebRequest request) {
        BindingResult result = ex.getBindingResult();
        List fieldErrors = result.getFieldErrors().stream().map(f -> new FieldErrorVM(f.getObjectName().replaceFirst("DTO$", ""), f.getField(), StringUtils.isNotBlank((CharSequence)f.getDefaultMessage()) ? f.getDefaultMessage() : f.getCode())).collect(Collectors.toList());
        ThrowableProblem problem = Problem.builder().withType(ErrorConstants.CONSTRAINT_VIOLATION_TYPE).withTitle("Method argument not valid").withStatus(this.defaultConstraintViolationStatus()).with(MESSAGE_KEY, (Object)"error.validation").with(FIELD_ERRORS_KEY, fieldErrors).build();
        return this.create((Throwable)ex, (Problem)problem, request);
    }

    @ExceptionHandler
    public ResponseEntity<Problem> handleBadRequestAlertException(BadRequestAlertException ex, NativeWebRequest request) {
        return this.create((ThrowableProblem)ex, request, HeaderUtil.createFailureAlert((String)this.applicationName, (boolean)true, (String)ex.getEntityName(), (String)ex.getErrorKey(), (String)ex.getMessage()));
    }

    @ExceptionHandler
    public ResponseEntity<Problem> handleConcurrencyFailure(ConcurrencyFailureException ex, NativeWebRequest request) {
        ThrowableProblem problem = Problem.builder().withStatus((StatusType)Status.CONFLICT).with(MESSAGE_KEY, (Object)"error.concurrencyFailure").build();
        return this.create((Throwable)ex, (Problem)problem, request);
    }

    public ProblemBuilder prepare(Throwable throwable, StatusType status, URI type) {
        List<String> activeProfiles = Arrays.asList(this.env.getActiveProfiles());
        if (activeProfiles.contains("prod")) {
            if (throwable instanceof HttpMessageConversionException) {
                return Problem.builder().withType(type).withTitle(status.getReasonPhrase()).withStatus(status).withDetail("Unable to convert http message").withCause((ThrowableProblem)Optional.ofNullable(throwable.getCause()).filter(cause -> this.isCausalChainsEnabled()).map(arg_0 -> ((ExceptionTranslator)this).toProblem(arg_0)).orElse(null));
            }
            if (throwable instanceof DataAccessException) {
                return Problem.builder().withType(type).withTitle(status.getReasonPhrase()).withStatus(status).withDetail("Failure during data access").withCause((ThrowableProblem)Optional.ofNullable(throwable.getCause()).filter(cause -> this.isCausalChainsEnabled()).map(arg_0 -> ((ExceptionTranslator)this).toProblem(arg_0)).orElse(null));
            }
            if (this.containsPackageName(throwable.getMessage())) {
                return Problem.builder().withType(type).withTitle(status.getReasonPhrase()).withStatus(status).withDetail("Unexpected runtime exception").withCause((ThrowableProblem)Optional.ofNullable(throwable.getCause()).filter(cause -> this.isCausalChainsEnabled()).map(arg_0 -> ((ExceptionTranslator)this).toProblem(arg_0)).orElse(null));
            }
        }
        return Problem.builder().withType(type).withTitle(status.getReasonPhrase()).withStatus(status).withDetail(throwable.getMessage()).withCause((ThrowableProblem)Optional.ofNullable(throwable.getCause()).filter(cause -> this.isCausalChainsEnabled()).map(arg_0 -> ((ExceptionTranslator)this).toProblem(arg_0)).orElse(null));
    }

    private boolean containsPackageName(String message) {
        return StringUtils.containsAny((CharSequence)message, (CharSequence[])new CharSequence[]{"org.", "java.", "net.", "javax.", "com.", "io.", "de.", "com.upl.digitalmodular"});
    }
}

