/*
 * Decompiled with CFR 0.152.
 */
package com.upl.digitalmodular.web.rest;

import com.upl.digitalmodular.service.NotificationQueryService;
import com.upl.digitalmodular.service.NotificationService;
import com.upl.digitalmodular.service.criteria.NotificationCriteria;
import com.upl.digitalmodular.service.dto.NotificationDTO;
import com.upl.digitalmodular.service.utility.I18nUtility;
import com.upl.digitalmodular.web.rest.errors.BadRequestAlertException;
import java.net.URI;
import java.net.URISyntaxException;
import java.util.Optional;
import javax.validation.Valid;
import javax.validation.constraints.NotNull;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;
import org.springframework.beans.factory.annotation.Autowired;
import org.springframework.beans.factory.annotation.Value;
import org.springframework.data.domain.Page;
import org.springframework.data.domain.Pageable;
import org.springframework.http.HttpHeaders;
import org.springframework.http.ResponseEntity;
import org.springframework.web.bind.annotation.DeleteMapping;
import org.springframework.web.bind.annotation.GetMapping;
import org.springframework.web.bind.annotation.PatchMapping;
import org.springframework.web.bind.annotation.PathVariable;
import org.springframework.web.bind.annotation.PostMapping;
import org.springframework.web.bind.annotation.PutMapping;
import org.springframework.web.bind.annotation.RequestBody;
import org.springframework.web.bind.annotation.RequestMapping;
import org.springframework.web.bind.annotation.RequestParam;
import org.springframework.web.bind.annotation.RestController;
import org.springframework.web.servlet.support.ServletUriComponentsBuilder;
import org.springframework.web.util.UriComponentsBuilder;
import tech.jhipster.web.util.HeaderUtil;
import tech.jhipster.web.util.PaginationUtil;
import tech.jhipster.web.util.ResponseUtil;

@RestController
@RequestMapping(value={"/api"})
public class NotificationResource {
    private final Logger log = LoggerFactory.getLogger(NotificationResource.class);
    private static final String ENTITY_NAME = "digitalmodularNotification";
    @Value(value="${jhipster.clientApp.name}")
    private String applicationName;
    private final NotificationService notificationService;
    private final NotificationQueryService notificationQueryService;
    @Autowired
    private I18nUtility i18nUtility;

    public NotificationResource(NotificationService notificationService, NotificationQueryService notificationQueryService) {
        this.notificationService = notificationService;
        this.notificationQueryService = notificationQueryService;
    }

    @PostMapping(value={"/notifications"})
    public ResponseEntity<NotificationDTO> createNotification(@Valid @RequestBody NotificationDTO notificationDTO) throws URISyntaxException {
        this.log.debug("REST request to save Notification : {}", (Object)notificationDTO);
        if (notificationDTO.getId() != null) {
            String message = this.i18nUtility.getMessage("notification.create.id.exception", null);
            throw new BadRequestAlertException(message, ENTITY_NAME, "idexists");
        }
        NotificationDTO result = this.notificationService.save(notificationDTO);
        return ((ResponseEntity.BodyBuilder)ResponseEntity.created((URI)new URI("/api/notifications/" + result.getId())).headers(HeaderUtil.createEntityCreationAlert((String)this.applicationName, (boolean)true, (String)ENTITY_NAME, (String)result.getId().toString()))).body((Object)result);
    }

    @PutMapping(value={"/notifications/{id}"})
    public ResponseEntity<NotificationDTO> updateNotification(@PathVariable(value="id", required=false) Long id, @Valid @RequestBody NotificationDTO notificationDTO) throws URISyntaxException {
        this.log.debug("REST request to update Notification : {}, {}", (Object)id, (Object)notificationDTO);
        if (notificationDTO.getId() == null) {
            String message = this.i18nUtility.getMessage("notification.update.id.exception", null);
            throw new BadRequestAlertException(message, ENTITY_NAME, "idnull");
        }
        NotificationDTO result = this.notificationService.save(notificationDTO);
        return ((ResponseEntity.BodyBuilder)ResponseEntity.ok().headers(HeaderUtil.createEntityUpdateAlert((String)this.applicationName, (boolean)true, (String)ENTITY_NAME, (String)notificationDTO.getId().toString()))).body((Object)result);
    }

    @PatchMapping(value={"/notifications/{id}"}, consumes={"application/json", "application/merge-patch+json"})
    public ResponseEntity<NotificationDTO> partialUpdateNotification(@PathVariable(value="id", required=false) Long id, @NotNull @RequestBody NotificationDTO notificationDTO) throws URISyntaxException {
        this.log.debug("REST request to partial update Notification partially : {}, {}", (Object)id, (Object)notificationDTO);
        if (notificationDTO.getId() == null) {
            String message = this.i18nUtility.getMessage("notification.patch.id.exception", null);
            throw new BadRequestAlertException(message, ENTITY_NAME, "idnull");
        }
        Optional result = this.notificationService.partialUpdate(notificationDTO);
        return ResponseUtil.wrapOrNotFound((Optional)result, (HttpHeaders)HeaderUtil.createEntityUpdateAlert((String)this.applicationName, (boolean)true, (String)ENTITY_NAME, (String)notificationDTO.getId().toString()));
    }

    @GetMapping(value={"/notifications"})
    public ResponseEntity<Page<NotificationDTO>> getAllNotifications(NotificationCriteria criteria, Pageable pageable) {
        this.log.debug("REST request to get Notifications by criteria: {}", (Object)criteria);
        Page page = this.notificationQueryService.findByCriteria(criteria, pageable);
        HttpHeaders headers = PaginationUtil.generatePaginationHttpHeaders((UriComponentsBuilder)ServletUriComponentsBuilder.fromCurrentRequest(), (Page)page);
        return ((ResponseEntity.BodyBuilder)ResponseEntity.ok().headers(headers)).body((Object)page);
    }

    @GetMapping(value={"/notifications/count"})
    public ResponseEntity<Long> countNotifications(NotificationCriteria criteria) {
        this.log.debug("REST request to count Notifications by criteria: {}", (Object)criteria);
        return ResponseEntity.ok().body((Object)this.notificationQueryService.countByCriteria(criteria));
    }

    @GetMapping(value={"/notifications/{id}"})
    public ResponseEntity<NotificationDTO> getNotification(@PathVariable Long id) {
        this.log.debug("REST request to get Notification : {}", (Object)id);
        Optional notificationDTO = this.notificationService.findOne(id);
        return ResponseUtil.wrapOrNotFound((Optional)notificationDTO);
    }

    @DeleteMapping(value={"/notifications/{id}"})
    public ResponseEntity<Void> deleteNotification(@PathVariable Long id) {
        this.log.debug("REST request to delete Notification : {}", (Object)id);
        this.notificationService.delete(id);
        return ResponseEntity.noContent().headers(HeaderUtil.createEntityDeletionAlert((String)this.applicationName, (boolean)true, (String)ENTITY_NAME, (String)id.toString())).build();
    }

    @PutMapping(value={"/notifications/read"})
    public ResponseEntity<Void> readNotification(Long id, @RequestParam Boolean readAll, @RequestParam(value="category", required=false) Integer category) {
        this.log.debug("REST request to read notification : {}", (Object)id);
        this.notificationService.readNotification(id, readAll, category);
        return ResponseEntity.noContent().build();
    }

    @PutMapping(value={"/notifications/readOne/{id}"})
    public ResponseEntity<Void> readOneNotifications(@PathVariable Long id) {
        this.log.debug("REST request to read one notification : {}", (Object)id);
        this.notificationService.readOneNotification(id);
        return ResponseEntity.noContent().build();
    }

    @GetMapping(value={"/notifications/count/admin"})
    public Integer countNotificationsAdmin() {
        this.log.debug("REST request to count Notifications by criteria");
        return this.notificationService.countNotificationAdmin();
    }
}

