/*
 * Decompiled with CFR 0.152.
 */
package com.upl.digitalmodular.web.rest;

import com.upl.digitalmodular.service.utility.AmazonUtility;
import java.io.IOException;
import java.io.InputStream;
import java.io.OutputStream;
import javax.servlet.http.HttpServletRequest;
import javax.servlet.http.HttpServletResponse;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;
import org.springframework.http.ResponseEntity;
import org.springframework.util.StreamUtils;
import org.springframework.web.bind.annotation.DeleteMapping;
import org.springframework.web.bind.annotation.GetMapping;
import org.springframework.web.bind.annotation.RequestMapping;
import org.springframework.web.bind.annotation.RequestParam;
import org.springframework.web.bind.annotation.RestController;

@RestController
@RequestMapping(value={"/api"})
public class ImageResource {
    private final Logger log = LoggerFactory.getLogger(ImageResource.class);
    private final AmazonUtility amazonUtility;

    public ImageResource(AmazonUtility amazonUtility) {
        this.amazonUtility = amazonUtility;
    }

    @GetMapping(value={"/image/**"})
    public void getImage(HttpServletRequest request, HttpServletResponse response) throws IOException {
        String path = request.getRequestURI().split(request.getContextPath() + "/image/")[1];
        this.log.debug("path {}", (Object)path);
        AmazonUtility.ImageResponse imageResponse = this.amazonUtility.getFileFromS3Bucket(path);
        response.setContentType(imageResponse.getContentType());
        StreamUtils.copy((InputStream)imageResponse.getInputStream(), (OutputStream)response.getOutputStream());
    }

    @DeleteMapping(value={"/image"})
    public ResponseEntity<Void> deleteTempFile(@RequestParam(required=true) String path) throws IOException {
        this.log.debug("REST request to delete Temp file : {}", (Object)path);
        this.amazonUtility.deleteFileFromS3Bucket(path);
        return ResponseEntity.noContent().build();
    }
}

