/*
 * Decompiled with CFR 0.152.
 */
package com.upl.digitalmodular.web.rest;

import com.fasterxml.jackson.core.JsonProcessingException;
import com.fasterxml.jackson.databind.JsonMappingException;
import com.upl.digitalmodular.domain.enumeration.ApplicationName;
import com.upl.digitalmodular.security.SecurityUtils;
import com.upl.digitalmodular.service.AppUserQueryService;
import com.upl.digitalmodular.service.AppUserService;
import com.upl.digitalmodular.service.criteria.AppUserCriteria;
import com.upl.digitalmodular.service.dto.AppUserDTO;
import com.upl.digitalmodular.service.utility.AuthenticationUtility;
import com.upl.digitalmodular.service.utility.I18nUtility;
import com.upl.digitalmodular.web.rest.errors.BadRequestAlertException;
import java.io.IOException;
import java.net.URI;
import java.net.URISyntaxException;
import java.util.Optional;
import javax.validation.Valid;
import javax.validation.constraints.NotNull;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;
import org.springframework.beans.factory.annotation.Autowired;
import org.springframework.beans.factory.annotation.Value;
import org.springframework.data.domain.Page;
import org.springframework.data.domain.Pageable;
import org.springframework.http.HttpHeaders;
import org.springframework.http.ResponseEntity;
import org.springframework.security.access.prepost.PreAuthorize;
import org.springframework.web.bind.annotation.DeleteMapping;
import org.springframework.web.bind.annotation.GetMapping;
import org.springframework.web.bind.annotation.PatchMapping;
import org.springframework.web.bind.annotation.PathVariable;
import org.springframework.web.bind.annotation.PostMapping;
import org.springframework.web.bind.annotation.PutMapping;
import org.springframework.web.bind.annotation.RequestBody;
import org.springframework.web.bind.annotation.RequestHeader;
import org.springframework.web.bind.annotation.RequestMapping;
import org.springframework.web.bind.annotation.RequestParam;
import org.springframework.web.bind.annotation.RequestPart;
import org.springframework.web.bind.annotation.RestController;
import org.springframework.web.client.HttpStatusCodeException;
import org.springframework.web.multipart.MultipartFile;
import org.springframework.web.servlet.support.ServletUriComponentsBuilder;
import org.springframework.web.util.UriComponentsBuilder;
import tech.jhipster.web.util.HeaderUtil;
import tech.jhipster.web.util.PaginationUtil;
import tech.jhipster.web.util.ResponseUtil;

@RestController
@RequestMapping(value={"/api"})
public class AppUserResource {
    private final Logger log = LoggerFactory.getLogger(AppUserResource.class);
    private static final String ENTITY_NAME = "digitalmodularAppUser";
    @Value(value="${jhipster.clientApp.name}")
    private String applicationName;
    @Autowired
    private AuthenticationUtility authenticationUtility;
    private final AppUserService appUserService;
    private final AppUserQueryService appUserQueryService;
    @Autowired
    private I18nUtility i18nUtility;

    public AppUserResource(AppUserService appUserService, AppUserQueryService appUserQueryService) {
        this.appUserService = appUserService;
        this.appUserQueryService = appUserQueryService;
    }

    @PostMapping(value={"/app-users"})
    @PreAuthorize(value="hasAnyAuthority(\"ADMIN\")")
    public ResponseEntity<AppUserDTO> createAppUser(@Valid @RequestBody AppUserDTO appUserDTO) throws URISyntaxException {
        this.log.debug("REST request to save AppUser : {}", (Object)appUserDTO);
        if (appUserDTO.getId() != null) {
            String message = this.i18nUtility.getMessage("appUser.create.id.exception", null);
            throw new BadRequestAlertException(message, ENTITY_NAME, "idexists");
        }
        AppUserDTO result = this.appUserService.save(appUserDTO);
        return ((ResponseEntity.BodyBuilder)ResponseEntity.created((URI)new URI("/api/app-users/" + result.getId())).headers(HeaderUtil.createEntityCreationAlert((String)this.applicationName, (boolean)true, (String)ENTITY_NAME, (String)result.getId().toString()))).body((Object)result);
    }

    @PutMapping(value={"/app-users/{id}"})
    public ResponseEntity<AppUserDTO> updateAppUser(@PathVariable(value="id", required=false) Long id, @Valid @RequestBody AppUserDTO appUserDTO) throws URISyntaxException {
        this.log.debug("REST request to update AppUser : {}, {}", (Object)id, (Object)appUserDTO);
        if (appUserDTO.getId() == null) {
            String message = this.i18nUtility.getMessage("appUser.update.id.exception", null);
            throw new BadRequestAlertException(message, ENTITY_NAME, "idnull");
        }
        AppUserDTO result = this.appUserService.save(appUserDTO);
        return ((ResponseEntity.BodyBuilder)ResponseEntity.ok().headers(HeaderUtil.createEntityUpdateAlert((String)this.applicationName, (boolean)true, (String)ENTITY_NAME, (String)appUserDTO.getId().toString()))).body((Object)result);
    }

    @PatchMapping(value={"/app-users/{id}"}, consumes={"application/json", "application/merge-patch+json"})
    public ResponseEntity<AppUserDTO> partialUpdateAppUser(@PathVariable(value="id", required=false) Long id, @NotNull @RequestBody AppUserDTO appUserDTO) throws URISyntaxException {
        this.log.debug("REST request to partial update AppUser partially : {}, {}", (Object)id, (Object)appUserDTO);
        if (appUserDTO.getId() == null) {
            String message = this.i18nUtility.getMessage("appUser.patch.id.exception", null);
            throw new BadRequestAlertException(message, ENTITY_NAME, "idnull");
        }
        Optional result = this.appUserService.partialUpdate(appUserDTO);
        return ResponseUtil.wrapOrNotFound((Optional)result, (HttpHeaders)HeaderUtil.createEntityUpdateAlert((String)this.applicationName, (boolean)true, (String)ENTITY_NAME, (String)appUserDTO.getId().toString()));
    }

    @GetMapping(value={"/app-users/all"})
    public ResponseEntity<Page<AppUserDTO>> getAllAppUsers(AppUserCriteria criteria, Pageable pageable) {
        this.log.debug("REST request to get AppUsers by criteria: {}", (Object)criteria);
        Page page = this.appUserQueryService.findByCriteria(criteria, pageable);
        HttpHeaders headers = PaginationUtil.generatePaginationHttpHeaders((UriComponentsBuilder)ServletUriComponentsBuilder.fromCurrentRequest(), (Page)page);
        return ((ResponseEntity.BodyBuilder)ResponseEntity.ok().headers(headers)).body((Object)page);
    }

    @GetMapping(value={"/app-user"})
    public ResponseEntity<AppUserDTO> getCurrentAppUser() {
        this.log.debug("REST request to get logged in AppUser");
        Long loggedInUserId = Long.parseLong((String)SecurityUtils.getCurrentUserLogin().get());
        Optional appUserDTO = this.appUserService.findOne(loggedInUserId);
        ((AppUserDTO)appUserDTO.get()).setPassword(null);
        return ResponseUtil.wrapOrNotFound((Optional)appUserDTO);
    }

    @GetMapping(value={"/app-users/count"})
    public ResponseEntity<Long> countAppUsers(AppUserCriteria criteria) {
        this.log.debug("REST request to count AppUsers by criteria: {}", (Object)criteria);
        return ResponseEntity.ok().body((Object)this.appUserQueryService.countByCriteria(criteria));
    }

    @GetMapping(value={"/app-users/{id}"})
    public ResponseEntity<AppUserDTO> getAppUser(@PathVariable Long id) {
        this.log.debug("REST request to get AppUser : {}", (Object)id);
        Optional appUserDTO = this.appUserService.findOne(id);
        return ResponseUtil.wrapOrNotFound((Optional)appUserDTO);
    }

    @DeleteMapping(value={"/app-users/{id}"})
    public ResponseEntity<Void> deleteAppUser(@PathVariable Long id) {
        this.log.debug("REST request to delete AppUser : {}", (Object)id);
        this.appUserService.delete(id);
        return ResponseEntity.noContent().headers(HeaderUtil.createEntityDeletionAlert((String)this.applicationName, (boolean)false, (String)ENTITY_NAME, (String)id.toString())).build();
    }

    @PostMapping(value={"/app-users/{id}/profile-image"})
    public ResponseEntity<AppUserDTO> uploadProfileImage(@RequestPart(value="file") MultipartFile file, @PathVariable Long id) throws IOException {
        Optional existingAppUserDTO;
        Long loggedInUserId = Long.parseLong((String)SecurityUtils.getCurrentUserLogin().get());
        if (loggedInUserId.equals(id) && (existingAppUserDTO = this.appUserService.findOne(id)).isPresent() && !((AppUserDTO)existingAppUserDTO.get()).getId().equals(loggedInUserId)) {
            String message = this.i18nUtility.getMessage("appuser.image.role.exception", null);
            throw new BadRequestAlertException(message, ENTITY_NAME, "appUserIdIssue");
        }
        this.log.debug("profile image upload and save for AppUserId : {}", (Object)id);
        AppUserDTO result = this.appUserService.uploadAndSaveProfileImage(id, file);
        return ResponseEntity.ok().body((Object)result);
    }

    @PostMapping(value={"/application-addUser"})
    public ResponseEntity<?> applicationAddUser(@RequestBody AppUserDTO appUserDTO, @RequestHeader String countryName, @RequestHeader ApplicationName applicationName, @RequestHeader(value="Accept-Language") String acceptLanguage) {
        this.log.debug("REST request to save AppUser in uniweed : {}", (Object)appUserDTO);
        try {
            ResponseEntity appUser = this.authenticationUtility.applicationAddUser(appUserDTO, applicationName, countryName, acceptLanguage);
            return appUser;
        }
        catch (HttpStatusCodeException e) {
            return ((ResponseEntity.BodyBuilder)ResponseEntity.status((int)e.getRawStatusCode()).headers(e.getResponseHeaders())).body((Object)e.getResponseBodyAsString());
        }
    }

    @PutMapping(value={"/application-updateUser"})
    public ResponseEntity<?> applicationUpdateUser(@RequestBody AppUserDTO appUserDTO, @RequestHeader String countryName, @RequestHeader ApplicationName applicationName, @RequestHeader(value="Accept-Language") String acceptLanguage) {
        this.log.debug("REST request to update AppUser in application : {}", (Object)applicationName);
        try {
            ResponseEntity appUser = this.authenticationUtility.applicationUpdateUser(appUserDTO, applicationName, countryName, acceptLanguage);
            return appUser;
        }
        catch (HttpStatusCodeException e) {
            return ((ResponseEntity.BodyBuilder)ResponseEntity.status((int)e.getRawStatusCode()).headers(e.getResponseHeaders())).body((Object)e.getResponseBodyAsString());
        }
    }

    @PostMapping(value={"/application-getUsers/all"})
    public String applicationGetAllAppUsers(@RequestBody String values, Pageable pageable, @RequestParam(required=false, defaultValue="") String sort, @RequestHeader String countryName, @RequestHeader ApplicationName application) throws JsonMappingException, JsonProcessingException {
        this.log.debug("REST request to get AppUsers for application by: {}", (Object)values);
        String page = this.authenticationUtility.applicationGetAllAppUsers(values, pageable, sort, countryName, application);
        return page;
    }

    @GetMapping(value={"/application-getUser/{id}"})
    public ResponseEntity<?> applicationGetAppUser(@PathVariable Long id, @RequestHeader ApplicationName application) {
        this.log.debug("REST request to get AppUser : {}", (Object)id);
        try {
            AppUserDTO appUserDTO = this.authenticationUtility.applicationGetAppUser(id, application);
            return ResponseEntity.ok().body((Object)appUserDTO);
        }
        catch (HttpStatusCodeException e) {
            return ((ResponseEntity.BodyBuilder)ResponseEntity.status((int)e.getRawStatusCode()).headers(e.getResponseHeaders())).body((Object)e.getResponseBodyAsString());
        }
    }

    @DeleteMapping(value={"/application-deleteUser/{id}"})
    public ResponseEntity<Void> applicationDeleteAppUser(@PathVariable Long id, @RequestHeader ApplicationName application) {
        this.log.debug("REST request to delete AppUser : {}", (Object)id);
        this.authenticationUtility.applicationDeleteAppUser(id, application);
        return ResponseEntity.noContent().headers(HeaderUtil.createEntityDeletionAlert((String)this.applicationName, (boolean)false, (String)ENTITY_NAME, (String)id.toString())).build();
    }

    @GetMapping(value={"/app-roles/{id}"})
    public ResponseEntity<String> getRoles(@PathVariable Long id) {
        this.log.debug("REST request to get AppUserRoles : {}", (Object)id);
        try {
            return ResponseEntity.ok().body((Object)this.authenticationUtility.getRoles(id));
        }
        catch (HttpStatusCodeException e) {
            return ((ResponseEntity.BodyBuilder)ResponseEntity.status((int)e.getRawStatusCode()).headers(e.getResponseHeaders())).body((Object)e.getResponseBodyAsString());
        }
    }
}

