/*
 * Decompiled with CFR 0.152.
 */
package com.upl.digitalmodular.service.utility;

import com.amazonaws.services.apigateway.model.BadRequestException;
import com.fasterxml.jackson.core.JsonProcessingException;
import com.fasterxml.jackson.core.type.TypeReference;
import com.fasterxml.jackson.databind.JsonMappingException;
import com.fasterxml.jackson.databind.ObjectMapper;
import com.upl.digitalmodular.domain.AppKey;
import com.upl.digitalmodular.domain.Application;
import com.upl.digitalmodular.domain.ApplicationToken;
import com.upl.digitalmodular.domain.enumeration.ApplicationName;
import com.upl.digitalmodular.repository.AppKeyRepository;
import com.upl.digitalmodular.repository.ApplicationRepository;
import com.upl.digitalmodular.repository.ApplicationTokenRepository;
import com.upl.digitalmodular.service.dto.AppUserDTO;
import com.upl.digitalmodular.service.dto.ApplicationDTO;
import com.upl.digitalmodular.service.dto.JWTTokenDTO;
import com.upl.digitalmodular.service.utility.AmazonUtility;
import com.upl.digitalmodular.service.utility.AuthenticationUtility;
import com.upl.digitalmodular.service.utility.I18nUtility;
import java.net.URI;
import java.time.Instant;
import java.time.temporal.ChronoUnit;
import java.util.HashMap;
import java.util.Optional;
import java.util.concurrent.CompletableFuture;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;
import org.springframework.beans.factory.annotation.Autowired;
import org.springframework.beans.factory.annotation.Value;
import org.springframework.data.domain.Pageable;
import org.springframework.http.HttpEntity;
import org.springframework.http.HttpHeaders;
import org.springframework.http.HttpMethod;
import org.springframework.http.HttpStatus;
import org.springframework.http.MediaType;
import org.springframework.http.ResponseEntity;
import org.springframework.stereotype.Component;
import org.springframework.util.LinkedMultiValueMap;
import org.springframework.util.MultiValueMap;
import org.springframework.web.bind.annotation.RequestBody;
import org.springframework.web.client.RestTemplate;
import org.springframework.web.util.UriComponentsBuilder;

@Component
public class AuthenticationUtility {
    private final Logger log = LoggerFactory.getLogger(AmazonUtility.class);
    @Value(value="${application.allowed-image-content-types:}")
    private String allowedImageContentTypes;
    @Autowired
    private I18nUtility i18nUtility;
    @Autowired
    private AppKeyRepository appKeyRepository;
    @Autowired
    private ApplicationRepository applicationRepository;
    @Autowired
    private ApplicationTokenRepository applicationTokenRepository;
    @Autowired
    private RestTemplate restTemplate;

    public CompletableFuture<JWTTokenDTO> authenticationToken(String email, ApplicationDTO applicationDto) {
        try {
            Optional appKey = this.appKeyRepository.findByApplicationName(applicationDto.getName());
            HttpHeaders httpHeaders = new HttpHeaders();
            httpHeaders.set("Secret-Key", ((AppKey)appKey.get()).getSecretKey());
            httpHeaders.set("Access-Key", ((AppKey)appKey.get()).getAccessKey());
            httpHeaders.setContentType(MediaType.APPLICATION_JSON);
            HashMap<String, String> map = new HashMap<String, String>();
            map.put("email", email);
            HttpEntity request = new HttpEntity(map, (MultiValueMap)httpHeaders);
            JWTTokenDTO response = (JWTTokenDTO)this.restTemplate.postForObject(applicationDto.getApplicationApiUrl() + "api/modular/auth", (Object)request, JWTTokenDTO.class, new Object[0]);
            return CompletableFuture.completedFuture(response);
        }
        catch (Exception e) {
            this.log.error("Error while calling authentication API");
            String message = this.i18nUtility.getMessage("custom.error.message", null);
            throw new BadRequestException(message);
        }
    }

    public String getApplicationToken(@RequestBody AppUserDTO appUserDTO) {
        Optional appKey = this.appKeyRepository.findByApplicationId(appUserDTO.getApplicationId());
        this.log.debug("Getting token for authentication Application : {}", (Object)appUserDTO);
        Optional<ApplicationToken> appToken = this.applicationTokenRepository.findByApplicationId(appUserDTO.getApplicationId());
        Application application = (Application)this.applicationRepository.findById((Object)appUserDTO.getApplicationId()).get();
        HttpHeaders httpHeaders = new HttpHeaders();
        httpHeaders.set("Secret-Key", ((AppKey)appKey.get()).getSecretKey());
        httpHeaders.set("Access-Key", ((AppKey)appKey.get()).getAccessKey());
        httpHeaders.setContentType(MediaType.APPLICATION_JSON);
        HashMap<String, String> map = new HashMap<String, String>();
        map.put("email", ((AppKey)this.appKeyRepository.findByApplicationId(appUserDTO.getApplicationId()).get()).getAdminEmail());
        HttpEntity request = new HttpEntity(map, (MultiValueMap)httpHeaders);
        JWTTokenDTO response = null;
        if (!appToken.isPresent()) {
            appToken = Optional.of(new ApplicationToken());
            response = (JWTTokenDTO)this.restTemplate.postForObject(((Application)this.applicationRepository.findById((Object)appUserDTO.getApplicationId()).get()).getApplicationApiUrl() + "api/modular/auth", (Object)request, JWTTokenDTO.class, new Object[0]);
            appToken.get().setToken(response.getToken());
            appToken.get().setStatus(Boolean.valueOf(true));
            appToken.get().setExpireAt(Instant.now().plus(29L, ChronoUnit.DAYS));
            appToken.get().setApplication(application);
            this.applicationTokenRepository.save((Object)appToken.get());
        } else if (appToken.isPresent() || appToken.get().getExpireAt().isAfter(Instant.now())) {
            appToken.get().setToken(appToken.get().getToken());
            appToken.get().setExpireAt(appToken.get().getExpireAt());
            appToken.get().setStatus(Boolean.valueOf(true));
            appToken.get().setApplication(application);
            this.applicationTokenRepository.save((Object)appToken.get());
        }
        if (!appToken.get().getExpireAt().isAfter(Instant.now())) {
            response = (JWTTokenDTO)this.restTemplate.postForObject(((Application)this.applicationRepository.findById((Object)appUserDTO.getApplicationId()).get()).getApplicationApiUrl() + "api/modular/auth", (Object)request, JWTTokenDTO.class, new Object[0]);
            appToken.get().setToken(response.getToken());
            appToken.get().setStatus(Boolean.valueOf(true));
            appToken.get().setExpireAt(Instant.now().plus(29L, ChronoUnit.DAYS));
            appToken.get().setApplication(application);
            this.applicationTokenRepository.save((Object)appToken.get());
        }
        return appToken.get().getToken();
    }

    public ResponseEntity<AppUserDTO> applicationAddUser(AppUserDTO appUserDTO, ApplicationName applicationName, String countryName, String acceptLanguage) {
        HttpHeaders httpHeaders = new HttpHeaders();
        httpHeaders.setContentType(MediaType.APPLICATION_JSON);
        HttpEntity httpEntity = new HttpEntity((Object)appUserDTO, (MultiValueMap)httpHeaders);
        AppUserDTO appUser = new AppUserDTO();
        String token = this.getApplicationToken(appUserDTO);
        switch (2.$SwitchMap$com$upl$digitalmodular$domain$enumeration$ApplicationName[applicationName.ordinal()]) {
            case 1: {
                httpHeaders.setBearerAuth(token);
                httpHeaders.set("countryName", appUserDTO.getCountryName());
                httpHeaders.set("applicationName", "UNIWEED");
                httpHeaders.set("Accept-Language", acceptLanguage);
                ResponseEntity newPost = this.restTemplate.postForEntity(((Application)this.applicationRepository.findById((Object)appUserDTO.getApplicationId()).get()).getApplicationApiUrl() + "api/modularApp-users/", (Object)httpEntity, AppUserDTO.class, new Object[0]);
                if (newPost.getStatusCode() != HttpStatus.CREATED) break;
                appUser = (AppUserDTO)newPost.getBody();
                break;
            }
            case 2: {
                httpHeaders.setBearerAuth(token);
                httpHeaders.set("countryName", appUserDTO.getCountryName());
                httpHeaders.set("applicationName", "PADDYXPR");
                httpHeaders.set("Accept-Language", acceptLanguage);
                ResponseEntity result = this.restTemplate.postForEntity(((Application)this.applicationRepository.findById((Object)appUserDTO.getApplicationId()).get()).getApplicationApiUrl() + "api/modularApp-users/", (Object)httpEntity, AppUserDTO.class, new Object[0]);
                if (result.getStatusCode() != HttpStatus.CREATED) break;
                appUser = (AppUserDTO)result.getBody();
                break;
            }
            case 3: {
                httpHeaders.setBearerAuth(token);
                httpHeaders.set("countryName", appUserDTO.getCountryName());
                httpHeaders.set("applicationName", "FARMETRIX");
                httpHeaders.set("Accept-Language", acceptLanguage);
                ResponseEntity post = this.restTemplate.postForEntity(((Application)this.applicationRepository.findById((Object)appUserDTO.getApplicationId()).get()).getApplicationApiUrl() + "api/modularApp-users/", (Object)httpEntity, AppUserDTO.class, new Object[0]);
                if (post.getStatusCode() != HttpStatus.CREATED) break;
                appUser = (AppUserDTO)post.getBody();
                break;
            }
            case 4: {
                httpHeaders.setBearerAuth(token);
                httpHeaders.set("countryName", appUserDTO.getCountryName());
                httpHeaders.set("applicationName", "FARMETRIX");
                httpHeaders.set("Accept-Language", acceptLanguage);
                ResponseEntity postGlobal = this.restTemplate.postForEntity(((Application)this.applicationRepository.findById((Object)appUserDTO.getApplicationId()).get()).getApplicationApiUrl() + "api/modularApp-users/", (Object)httpEntity, AppUserDTO.class, new Object[0]);
                if (postGlobal.getStatusCode() != HttpStatus.CREATED) break;
                appUser = (AppUserDTO)postGlobal.getBody();
                break;
            }
            case 5: {
                httpHeaders.setBearerAuth(token);
                httpHeaders.set("countryName", appUserDTO.getCountryName());
                httpHeaders.set("applicationName", "TUNAGRI");
                httpHeaders.set("Accept-Language", acceptLanguage);
                ResponseEntity post1 = this.restTemplate.postForEntity(((Application)this.applicationRepository.findById((Object)appUserDTO.getApplicationId()).get()).getApplicationApiUrl() + "api/modularApp-users/", (Object)httpEntity, AppUserDTO.class, new Object[0]);
                if (post1.getStatusCode() != HttpStatus.CREATED) break;
                appUser = (AppUserDTO)post1.getBody();
                break;
            }
            case 6: {
                httpHeaders.setBearerAuth(token);
                httpHeaders.set("countryName", appUserDTO.getCountryName());
                httpHeaders.set("applicationName", "DAM");
                httpHeaders.set("Accept-Language", acceptLanguage);
                ResponseEntity responseDam = this.restTemplate.postForEntity(((Application)this.applicationRepository.findById((Object)appUserDTO.getApplicationId()).get()).getApplicationApiUrl() + "api/modularApp-users/", (Object)httpEntity, AppUserDTO.class, new Object[0]);
                if (responseDam.getStatusCode() != HttpStatus.CREATED) break;
                appUser = (AppUserDTO)responseDam.getBody();
                break;
            }
            case 7: {
                httpHeaders.setBearerAuth(token);
                httpHeaders.set("countryName", appUserDTO.getCountryName());
                httpHeaders.set("applicationName", "PADDYXPR");
                httpHeaders.set("Accept-Language", acceptLanguage);
                ResponseEntity responsePhil = this.restTemplate.postForEntity(((Application)this.applicationRepository.findById((Object)appUserDTO.getApplicationId()).get()).getApplicationApiUrl() + "api/modularApp-users/", (Object)httpEntity, AppUserDTO.class, new Object[0]);
                if (responsePhil.getStatusCode() != HttpStatus.CREATED) break;
                appUser = (AppUserDTO)responsePhil.getBody();
                break;
            }
            case 8: {
                httpHeaders.setBearerAuth(token);
                httpHeaders.set("countryName", appUserDTO.getCountryName());
                httpHeaders.set("applicationName", "PADDYXPR");
                httpHeaders.set("Accept-Language", acceptLanguage);
                ResponseEntity responsePak = this.restTemplate.postForEntity(((Application)this.applicationRepository.findById((Object)appUserDTO.getApplicationId()).get()).getApplicationApiUrl() + "api/modularApp-users/", (Object)httpEntity, AppUserDTO.class, new Object[0]);
                if (responsePak.getStatusCode() != HttpStatus.CREATED) break;
                appUser = (AppUserDTO)responsePak.getBody();
                break;
            }
        }
        return ResponseEntity.ok().body((Object)appUser);
    }

    public ResponseEntity<AppUserDTO> applicationUpdateUser(AppUserDTO appUserDTO, ApplicationName applicationName, String countryName, String acceptLanguage) {
        HttpHeaders httpHeaders = new HttpHeaders();
        httpHeaders.setContentType(MediaType.APPLICATION_JSON);
        HttpEntity httpEntity = new HttpEntity((Object)appUserDTO, (MultiValueMap)httpHeaders);
        AppUserDTO appUser = new AppUserDTO();
        String token = this.getApplicationToken(appUserDTO);
        switch (2.$SwitchMap$com$upl$digitalmodular$domain$enumeration$ApplicationName[applicationName.ordinal()]) {
            case 1: {
                httpHeaders.setBearerAuth(token);
                httpHeaders.set("countryName", appUserDTO.getCountryName());
                httpHeaders.set("applicationName", "UNIWEED");
                httpHeaders.set("Accept-Language", acceptLanguage);
                ResponseEntity updatePost = this.restTemplate.exchange(((Application)this.applicationRepository.findById((Object)appUserDTO.getApplicationId()).get()).getApplicationApiUrl() + "api/modularApp-users/", HttpMethod.PUT, httpEntity, AppUserDTO.class, new Object[]{appUserDTO.getId()});
                if (updatePost.getStatusCode() != HttpStatus.OK) break;
                appUser = (AppUserDTO)updatePost.getBody();
                break;
            }
            case 2: {
                httpHeaders.setBearerAuth(token);
                httpHeaders.set("countryName", appUserDTO.getCountryName());
                httpHeaders.set("applicationName", "PADDYXPR");
                httpHeaders.set("Accept-Language", acceptLanguage);
                ResponseEntity result = this.restTemplate.exchange(((Application)this.applicationRepository.findById((Object)appUserDTO.getApplicationId()).get()).getApplicationApiUrl() + "api/modularApp-users/", HttpMethod.PUT, httpEntity, AppUserDTO.class, new Object[]{appUserDTO.getId()});
                if (result.getStatusCode() != HttpStatus.OK) break;
                appUser = (AppUserDTO)result.getBody();
                break;
            }
            case 3: {
                httpHeaders.setBearerAuth(token);
                httpHeaders.set("countryName", appUserDTO.getCountryName());
                httpHeaders.set("applicationName", "FARMETRIX");
                httpHeaders.set("Accept-Language", acceptLanguage);
                ResponseEntity response = this.restTemplate.exchange(((Application)this.applicationRepository.findById((Object)appUserDTO.getApplicationId()).get()).getApplicationApiUrl() + "api/modularApp-users/", HttpMethod.PUT, httpEntity, AppUserDTO.class, new Object[]{appUserDTO.getId()});
                if (response.getStatusCode() != HttpStatus.OK) break;
                appUser = (AppUserDTO)response.getBody();
                break;
            }
            case 4: {
                httpHeaders.setBearerAuth(token);
                httpHeaders.set("countryName", appUserDTO.getCountryName());
                httpHeaders.set("applicationName", "FARMETRIX");
                httpHeaders.set("Accept-Language", acceptLanguage);
                ResponseEntity responseGlobal = this.restTemplate.exchange(((Application)this.applicationRepository.findById((Object)appUserDTO.getApplicationId()).get()).getApplicationApiUrl() + "api/modularApp-users/", HttpMethod.PUT, httpEntity, AppUserDTO.class, new Object[]{appUserDTO.getId()});
                if (responseGlobal.getStatusCode() != HttpStatus.OK) break;
                appUser = (AppUserDTO)responseGlobal.getBody();
                break;
            }
            case 5: {
                httpHeaders.setBearerAuth(token);
                httpHeaders.set("countryName", appUserDTO.getCountryName());
                httpHeaders.set("applicationName", "TUNAGRI");
                httpHeaders.set("Accept-Language", acceptLanguage);
                ResponseEntity responseTunagri = this.restTemplate.exchange(((Application)this.applicationRepository.findById((Object)appUserDTO.getApplicationId()).get()).getApplicationApiUrl() + "api/modularApp-users/", HttpMethod.PUT, httpEntity, AppUserDTO.class, new Object[]{appUserDTO.getId()});
                if (responseTunagri.getStatusCode() != HttpStatus.OK) break;
                appUser = (AppUserDTO)responseTunagri.getBody();
                break;
            }
            case 6: {
                httpHeaders.setBearerAuth(token);
                httpHeaders.set("countryName", appUserDTO.getCountryName());
                httpHeaders.set("applicationName", "DAM");
                httpHeaders.set("Accept-Language", acceptLanguage);
                ResponseEntity responseDam = this.restTemplate.exchange(((Application)this.applicationRepository.findById((Object)appUserDTO.getApplicationId()).get()).getApplicationApiUrl() + "api/modularApp-users/", HttpMethod.PUT, httpEntity, AppUserDTO.class, new Object[]{appUserDTO.getId()});
                if (responseDam.getStatusCode() != HttpStatus.OK) break;
                appUser = (AppUserDTO)responseDam.getBody();
                break;
            }
            case 7: {
                httpHeaders.setBearerAuth(token);
                httpHeaders.set("countryName", appUserDTO.getCountryName());
                httpHeaders.set("applicationName", "PADDYXPR");
                httpHeaders.set("Accept-Language", acceptLanguage);
                ResponseEntity responsePhil = this.restTemplate.exchange(((Application)this.applicationRepository.findById((Object)appUserDTO.getApplicationId()).get()).getApplicationApiUrl() + "api/modularApp-users/", HttpMethod.PUT, httpEntity, AppUserDTO.class, new Object[]{appUserDTO.getId()});
                if (responsePhil.getStatusCode() != HttpStatus.OK) break;
                appUser = (AppUserDTO)responsePhil.getBody();
                break;
            }
            case 8: {
                httpHeaders.setBearerAuth(token);
                httpHeaders.set("countryName", appUserDTO.getCountryName());
                httpHeaders.set("applicationName", "PADDYXPR");
                httpHeaders.set("Accept-Language", acceptLanguage);
                ResponseEntity responsePak = this.restTemplate.exchange(((Application)this.applicationRepository.findById((Object)appUserDTO.getApplicationId()).get()).getApplicationApiUrl() + "api/modularApp-users/", HttpMethod.PUT, httpEntity, AppUserDTO.class, new Object[]{appUserDTO.getId()});
                if (responsePak.getStatusCode() != HttpStatus.OK) break;
                appUser = (AppUserDTO)responsePak.getBody();
                break;
            }
        }
        return ResponseEntity.ok().body((Object)appUser);
    }

    public String getApplicationToken(Long id) {
        Optional appKey = this.appKeyRepository.findByApplicationId(id);
        Optional<ApplicationToken> appToken = this.applicationTokenRepository.findByApplicationId(id);
        Application application = (Application)this.applicationRepository.findById((Object)id).get();
        HttpHeaders httpHeaders = new HttpHeaders();
        httpHeaders.set("Secret-Key", ((AppKey)appKey.get()).getSecretKey());
        httpHeaders.set("Access-Key", ((AppKey)appKey.get()).getAccessKey());
        httpHeaders.setContentType(MediaType.APPLICATION_JSON);
        HashMap<String, String> map = new HashMap<String, String>();
        map.put("email", ((AppKey)this.appKeyRepository.findByApplicationId(id).get()).getAdminEmail());
        HttpEntity request = new HttpEntity(map, (MultiValueMap)httpHeaders);
        JWTTokenDTO response = null;
        if (!appToken.isPresent()) {
            appToken = Optional.of(new ApplicationToken());
            response = (JWTTokenDTO)this.restTemplate.postForObject(((Application)this.applicationRepository.findById((Object)id).get()).getApplicationApiUrl() + "api/modular/auth", (Object)request, JWTTokenDTO.class, new Object[0]);
            appToken.get().setToken(response.getToken());
            appToken.get().setStatus(Boolean.valueOf(true));
            appToken.get().setExpireAt(Instant.now().plus(29L, ChronoUnit.DAYS));
            appToken.get().setApplication(application);
            this.applicationTokenRepository.save((Object)appToken.get());
        } else if (appToken.isPresent() || appToken.get().getExpireAt().isAfter(Instant.now())) {
            appToken.get().setToken(appToken.get().getToken());
            appToken.get().setExpireAt(appToken.get().getExpireAt());
            appToken.get().setStatus(Boolean.valueOf(true));
            appToken.get().setApplication(application);
            this.applicationTokenRepository.save((Object)appToken.get());
        }
        if (!appToken.get().getExpireAt().isAfter(Instant.now())) {
            response = (JWTTokenDTO)this.restTemplate.postForObject(((Application)this.applicationRepository.findById((Object)id).get()).getApplicationApiUrl() + "api/modular/auth", (Object)request, JWTTokenDTO.class, new Object[0]);
            appToken.get().setToken(response.getToken());
            appToken.get().setStatus(Boolean.valueOf(true));
            appToken.get().setExpireAt(Instant.now().plus(29L, ChronoUnit.DAYS));
            appToken.get().setApplication(application);
            this.applicationTokenRepository.save((Object)appToken.get());
        }
        return appToken.get().getToken();
    }

    public String applicationGetAllAppUsers(String filters, Pageable pageable, String sort, String countryName, ApplicationName application) throws JsonMappingException, JsonProcessingException {
        HttpHeaders httpHeaders = new HttpHeaders();
        httpHeaders.setContentType(MediaType.APPLICATION_JSON);
        httpHeaders.set("countryName", countryName);
        String token = this.getApplicationToken(this.applicationRepository.findByName(application.getValue()).getId());
        httpHeaders.setBearerAuth(token);
        HttpEntity body = new HttpEntity((MultiValueMap)httpHeaders);
        ObjectMapper mapper = new ObjectMapper();
        HashMap values = (HashMap)mapper.readValue(filters, (TypeReference)new /* Unavailable Anonymous Inner Class!! */);
        LinkedMultiValueMap filterMap = new LinkedMultiValueMap();
        values.forEach((arg_0, arg_1) -> AuthenticationUtility.lambda$applicationGetAllAppUsers$0((MultiValueMap)filterMap, arg_0, arg_1));
        URI targetUrl = UriComponentsBuilder.fromUriString((String)((Application)this.applicationRepository.findById((Object)this.applicationRepository.findByName(application.getValue()).getId()).get()).getApplicationApiUrl()).path("api/modularApp-users/all").queryParam("page", new Object[]{pageable.getPageNumber()}).queryParam("size", new Object[]{pageable.getPageSize()}).queryParams((MultiValueMap)filterMap).queryParam("sort", new Object[]{sort}).build().toUri();
        this.log.debug("URI : {}", (Object)targetUrl);
        String response = (String)this.restTemplate.exchange(targetUrl, HttpMethod.GET, body, String.class).getBody();
        return response;
    }

    public AppUserDTO applicationGetAppUser(Long id, ApplicationName application) {
        HttpHeaders httpHeaders = new HttpHeaders();
        httpHeaders.setContentType(MediaType.APPLICATION_JSON);
        String token = this.getApplicationToken(this.applicationRepository.findByName(application.getValue()).getId());
        httpHeaders.setBearerAuth(token);
        HttpEntity body = new HttpEntity((MultiValueMap)httpHeaders);
        URI targetUrl = UriComponentsBuilder.fromUriString((String)((Application)this.applicationRepository.findById((Object)this.applicationRepository.findByName(application.getValue()).getId()).get()).getApplicationApiUrl()).path("api/modularApp-users/" + id).build().toUri();
        AppUserDTO response = (AppUserDTO)this.restTemplate.exchange(targetUrl, HttpMethod.GET, body, AppUserDTO.class).getBody();
        return response;
    }

    public Void applicationDeleteAppUser(Long id, ApplicationName application) {
        HttpHeaders httpHeaders = new HttpHeaders();
        httpHeaders.setContentType(MediaType.APPLICATION_JSON);
        String token = this.getApplicationToken(this.applicationRepository.findByName(application.getValue()).getId());
        httpHeaders.setBearerAuth(token.trim());
        HttpEntity body = new HttpEntity((MultiValueMap)httpHeaders);
        URI targetUrl = UriComponentsBuilder.fromUriString((String)((Application)this.applicationRepository.findById((Object)this.applicationRepository.findByName(application.getValue()).getId()).get()).getApplicationApiUrl()).path("api/modularApp-user/" + id).build().toUri();
        this.restTemplate.exchange(targetUrl, HttpMethod.DELETE, body, String.class);
        return null;
    }

    public String getRoles(Long id) {
        Optional optionalApplication = this.applicationRepository.findById((Object)id);
        Application application = (Application)optionalApplication.get();
        HttpHeaders httpHeaders = new HttpHeaders();
        httpHeaders.setContentType(MediaType.APPLICATION_JSON);
        String token = this.getApplicationToken(this.applicationRepository.findByName(application.getName()).getId());
        httpHeaders.setBearerAuth(token);
        HttpEntity body = new HttpEntity((MultiValueMap)httpHeaders);
        URI targetUrl = UriComponentsBuilder.fromUriString((String)((Application)this.applicationRepository.findById((Object)this.applicationRepository.findByName(application.getName()).getId()).get()).getApplicationApiUrl()).path("api/external-user-role").queryParam("applicationName", new Object[]{application.getName()}).build().toUri();
        String response = (String)this.restTemplate.exchange(targetUrl, HttpMethod.GET, body, String.class).getBody();
        return response;
    }

    private static /* synthetic */ void lambda$applicationGetAllAppUsers$0(MultiValueMap filterMap, String key, String value) {
        filterMap.add((Object)key, (Object)value);
    }
}

