/*
 * Decompiled with CFR 0.152.
 */
package com.upl.digitalmodular.service.mapper;

import com.upl.digitalmodular.domain.Application;
import com.upl.digitalmodular.domain.Notification;
import com.upl.digitalmodular.service.dto.NotificationDTO;
import com.upl.digitalmodular.service.mapper.AppUserMapper;
import com.upl.digitalmodular.service.mapper.NotificationMapper;
import java.util.ArrayList;
import java.util.List;
import org.springframework.beans.factory.annotation.Autowired;
import org.springframework.stereotype.Component;

@Component
public class NotificationMapperImpl
implements NotificationMapper {
    @Autowired
    private AppUserMapper appUserMapper;

    public Notification toEntity(NotificationDTO dto) {
        if (dto == null) {
            return null;
        }
        Notification notification = new Notification();
        notification.setCreatedDate(dto.getCreatedDate());
        notification.setId(dto.getId());
        notification.setName(dto.getName());
        notification.setDescription(dto.getDescription());
        notification.setCategory(dto.getCategory());
        notification.setExpires(dto.getExpires());
        notification.setReadStatus(dto.getReadStatus());
        notification.setReadAt(dto.getReadAt());
        notification.setStatus(dto.getStatus());
        notification.appUser(this.appUserMapper.toEntity(dto.getAppUser()));
        return notification;
    }

    public List<Notification> toEntity(List<NotificationDTO> dtoList) {
        if (dtoList == null) {
            return null;
        }
        ArrayList<Notification> list = new ArrayList<Notification>(dtoList.size());
        for (NotificationDTO notificationDTO : dtoList) {
            list.add(this.toEntity(notificationDTO));
        }
        return list;
    }

    public List<NotificationDTO> toDto(List<Notification> entityList) {
        if (entityList == null) {
            return null;
        }
        ArrayList<NotificationDTO> list = new ArrayList<NotificationDTO>(entityList.size());
        for (Notification notification : entityList) {
            list.add(this.toDto(notification));
        }
        return list;
    }

    public void partialUpdate(Notification entity, NotificationDTO dto) {
        if (dto == null) {
            return;
        }
        if (dto.getCreatedDate() != null) {
            entity.setCreatedDate(dto.getCreatedDate());
        }
        if (dto.getId() != null) {
            entity.setId(dto.getId());
        }
        if (dto.getName() != null) {
            entity.setName(dto.getName());
        }
        if (dto.getDescription() != null) {
            entity.setDescription(dto.getDescription());
        }
        if (dto.getCategory() != null) {
            entity.setCategory(dto.getCategory());
        }
        if (dto.getExpires() != null) {
            entity.setExpires(dto.getExpires());
        }
        if (dto.getReadStatus() != null) {
            entity.setReadStatus(dto.getReadStatus());
        }
        if (dto.getReadAt() != null) {
            entity.setReadAt(dto.getReadAt());
        }
        if (dto.getStatus() != null) {
            entity.setStatus(dto.getStatus());
        }
        if (dto.getAppUser() != null) {
            entity.appUser(this.appUserMapper.toEntity(dto.getAppUser()));
        }
    }

    public NotificationDTO toDto(Notification s) {
        if (s == null) {
            return null;
        }
        NotificationDTO notificationDTO = new NotificationDTO();
        notificationDTO.setApplicationId(this.sApplicationId(s));
        notificationDTO.setApplicationName(this.sApplicationName(s));
        notificationDTO.setCreatedDate(s.getCreatedDate());
        notificationDTO.setId(s.getId());
        notificationDTO.setName(s.getName());
        notificationDTO.setDescription(s.getDescription());
        notificationDTO.setCategory(s.getCategory());
        notificationDTO.setExpires(s.getExpires());
        notificationDTO.setReadStatus(s.getReadStatus());
        notificationDTO.setReadAt(s.getReadAt());
        notificationDTO.setStatus(s.getStatus());
        notificationDTO.setAppUser(this.appUserMapper.toDto(s.getAppUser()));
        return notificationDTO;
    }

    private Long sApplicationId(Notification notification) {
        if (notification == null) {
            return null;
        }
        Application application = notification.getApplication();
        if (application == null) {
            return null;
        }
        Long id = application.getId();
        if (id == null) {
            return null;
        }
        return id;
    }

    private String sApplicationName(Notification notification) {
        if (notification == null) {
            return null;
        }
        Application application = notification.getApplication();
        if (application == null) {
            return null;
        }
        String name = application.getName();
        if (name == null) {
            return null;
        }
        return name;
    }
}

