/*
 * Decompiled with CFR 0.152.
 */
package com.upl.digitalmodular.service.mapper;

import com.upl.digitalmodular.domain.AppUser;
import com.upl.digitalmodular.domain.Country;
import com.upl.digitalmodular.domain.State;
import com.upl.digitalmodular.domain.enumeration.Role;
import com.upl.digitalmodular.service.dto.AppUserDTO;
import com.upl.digitalmodular.service.dto.CountryDTO;
import com.upl.digitalmodular.service.mapper.AppUserMapper;
import com.upl.digitalmodular.service.mapper.CountryMapper;
import com.upl.digitalmodular.service.mapper.StateMapper;
import java.util.ArrayList;
import java.util.List;
import org.springframework.beans.factory.annotation.Autowired;
import org.springframework.stereotype.Component;

@Component
public class AppUserMapperImpl
implements AppUserMapper {
    @Autowired
    private CountryMapper countryMapper;
    @Autowired
    private StateMapper stateMapper;

    public List<AppUser> toEntity(List<AppUserDTO> dtoList) {
        if (dtoList == null) {
            return null;
        }
        ArrayList<AppUser> list = new ArrayList<AppUser>(dtoList.size());
        for (AppUserDTO appUserDTO : dtoList) {
            list.add(this.toEntity(appUserDTO));
        }
        return list;
    }

    public List<AppUserDTO> toDto(List<AppUser> entityList) {
        if (entityList == null) {
            return null;
        }
        ArrayList<AppUserDTO> list = new ArrayList<AppUserDTO>(entityList.size());
        for (AppUser appUser : entityList) {
            list.add(this.toDto(appUser));
        }
        return list;
    }

    public void partialUpdate(AppUser entity, AppUserDTO dto) {
        if (dto == null) {
            return;
        }
        if (dto.getCreatedDate() != null) {
            entity.setCreatedDate(dto.getCreatedDate());
        }
        if (dto.getId() != null) {
            entity.setId(dto.getId());
        }
        if (dto.getEmail() != null) {
            entity.setEmail(dto.getEmail());
        }
        if (dto.getPassword() != null) {
            entity.setPassword(dto.getPassword());
        }
        if (dto.getFirstName() != null) {
            entity.setFirstName(dto.getFirstName());
        }
        if (dto.getLastName() != null) {
            entity.setLastName(dto.getLastName());
        }
        if (dto.getFullName() != null) {
            entity.setFullName(dto.getFullName());
        }
        if (dto.getMobileNumber() != null) {
            entity.setMobileNumber(dto.getMobileNumber());
        }
        if (dto.getProfilePhotoPath() != null) {
            entity.setProfilePhotoPath(dto.getProfilePhotoPath());
        }
        if (dto.getRole() != null) {
            entity.setRole(Enum.valueOf(Role.class, dto.getRole()));
        }
        if (dto.getStatus() != null) {
            entity.setStatus(dto.getStatus());
        }
        if (dto.getPincode() != null) {
            entity.setPincode(dto.getPincode());
        }
        if (dto.getCity() != null) {
            entity.setCity(dto.getCity());
        }
        if (dto.getStreet() != null) {
            entity.setStreet(dto.getStreet());
        }
        if (dto.getDistrict() != null) {
            entity.setDistrict(dto.getDistrict());
        }
        if (dto.getLatitude() != null) {
            entity.setLatitude(dto.getLatitude());
        }
        if (dto.getLongitude() != null) {
            entity.setLongitude(dto.getLongitude());
        }
        if (dto.getCountry() != null) {
            entity.country((Country)this.countryMapper.toEntity((Object)dto.getCountry()));
        }
        if (dto.getState() != null) {
            entity.state((State)this.stateMapper.toEntity((Object)dto.getState()));
        }
    }

    public AppUserDTO toDto(AppUser s) {
        if (s == null) {
            return null;
        }
        AppUserDTO appUserDTO = new AppUserDTO();
        appUserDTO.setCountryId(this.sCountryId(s));
        appUserDTO.setStateId(this.sStateId(s));
        appUserDTO.setPhoneCode(this.sCountryPhoneCode(s));
        appUserDTO.setCountryName(this.sCountryName(s));
        appUserDTO.setStateName(this.sStateName(s));
        appUserDTO.setCreatedDate(s.getCreatedDate());
        appUserDTO.setId(s.getId());
        appUserDTO.setEmail(s.getEmail());
        appUserDTO.setFirstName(s.getFirstName());
        appUserDTO.setLastName(s.getLastName());
        appUserDTO.setFullName(s.getFullName());
        appUserDTO.setMobileNumber(s.getMobileNumber());
        appUserDTO.setProfilePhotoPath(s.getProfilePhotoPath());
        if (s.getRole() != null) {
            appUserDTO.setRole(s.getRole().name());
        }
        appUserDTO.setStatus(s.getStatus());
        appUserDTO.setPincode(s.getPincode());
        appUserDTO.setCity(s.getCity());
        appUserDTO.setStreet(s.getStreet());
        appUserDTO.setDistrict(s.getDistrict());
        appUserDTO.setLatitude(s.getLatitude());
        appUserDTO.setLongitude(s.getLongitude());
        appUserDTO.setCountry((CountryDTO)this.countryMapper.toDto((Object)s.getCountry()));
        appUserDTO.setState(this.stateMapper.toDto(s.getState()));
        return appUserDTO;
    }

    public AppUser toEntity(AppUserDTO appUserDTO) {
        if (appUserDTO == null) {
            return null;
        }
        AppUser appUser = new AppUser();
        appUser.country(this.appUserDTOToCountry(appUserDTO));
        appUser.state(this.appUserDTOToState(appUserDTO));
        appUser.setCreatedDate(appUserDTO.getCreatedDate());
        appUser.setId(appUserDTO.getId());
        appUser.setEmail(appUserDTO.getEmail());
        appUser.setPassword(appUserDTO.getPassword());
        appUser.setFirstName(appUserDTO.getFirstName());
        appUser.setLastName(appUserDTO.getLastName());
        appUser.setFullName(appUserDTO.getFullName());
        appUser.setMobileNumber(appUserDTO.getMobileNumber());
        appUser.setProfilePhotoPath(appUserDTO.getProfilePhotoPath());
        if (appUserDTO.getRole() != null) {
            appUser.setRole(Enum.valueOf(Role.class, appUserDTO.getRole()));
        }
        appUser.setStatus(appUserDTO.getStatus());
        appUser.setPincode(appUserDTO.getPincode());
        appUser.setCity(appUserDTO.getCity());
        appUser.setStreet(appUserDTO.getStreet());
        appUser.setDistrict(appUserDTO.getDistrict());
        appUser.setLatitude(appUserDTO.getLatitude());
        appUser.setLongitude(appUserDTO.getLongitude());
        return appUser;
    }

    public AppUserDTO toDtoId(AppUser appUser) {
        if (appUser == null) {
            return null;
        }
        AppUserDTO appUserDTO = new AppUserDTO();
        appUserDTO.setId(appUser.getId());
        return appUserDTO;
    }

    private Long sCountryId(AppUser appUser) {
        if (appUser == null) {
            return null;
        }
        Country country = appUser.getCountry();
        if (country == null) {
            return null;
        }
        Long id = country.getId();
        if (id == null) {
            return null;
        }
        return id;
    }

    private Long sStateId(AppUser appUser) {
        if (appUser == null) {
            return null;
        }
        State state = appUser.getState();
        if (state == null) {
            return null;
        }
        Long id = state.getId();
        if (id == null) {
            return null;
        }
        return id;
    }

    private Integer sCountryPhoneCode(AppUser appUser) {
        if (appUser == null) {
            return null;
        }
        Country country = appUser.getCountry();
        if (country == null) {
            return null;
        }
        Integer phoneCode = country.getPhoneCode();
        if (phoneCode == null) {
            return null;
        }
        return phoneCode;
    }

    private String sCountryName(AppUser appUser) {
        if (appUser == null) {
            return null;
        }
        Country country = appUser.getCountry();
        if (country == null) {
            return null;
        }
        String name = country.getName();
        if (name == null) {
            return null;
        }
        return name;
    }

    private String sStateName(AppUser appUser) {
        if (appUser == null) {
            return null;
        }
        State state = appUser.getState();
        if (state == null) {
            return null;
        }
        String name = state.getName();
        if (name == null) {
            return null;
        }
        return name;
    }

    protected Country appUserDTOToCountry(AppUserDTO appUserDTO) {
        if (appUserDTO == null) {
            return null;
        }
        Country country = new Country();
        country.setId(appUserDTO.getCountryId());
        country.setPhoneCode(appUserDTO.getPhoneCode());
        return country;
    }

    protected State appUserDTOToState(AppUserDTO appUserDTO) {
        if (appUserDTO == null) {
            return null;
        }
        State state = new State();
        state.setId(appUserDTO.getStateId());
        return state;
    }
}

