/*
 * Decompiled with CFR 0.152.
 */
package com.upl.digitalmodular.service.impl;

import com.upl.digitalmodular.domain.AppUser;
import com.upl.digitalmodular.domain.Application;
import com.upl.digitalmodular.domain.Notification;
import com.upl.digitalmodular.domain.Query;
import com.upl.digitalmodular.domain.enumeration.Category;
import com.upl.digitalmodular.repository.AppUserRepository;
import com.upl.digitalmodular.repository.ApplicationRepository;
import com.upl.digitalmodular.repository.NotificationRepository;
import com.upl.digitalmodular.repository.QueryRepository;
import com.upl.digitalmodular.security.SecurityUtils;
import com.upl.digitalmodular.service.QueryService;
import com.upl.digitalmodular.service.dto.QueryDTO;
import com.upl.digitalmodular.service.exception.BadRequestException;
import com.upl.digitalmodular.service.mapper.QueryMapper;
import com.upl.digitalmodular.service.utility.I18nUtility;
import java.time.Instant;
import java.util.List;
import java.util.Optional;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;
import org.springframework.beans.factory.annotation.Autowired;
import org.springframework.data.domain.Page;
import org.springframework.data.domain.Pageable;
import org.springframework.stereotype.Service;
import org.springframework.transaction.annotation.Transactional;

@Service
@Transactional
public class QueryServiceImpl
implements QueryService {
    private final Logger log = LoggerFactory.getLogger(QueryServiceImpl.class);
    private final QueryRepository queryRepository;
    private final QueryMapper queryMapper;
    private final AppUserRepository appUserRepository;
    private final ApplicationRepository applicationRepository;
    private final NotificationRepository notificationRepository;
    @Autowired
    private I18nUtility i18nUtility;

    public QueryServiceImpl(QueryRepository queryRepository, QueryMapper queryMapper, AppUserRepository appUserRepository, ApplicationRepository applicationRepository, NotificationRepository notificationRepository) {
        this.queryRepository = queryRepository;
        this.queryMapper = queryMapper;
        this.appUserRepository = appUserRepository;
        this.applicationRepository = applicationRepository;
        this.notificationRepository = notificationRepository;
    }

    public QueryDTO save(QueryDTO queryDTO) {
        this.log.debug("Request to save Query : {}", (Object)queryDTO);
        Query query = (Query)this.queryMapper.toEntity((Object)queryDTO);
        query = (Query)this.queryRepository.save((Object)query);
        AppUser appUser = (AppUser)this.appUserRepository.findById((Object)queryDTO.getAppUser().getId()).get();
        Application application = (Application)this.applicationRepository.findById((Object)queryDTO.getApplication().getId()).get();
        if (queryDTO.getId() == null) {
            Notification notification = new Notification();
            notification.setAppUser(appUser);
            notification.setApplication(application);
            notification.setCategory(Category.QUERIES);
            notification.setDescription(queryDTO.getMessage());
            notification.setReadStatus(Boolean.valueOf(false));
            notification.setStatus(Boolean.valueOf(true));
            notification.setExpires(null);
            this.notificationRepository.save((Object)notification);
        }
        return this.queryMapper.toDto(query);
    }

    public Optional<QueryDTO> partialUpdate(QueryDTO queryDTO) {
        this.log.debug("Request to partially update Query : {}", (Object)queryDTO);
        return this.queryRepository.findById((Object)queryDTO.getId()).map(existingQuery -> {
            this.queryMapper.partialUpdate(existingQuery, (Object)queryDTO);
            return existingQuery;
        }).map(arg_0 -> ((QueryRepository)this.queryRepository).save(arg_0)).map(arg_0 -> ((QueryMapper)this.queryMapper).toDto(arg_0));
    }

    @Transactional(readOnly=true)
    public Page<QueryDTO> findAll(Pageable pageable) {
        this.log.debug("Request to get all Queries");
        return this.queryRepository.findAll(pageable).map(arg_0 -> ((QueryMapper)this.queryMapper).toDto(arg_0));
    }

    @Transactional(readOnly=true)
    public Optional<QueryDTO> findOne(Long id) {
        this.log.debug("Request to get Query : {}", (Object)id);
        if (!this.queryRepository.existsById((Object)id)) {
            String message = this.i18nUtility.getMessage("queryRepository.get.entity.exception", null);
            throw new BadRequestException(message);
        }
        return this.queryRepository.findById((Object)id).map(arg_0 -> ((QueryMapper)this.queryMapper).toDto(arg_0));
    }

    public void delete(Long id) {
        this.log.debug("Request to delete Query : {}", (Object)id);
        Optional query = this.queryRepository.findById((Object)id);
        if (!query.isPresent()) {
            String message = this.i18nUtility.getMessage("queryRepository.delete.id.exception", null);
            throw new BadRequestException(message);
        }
        ((Query)query.get()).setStatus(Boolean.valueOf(false));
        this.queryRepository.save((Object)((Query)query.get()));
    }

    public void readQueries(Long id, Boolean readAll) {
        this.log.debug("Rest request to read query");
        Long loggedInUser = Long.parseLong((String)SecurityUtils.getCurrentUserLogin().get());
        if (id != null && readAll.booleanValue()) {
            Optional query = this.queryRepository.findByIdAndAppUserId(id, loggedInUser);
            if (query.isPresent()) {
                ((Query)query.get()).setReadStatus(Boolean.valueOf(true));
                ((Query)query.get()).setReadAt(Instant.now());
                this.queryRepository.save((Object)((Query)query.get()));
            }
        } else if (id == null && readAll.booleanValue()) {
            List queries = this.queryRepository.findByAppUserId(loggedInUser);
            for (Query query : queries) {
                query.setReadStatus(Boolean.valueOf(true));
                query.setReadAt(Instant.now());
                this.queryRepository.save((Object)query);
            }
        }
    }
}

