/*
 * Decompiled with CFR 0.152.
 */
package com.upl.digitalmodular.service.impl;

import com.upl.digitalmodular.domain.AppUser;
import com.upl.digitalmodular.domain.Application;
import com.upl.digitalmodular.domain.ApplicationAccessRequest;
import com.upl.digitalmodular.domain.Notification;
import com.upl.digitalmodular.domain.enumeration.AccessStatus;
import com.upl.digitalmodular.domain.enumeration.Category;
import com.upl.digitalmodular.repository.AppUserRepository;
import com.upl.digitalmodular.repository.ApplicationAccessRequestRepository;
import com.upl.digitalmodular.repository.ApplicationRepository;
import com.upl.digitalmodular.repository.NotificationRepository;
import com.upl.digitalmodular.service.ApplicationAccessRequestService;
import com.upl.digitalmodular.service.dto.ApplicationAccessRequestDTO;
import com.upl.digitalmodular.service.exception.BadRequestException;
import com.upl.digitalmodular.service.mapper.ApplicationAccessRequestMapper;
import com.upl.digitalmodular.service.utility.I18nUtility;
import java.time.Instant;
import java.util.Optional;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;
import org.springframework.beans.factory.annotation.Autowired;
import org.springframework.data.domain.Page;
import org.springframework.data.domain.Pageable;
import org.springframework.stereotype.Service;
import org.springframework.transaction.annotation.Transactional;

@Service
@Transactional
public class ApplicationAccessRequestServiceImpl
implements ApplicationAccessRequestService {
    private final Logger log = LoggerFactory.getLogger(ApplicationAccessRequestServiceImpl.class);
    private final ApplicationAccessRequestRepository applicationAccessRequestRepository;
    private final ApplicationAccessRequestMapper applicationAccessRequestMapper;
    private final AppUserRepository appUserRepository;
    private final NotificationRepository notificationRepository;
    private final ApplicationRepository applicationRepository;
    @Autowired
    private I18nUtility i18nUtility;

    public ApplicationAccessRequestServiceImpl(ApplicationAccessRequestRepository applicationAccessRequestRepository, ApplicationAccessRequestMapper applicationAccessRequestMapper, AppUserRepository appUserRepository, NotificationRepository notificationRepository, ApplicationRepository applicationRepository) {
        this.applicationAccessRequestRepository = applicationAccessRequestRepository;
        this.applicationAccessRequestMapper = applicationAccessRequestMapper;
        this.appUserRepository = appUserRepository;
        this.notificationRepository = notificationRepository;
        this.applicationRepository = applicationRepository;
    }

    public ApplicationAccessRequestDTO save(ApplicationAccessRequestDTO applicationAccessRequestDTO) {
        this.log.debug("Request to save ApplicationAccessRequest : {}", (Object)applicationAccessRequestDTO);
        ApplicationAccessRequest applicationAccessRequest = (ApplicationAccessRequest)this.applicationAccessRequestMapper.toEntity((Object)applicationAccessRequestDTO);
        AppUser appUser = (AppUser)this.appUserRepository.findById((Object)applicationAccessRequestDTO.getAppUser().getId()).get();
        Application application = (Application)this.applicationRepository.findById((Object)applicationAccessRequestDTO.getApplication().getId()).get();
        Optional requestExists = this.applicationAccessRequestRepository.findByAppUserIdAndApplicationId(appUser.getId(), application.getId());
        if (applicationAccessRequestDTO.getId() == null) {
            if (requestExists.isPresent()) {
                AccessStatus status = ((ApplicationAccessRequest)requestExists.get()).getStatus();
                if (status.equals((Object)AccessStatus.ACCEPTED)) {
                    String message = this.i18nUtility.getMessage("applicationAccessRequestRepository.already.existed.exception", null);
                    throw new BadRequestException(message);
                }
                if (status.equals((Object)AccessStatus.PENDING)) {
                    String message = this.i18nUtility.getMessage("applicationAccessRequestRepository.already.pending.exception", null);
                    throw new BadRequestException(message);
                }
                if (status.equals((Object)AccessStatus.DELETED) || status.equals((Object)AccessStatus.REJECTED)) {
                    ((ApplicationAccessRequest)requestExists.get()).setStatus(AccessStatus.PENDING);
                    applicationAccessRequest.setRequestDate(Instant.now());
                    applicationAccessRequest = (ApplicationAccessRequest)this.applicationAccessRequestRepository.save((Object)((ApplicationAccessRequest)requestExists.get()));
                    this.sendRequestNotification(appUser, application, Boolean.valueOf(true));
                    return this.applicationAccessRequestMapper.toDto((ApplicationAccessRequest)requestExists.get());
                }
            }
            applicationAccessRequest.setRequestDate(Instant.now());
            this.sendRequestNotification(appUser, application, Boolean.valueOf(true));
            applicationAccessRequest = (ApplicationAccessRequest)this.applicationAccessRequestRepository.save((Object)applicationAccessRequest);
            return this.applicationAccessRequestMapper.toDto(applicationAccessRequest);
        }
        if (applicationAccessRequestDTO.getId() != null && applicationAccessRequestDTO.getStatus().equals((Object)AccessStatus.REJECTED)) {
            ApplicationAccessRequest existsRequest = (ApplicationAccessRequest)this.applicationAccessRequestRepository.findById((Object)applicationAccessRequestDTO.getId()).get();
            this.sendRequestNotification(appUser, application, Boolean.valueOf(false));
            existsRequest.setStatus(AccessStatus.REJECTED);
            existsRequest = (ApplicationAccessRequest)this.applicationAccessRequestRepository.save((Object)existsRequest);
            Optional requestNotification = this.notificationRepository.findByAppUserIdAndApplicationIdAndStatusTrueAndCategoryIs(appUser.getId(), application.getId(), Category.REQUESTACCESS);
            if (requestNotification.isPresent()) {
                ((Notification)requestNotification.get()).setStatus(Boolean.valueOf(false));
                this.notificationRepository.save((Object)((Notification)requestNotification.get()));
            }
            return this.applicationAccessRequestMapper.toDto(existsRequest);
        }
        applicationAccessRequest = (ApplicationAccessRequest)this.applicationAccessRequestRepository.save((Object)applicationAccessRequest);
        return this.applicationAccessRequestMapper.toDto(applicationAccessRequest);
    }

    public Optional<ApplicationAccessRequestDTO> partialUpdate(ApplicationAccessRequestDTO applicationAccessRequestDTO) {
        this.log.debug("Request to partially update ApplicationAccessRequest : {}", (Object)applicationAccessRequestDTO);
        return this.applicationAccessRequestRepository.findById((Object)applicationAccessRequestDTO.getId()).map(existingApplicationAccessRequest -> {
            this.applicationAccessRequestMapper.partialUpdate(existingApplicationAccessRequest, (Object)applicationAccessRequestDTO);
            return existingApplicationAccessRequest;
        }).map(arg_0 -> ((ApplicationAccessRequestRepository)this.applicationAccessRequestRepository).save(arg_0)).map(arg_0 -> ((ApplicationAccessRequestMapper)this.applicationAccessRequestMapper).toDto(arg_0));
    }

    @Transactional(readOnly=true)
    public Page<ApplicationAccessRequestDTO> findAll(Pageable pageable) {
        this.log.debug("Request to get all ApplicationAccessRequests");
        return this.applicationAccessRequestRepository.findAll(pageable).map(arg_0 -> ((ApplicationAccessRequestMapper)this.applicationAccessRequestMapper).toDto(arg_0));
    }

    @Transactional(readOnly=true)
    public Optional<ApplicationAccessRequestDTO> findOne(Long id) {
        this.log.debug("Request to get ApplicationAccessRequest : {}", (Object)id);
        if (!this.applicationAccessRequestRepository.existsById((Object)id)) {
            String message = this.i18nUtility.getMessage("applicationAccessRequestRepository.get.entity.exception", null);
            throw new BadRequestException(message);
        }
        return this.applicationAccessRequestRepository.findById((Object)id).map(arg_0 -> ((ApplicationAccessRequestMapper)this.applicationAccessRequestMapper).toDto(arg_0));
    }

    public void delete(Long id) {
        this.log.debug("Request to delete ApplicationAccessRequest : {}", (Object)id);
        Optional request = this.applicationAccessRequestRepository.findById((Object)id);
        if (!request.isPresent()) {
            String message = this.i18nUtility.getMessage("applicationAccessRequestRepository.delete.id.exception", null);
            throw new BadRequestException(message);
        }
        ((ApplicationAccessRequest)request.get()).setStatus(AccessStatus.DELETED);
        this.applicationAccessRequestRepository.save((Object)((ApplicationAccessRequest)request.get()));
    }

    private void sendRequestNotification(AppUser appUser, Application application, Boolean check) {
        Notification notification = new Notification();
        notification.setAppUser(appUser);
        notification.setApplication(application);
        notification.setReadStatus(Boolean.valueOf(false));
        notification.setStatus(Boolean.valueOf(true));
        notification.setExpires(null);
        if (check.booleanValue()) {
            notification.setCategory(Category.REQUESTACCESS);
            notification.setDescription(appUser.getFullName() + " requested to access of " + application.getName() + " application");
            Notification userNotification = new Notification();
            userNotification.setAppUser(appUser);
            userNotification.setApplication(application);
            userNotification.setReadStatus(Boolean.valueOf(false));
            userNotification.setStatus(Boolean.valueOf(true));
            userNotification.setExpires(null);
            userNotification.setCategory(Category.NOTICE);
            userNotification.setDescription("You have requested access for " + application.getName() + " application");
            this.notificationRepository.save((Object)userNotification);
        } else {
            notification.setCategory(Category.NOTICE);
            notification.setDescription("Request for " + application.getName() + " application has been rejected");
        }
        this.notificationRepository.save((Object)notification);
    }

    public Boolean checkApplicationRequest(Long userid, Long applicationId) {
        AccessStatus status;
        Optional request = this.applicationAccessRequestRepository.findByAppUserIdAndApplicationId(userid, applicationId);
        boolean requestCheck = false;
        if (request.isPresent() && ((status = ((ApplicationAccessRequest)request.get()).getStatus()).equals((Object)AccessStatus.PENDING) || status.equals((Object)AccessStatus.ACCEPTED))) {
            requestCheck = true;
        }
        return requestCheck;
    }
}

