/*
 * Decompiled with CFR 0.152.
 */
package com.upl.digitalmodular.service;

import com.upl.digitalmodular.domain.AppUser;
import com.upl.digitalmodular.domain.AppUser_;
import com.upl.digitalmodular.domain.Country_;
import com.upl.digitalmodular.domain.State_;
import com.upl.digitalmodular.repository.AppUserRepository;
import com.upl.digitalmodular.service.criteria.AppUserCriteria;
import com.upl.digitalmodular.service.dto.AppUserDTO;
import com.upl.digitalmodular.service.mapper.AppUserMapper;
import java.util.List;
import javax.persistence.criteria.JoinType;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;
import org.springframework.data.domain.Page;
import org.springframework.data.domain.Pageable;
import org.springframework.data.jpa.domain.Specification;
import org.springframework.stereotype.Service;
import org.springframework.transaction.annotation.Transactional;
import tech.jhipster.service.QueryService;
import tech.jhipster.service.filter.BooleanFilter;
import tech.jhipster.service.filter.Filter;
import tech.jhipster.service.filter.RangeFilter;

@Service
@Transactional(readOnly=true)
public class AppUserQueryService
extends QueryService<AppUser> {
    private final Logger log = LoggerFactory.getLogger(AppUserQueryService.class);
    private final AppUserRepository appUserRepository;
    private final AppUserMapper appUserMapper;

    public AppUserQueryService(AppUserRepository appUserRepository, AppUserMapper appUserMapper) {
        this.appUserRepository = appUserRepository;
        this.appUserMapper = appUserMapper;
    }

    @Transactional(readOnly=true)
    public List<AppUserDTO> findByCriteria(AppUserCriteria criteria) {
        this.log.debug("find by criteria : {}", (Object)criteria);
        Specification specification = this.createSpecification(criteria);
        return this.appUserMapper.toDto(this.appUserRepository.findAll(specification));
    }

    @Transactional(readOnly=true)
    public Page<AppUserDTO> findByCriteria(AppUserCriteria criteria, Pageable page) {
        this.log.debug("find by criteria : {}, page: {}", (Object)criteria, (Object)page);
        BooleanFilter statusFilter = new BooleanFilter();
        statusFilter.setEquals((Object)true);
        criteria.setStatus(statusFilter);
        Specification specification = this.createSpecification(criteria);
        return this.appUserRepository.findAll(specification, page).map(arg_0 -> ((AppUserMapper)this.appUserMapper).toDto(arg_0));
    }

    @Transactional(readOnly=true)
    public long countByCriteria(AppUserCriteria criteria) {
        this.log.debug("count by criteria : {}", (Object)criteria);
        Specification specification = this.createSpecification(criteria);
        return this.appUserRepository.count(specification);
    }

    protected Specification<AppUser> createSpecification(AppUserCriteria criteria) {
        Specification specification = Specification.where(null);
        if (criteria != null) {
            if (criteria.getDistinct() != null) {
                specification = specification.and(this.distinct(criteria.getDistinct().booleanValue()));
            }
            if (criteria.getId() != null) {
                specification = specification.and(this.buildRangeSpecification((RangeFilter)criteria.getId(), AppUser_.id));
            }
            if (criteria.getEmail() != null) {
                specification = specification.and(this.buildStringSpecification(criteria.getEmail(), AppUser_.email));
            }
            if (criteria.getPassword() != null) {
                specification = specification.and(this.buildStringSpecification(criteria.getPassword(), AppUser_.password));
            }
            if (criteria.getFirstName() != null) {
                specification = specification.and(this.buildStringSpecification(criteria.getFirstName(), AppUser_.firstName));
            }
            if (criteria.getLastName() != null) {
                specification = specification.and(this.buildStringSpecification(criteria.getLastName(), AppUser_.lastName));
            }
            if (criteria.getFullName() != null) {
                specification = specification.and(this.buildStringSpecification(criteria.getFullName(), AppUser_.fullName));
            }
            if (criteria.getMobileNumber() != null) {
                specification = specification.and(this.buildStringSpecification(criteria.getMobileNumber(), AppUser_.mobileNumber));
            }
            if (criteria.getProfilePhotoPath() != null) {
                specification = specification.and(this.buildStringSpecification(criteria.getProfilePhotoPath(), AppUser_.profilePhotoPath));
            }
            if (criteria.getRole() != null) {
                specification = specification.and(this.buildSpecification((Filter)criteria.getRole(), AppUser_.role));
            }
            if (criteria.getStatus() != null) {
                specification = specification.and(this.buildSpecification((Filter)criteria.getStatus(), AppUser_.status));
            }
            if (criteria.getPincode() != null) {
                specification = specification.and(this.buildStringSpecification(criteria.getPincode(), AppUser_.pincode));
            }
            if (criteria.getCity() != null) {
                specification = specification.and(this.buildStringSpecification(criteria.getCity(), AppUser_.city));
            }
            if (criteria.getStreet() != null) {
                specification = specification.and(this.buildStringSpecification(criteria.getStreet(), AppUser_.street));
            }
            if (criteria.getDistrict() != null) {
                specification = specification.and(this.buildStringSpecification(criteria.getDistrict(), AppUser_.district));
            }
            if (criteria.getLatitude() != null) {
                specification = specification.and(this.buildRangeSpecification((RangeFilter)criteria.getLatitude(), AppUser_.latitude));
            }
            if (criteria.getLongitude() != null) {
                specification = specification.and(this.buildRangeSpecification((RangeFilter)criteria.getLongitude(), AppUser_.longitude));
            }
            if (criteria.getCountryId() != null) {
                specification = specification.and(this.buildSpecification((RangeFilter)criteria.getCountryId(), root -> root.join(AppUser_.country, JoinType.LEFT).get(Country_.id)));
            }
            if (criteria.getStateId() != null) {
                specification = specification.and(this.buildSpecification((RangeFilter)criteria.getStateId(), root -> root.join(AppUser_.state, JoinType.LEFT).get(State_.id)));
            }
        }
        return specification;
    }
}

