/*
 * Decompiled with CFR 0.152.
 */
package com.upl.digitalmodular.domain;

import com.fasterxml.jackson.annotation.JsonIgnoreProperties;
import com.upl.digitalmodular.domain.Application;
import java.io.Serializable;
import java.util.HashSet;
import java.util.Set;
import javax.persistence.Column;
import javax.persistence.Entity;
import javax.persistence.GeneratedValue;
import javax.persistence.GenerationType;
import javax.persistence.Id;
import javax.persistence.ManyToMany;
import javax.persistence.Table;
import javax.validation.constraints.NotNull;
import org.hibernate.annotations.Cache;
import org.hibernate.annotations.CacheConcurrencyStrategy;

@Entity
@Table(name="application_roles")
@Cache(usage=CacheConcurrencyStrategy.READ_WRITE)
public class ApplicationRoles
implements Serializable {
    private static final long serialVersionUID = 1L;
    @Id
    @GeneratedValue(strategy=GenerationType.IDENTITY)
    @Column(name="id")
    private Long id;
    @NotNull
    @Column(name="name", nullable=false)
    private String name;
    @Column(name="description")
    private String description;
    @Column(name="status")
    private Boolean status;
    @ManyToMany(mappedBy="applicationRoles")
    @Cache(usage=CacheConcurrencyStrategy.READ_WRITE)
    @JsonIgnoreProperties(value={"applicationRoles"}, allowSetters=true)
    private Set<Application> applications = new HashSet();

    public Long getId() {
        return this.id;
    }

    public ApplicationRoles id(Long id) {
        this.setId(id);
        return this;
    }

    public void setId(Long id) {
        this.id = id;
    }

    public String getName() {
        return this.name;
    }

    public ApplicationRoles name(String name) {
        this.setName(name);
        return this;
    }

    public void setName(String name) {
        this.name = name;
    }

    public String getDescription() {
        return this.description;
    }

    public ApplicationRoles description(String description) {
        this.setDescription(description);
        return this;
    }

    public void setDescription(String description) {
        this.description = description;
    }

    public Boolean getStatus() {
        return this.status;
    }

    public ApplicationRoles status(Boolean status) {
        this.setStatus(status);
        return this;
    }

    public void setStatus(Boolean status) {
        this.status = status;
    }

    public Set<Application> getApplications() {
        return this.applications;
    }

    public void setApplications(Set<Application> applications) {
        if (this.applications != null) {
            this.applications.forEach(i -> i.removeApplicationRoles(this));
        }
        if (applications != null) {
            applications.forEach(i -> i.addApplicationRoles(this));
        }
        this.applications = applications;
    }

    public ApplicationRoles applications(Set<Application> applications) {
        this.setApplications(applications);
        return this;
    }

    public ApplicationRoles addApplication(Application application) {
        this.applications.add(application);
        application.getApplicationRoles().add(this);
        return this;
    }

    public ApplicationRoles removeApplication(Application application) {
        this.applications.remove(application);
        application.getApplicationRoles().remove(this);
        return this;
    }

    public boolean equals(Object o) {
        if (this == o) {
            return true;
        }
        if (!(o instanceof ApplicationRoles)) {
            return false;
        }
        return this.id != null && this.id.equals(((ApplicationRoles)o).id);
    }

    public int hashCode() {
        return this.getClass().hashCode();
    }

    public String toString() {
        return "ApplicationRoles{id=" + this.getId() + ", name='" + this.getName() + "', description='" + this.getDescription() + "', status='" + this.getStatus() + "'}";
    }
}

