/*
 * Decompiled with CFR 0.152.
 */
package com.upl.digitalmodular.domain;

import com.fasterxml.jackson.annotation.JsonIgnoreProperties;
import com.upl.digitalmodular.domain.AbstractAuditingEntity;
import com.upl.digitalmodular.domain.AppUser;
import com.upl.digitalmodular.domain.Application;
import com.upl.digitalmodular.domain.enumeration.AccessStatus;
import java.io.Serializable;
import java.time.Instant;
import javax.persistence.Column;
import javax.persistence.Entity;
import javax.persistence.EnumType;
import javax.persistence.Enumerated;
import javax.persistence.GeneratedValue;
import javax.persistence.GenerationType;
import javax.persistence.Id;
import javax.persistence.Lob;
import javax.persistence.ManyToOne;
import javax.persistence.Table;
import org.hibernate.annotations.Cache;
import org.hibernate.annotations.CacheConcurrencyStrategy;

@Entity
@Table(name="application_access_requests")
@Cache(usage=CacheConcurrencyStrategy.READ_WRITE)
public class ApplicationAccessRequest
extends AbstractAuditingEntity
implements Serializable {
    private static final long serialVersionUID = 1L;
    @Id
    @GeneratedValue(strategy=GenerationType.IDENTITY)
    @Column(name="id")
    private Long id;
    @Column(name="request_date")
    private Instant requestDate;
    @Lob
    @Column(name="query", nullable=false)
    private String query;
    @Enumerated(value=EnumType.STRING)
    @Column(name="status")
    private AccessStatus status;
    @ManyToOne
    @JsonIgnoreProperties(value={"applicationRoles"})
    private Application application;
    @ManyToOne
    @JsonIgnoreProperties(value={"country", "state"})
    private AppUser appUser;

    public Long getId() {
        return this.id;
    }

    public ApplicationAccessRequest id(Long id) {
        this.setId(id);
        return this;
    }

    public void setId(Long id) {
        this.id = id;
    }

    public Instant getRequestDate() {
        return this.requestDate;
    }

    public ApplicationAccessRequest requestDate(Instant requestDate) {
        this.setRequestDate(requestDate);
        return this;
    }

    public void setRequestDate(Instant requestDate) {
        this.requestDate = requestDate;
    }

    public String getQuery() {
        return this.query;
    }

    public ApplicationAccessRequest query(String query) {
        this.setQuery(query);
        return this;
    }

    public void setQuery(String query) {
        this.query = query;
    }

    public AccessStatus getStatus() {
        return this.status;
    }

    public ApplicationAccessRequest status(AccessStatus status) {
        this.setStatus(status);
        return this;
    }

    public void setStatus(AccessStatus status) {
        this.status = status;
    }

    public Application getApplication() {
        return this.application;
    }

    public void setApplication(Application application) {
        this.application = application;
    }

    public ApplicationAccessRequest application(Application application) {
        this.setApplication(application);
        return this;
    }

    public AppUser getAppUser() {
        return this.appUser;
    }

    public void setAppUser(AppUser appUser) {
        this.appUser = appUser;
    }

    public ApplicationAccessRequest appUser(AppUser appUser) {
        this.setAppUser(appUser);
        return this;
    }

    public boolean equals(Object o) {
        if (this == o) {
            return true;
        }
        if (!(o instanceof ApplicationAccessRequest)) {
            return false;
        }
        return this.id != null && this.id.equals(((ApplicationAccessRequest)o).id);
    }

    public int hashCode() {
        return this.getClass().hashCode();
    }

    public String toString() {
        return "ApplicationAccessRequest{id=" + this.getId() + ", requestDate='" + this.getRequestDate() + "', query='" + this.getQuery() + "', status='" + this.getStatus() + "'}";
    }
}

