/*
 * Decompiled with CFR 0.152.
 */
package com.upl.digitalmodular.domain;

import com.fasterxml.jackson.annotation.JsonIgnoreProperties;
import com.upl.digitalmodular.domain.ApplicationRoles;
import java.io.Serializable;
import java.util.HashSet;
import java.util.Set;
import javax.persistence.Column;
import javax.persistence.Entity;
import javax.persistence.GeneratedValue;
import javax.persistence.GenerationType;
import javax.persistence.Id;
import javax.persistence.JoinColumn;
import javax.persistence.JoinTable;
import javax.persistence.ManyToMany;
import javax.persistence.Table;
import javax.validation.constraints.NotNull;
import org.hibernate.annotations.Cache;
import org.hibernate.annotations.CacheConcurrencyStrategy;

@Entity
@Table(name="applications")
@Cache(usage=CacheConcurrencyStrategy.READ_WRITE)
public class Application
implements Serializable {
    private static final long serialVersionUID = 1L;
    @Id
    @GeneratedValue(strategy=GenerationType.IDENTITY)
    @Column(name="id")
    private Long id;
    @NotNull
    @Column(name="name", nullable=false)
    private String name;
    @Column(name="title")
    private String title;
    @Column(name="description", length=1000)
    private String description;
    @NotNull
    @Column(name="application_url", nullable=false)
    private String applicationUrl;
    @NotNull
    @Column(name="application_api_url", nullable=false)
    private String applicationApiUrl;
    @Column(name="application_logo")
    private String applicationLogo;
    @Column(name="status")
    private Boolean status;
    @ManyToMany
    @JoinTable(name="rel_applications__application_roles", joinColumns={@JoinColumn(name="applications_id")}, inverseJoinColumns={@JoinColumn(name="application_roles_id")})
    @Cache(usage=CacheConcurrencyStrategy.READ_WRITE)
    @JsonIgnoreProperties(value={"applications"})
    private Set<ApplicationRoles> applicationRoles = new HashSet();

    public Long getId() {
        return this.id;
    }

    public Application id(Long id) {
        this.setId(id);
        return this;
    }

    public void setId(Long id) {
        this.id = id;
    }

    public String getName() {
        return this.name;
    }

    public Application name(String name) {
        this.setName(name);
        return this;
    }

    public void setName(String name) {
        this.name = name;
    }

    public String getTitle() {
        return this.title;
    }

    public void setTitle(String title) {
        this.title = title;
    }

    public String getDescription() {
        return this.description;
    }

    public Application description(String description) {
        this.setDescription(description);
        return this;
    }

    public void setDescription(String description) {
        this.description = description;
    }

    public String getApplicationUrl() {
        return this.applicationUrl;
    }

    public Application applicationUrl(String applicationUrl) {
        this.setApplicationUrl(applicationUrl);
        return this;
    }

    public void setApplicationUrl(String applicationUrl) {
        this.applicationUrl = applicationUrl;
    }

    public String getApplicationApiUrl() {
        return this.applicationApiUrl;
    }

    public void setApplicationApiUrl(String applicationApiUrl) {
        this.applicationApiUrl = applicationApiUrl;
    }

    public String getApplicationLogo() {
        return this.applicationLogo;
    }

    public Application applicationLogo(String applicationLogo) {
        this.setApplicationLogo(applicationLogo);
        return this;
    }

    public void setApplicationLogo(String applicationLogo) {
        this.applicationLogo = applicationLogo;
    }

    public Boolean getStatus() {
        return this.status;
    }

    public Application status(Boolean status) {
        this.setStatus(status);
        return this;
    }

    public void setStatus(Boolean status) {
        this.status = status;
    }

    public Set<ApplicationRoles> getApplicationRoles() {
        return this.applicationRoles;
    }

    public void setApplicationRoles(Set<ApplicationRoles> applicationRoles) {
        this.applicationRoles = applicationRoles;
    }

    public Application applicationRoles(Set<ApplicationRoles> applicationRoles) {
        this.setApplicationRoles(applicationRoles);
        return this;
    }

    public Application addApplicationRoles(ApplicationRoles applicationRoles) {
        this.applicationRoles.add(applicationRoles);
        applicationRoles.getApplications().add(this);
        return this;
    }

    public Application removeApplicationRoles(ApplicationRoles applicationRoles) {
        this.applicationRoles.remove(applicationRoles);
        applicationRoles.getApplications().remove(this);
        return this;
    }

    public boolean equals(Object o) {
        if (this == o) {
            return true;
        }
        if (!(o instanceof Application)) {
            return false;
        }
        return this.id != null && this.id.equals(((Application)o).id);
    }

    public int hashCode() {
        return this.getClass().hashCode();
    }

    public String toString() {
        return "Application{id=" + this.getId() + ", name='" + this.getName() + "', title='" + this.getTitle() + "', description='" + this.getDescription() + "', applicationUrl='" + this.getApplicationUrl() + "', applicationLogo='" + this.getApplicationLogo() + "', status='" + this.getStatus() + "'}";
    }
}

