/*
 * Decompiled with CFR 0.152.
 */
package com.upl.digitalmodular.config;

import com.upl.digitalmodular.domain.AppUser;
import com.upl.digitalmodular.domain.AppUserApplicationAccess;
import com.upl.digitalmodular.domain.AppUserLogin;
import com.upl.digitalmodular.domain.Application;
import com.upl.digitalmodular.domain.ApplicationAccessRequest;
import com.upl.digitalmodular.domain.ApplicationRoles;
import com.upl.digitalmodular.domain.Country;
import com.upl.digitalmodular.domain.Notification;
import com.upl.digitalmodular.domain.Query;
import com.upl.digitalmodular.domain.State;
import java.time.Duration;
import javax.cache.Cache;
import javax.cache.CacheManager;
import org.ehcache.config.Builder;
import org.ehcache.config.builders.CacheConfigurationBuilder;
import org.ehcache.config.builders.ExpiryPolicyBuilder;
import org.ehcache.config.builders.ResourcePoolsBuilder;
import org.ehcache.jsr107.Eh107Configuration;
import org.springframework.beans.factory.annotation.Autowired;
import org.springframework.boot.autoconfigure.cache.JCacheManagerCustomizer;
import org.springframework.boot.autoconfigure.orm.jpa.HibernatePropertiesCustomizer;
import org.springframework.boot.info.BuildProperties;
import org.springframework.boot.info.GitProperties;
import org.springframework.cache.annotation.EnableCaching;
import org.springframework.cache.interceptor.KeyGenerator;
import org.springframework.context.annotation.Bean;
import org.springframework.context.annotation.Configuration;
import tech.jhipster.config.JHipsterProperties;
import tech.jhipster.config.cache.PrefixedKeyGenerator;

@Configuration
@EnableCaching
public class CacheConfiguration {
    private GitProperties gitProperties;
    private BuildProperties buildProperties;
    private final javax.cache.configuration.Configuration<Object, Object> jcacheConfiguration;

    public CacheConfiguration(JHipsterProperties jHipsterProperties) {
        JHipsterProperties.Cache.Ehcache ehcache = jHipsterProperties.getCache().getEhcache();
        this.jcacheConfiguration = Eh107Configuration.fromEhcacheCacheConfiguration((org.ehcache.config.CacheConfiguration)CacheConfigurationBuilder.newCacheConfigurationBuilder(Object.class, Object.class, (Builder)ResourcePoolsBuilder.heap((long)ehcache.getMaxEntries())).withExpiry(ExpiryPolicyBuilder.timeToLiveExpiration((Duration)Duration.ofSeconds(ehcache.getTimeToLiveSeconds()))).build());
    }

    @Bean
    public HibernatePropertiesCustomizer hibernatePropertiesCustomizer(CacheManager cacheManager) {
        return hibernateProperties -> hibernateProperties.put("hibernate.javax.cache.cache_manager", cacheManager);
    }

    @Bean
    public JCacheManagerCustomizer cacheManagerCustomizer() {
        return cm -> {
            this.createCache(cm, AppUser.class.getName());
            this.createCache(cm, Country.class.getName());
            this.createCache(cm, Application.class.getName());
            this.createCache(cm, Application.class.getName() + ".applicationRoles");
            this.createCache(cm, ApplicationRoles.class.getName());
            this.createCache(cm, ApplicationRoles.class.getName() + ".applications");
            this.createCache(cm, State.class.getName());
            this.createCache(cm, ApplicationAccessRequest.class.getName());
            this.createCache(cm, Notification.class.getName());
            this.createCache(cm, AppUserApplicationAccess.class.getName());
            this.createCache(cm, AppUserLogin.class.getName());
            this.createCache(cm, Query.class.getName());
        };
    }

    private void createCache(CacheManager cm, String cacheName) {
        Cache cache = cm.getCache(cacheName);
        if (cache != null) {
            cache.clear();
        } else {
            cm.createCache(cacheName, this.jcacheConfiguration);
        }
    }

    @Autowired(required=false)
    public void setGitProperties(GitProperties gitProperties) {
        this.gitProperties = gitProperties;
    }

    @Autowired(required=false)
    public void setBuildProperties(BuildProperties buildProperties) {
        this.buildProperties = buildProperties;
    }

    @Bean
    public KeyGenerator keyGenerator() {
        return new PrefixedKeyGenerator(this.gitProperties, this.buildProperties);
    }
}

